/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import javafx.animation.AnimationTimer;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Rectangle2D;
import javafx.scene.SnapshotParameters;
import javafx.scene.SubScene;
import javafx.scene.image.Image;
import javafx.scene.image.WritableImage;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import us.ihmc.codecs.builder.H264Settings;
import us.ihmc.codecs.builder.MP4H264MovieBuilder;
import us.ihmc.codecs.generated.EProfileIdc;
import us.ihmc.codecs.generated.EUsageType;
import us.ihmc.commons.Conversions;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;

public class VideoRecordingManager {
    private final SubScene scene;
    private final SessionVisualizerTopics topics;
    private final BufferedJavaFXMessager messager;
    private final AtomicReference<YoBufferPropertiesReadOnly> currentBufferProperties;
    private final AtomicReference<SessionMode> currentSessionMode;
    private final AtomicReference<Long> sessionDT;
    private final AtomicReference<Integer> bufferRecordTickPeriod;
    private final AtomicReference<Recorder> activeRecorder = new AtomicReference<Object>(null);

    public VideoRecordingManager(SubScene scene, SessionVisualizerTopics topics, BufferedJavaFXMessager messager) {
        this.scene = scene;
        this.messager = messager;
        this.topics = topics;
        this.currentBufferProperties = messager.createInput(topics.getYoBufferCurrentProperties());
        this.currentSessionMode = messager.createInput(topics.getSessionCurrentMode());
        this.sessionDT = messager.createInput(topics.getSessionDTNanoseconds());
        this.bufferRecordTickPeriod = messager.createInput(topics.getBufferRecordTickPeriod());
        messager.registerTopicListener(topics.getSceneVideoRecordingRequest(), request -> this.submitRequest((SceneVideoRecordingRequest)request));
    }

    private void submitRequest(SceneVideoRecordingRequest request) {
        LogTools.info((String)("Received video export request: " + request));
        if (this.activeRecorder.get() != null) {
            this.activeRecorder.get().stop();
        }
        SnapshotParameters params = new SnapshotParameters();
        VideoRecordingManager.computeViewport(request.getWidth(), request.getHeight(), this.scene.getWidth(), this.scene.getHeight(), params);
        VideoRecordingManager.computeTransform(request.getWidth(), request.getHeight(), this.scene.getWidth(), this.scene.getHeight(), params);
        Recorder recorder = new Recorder(request, params, () -> {
            this.activeRecorder.set(null);
            this.messager.submitMessage(this.topics.getDisableUserControls(), false);
        });
        this.activeRecorder.set(recorder);
        this.messager.submitMessage(this.topics.getDisableUserControls(), true);
        recorder.start();
    }

    private static SnapshotParameters computeViewport(double outputWidth, double outputHeight, double inputWidth, double inputHeight, SnapshotParameters params) {
        double inputRatio = inputWidth / inputHeight;
        double outputRatio = outputWidth / outputHeight;
        if (!EuclidCoreTools.epsilonEquals((double)inputRatio, (double)outputRatio, (double)1.0E-6)) {
            if (inputRatio > outputRatio) {
                double adjustedWidth = inputHeight * outputRatio;
                double minX = 0.5 * (inputWidth - adjustedWidth);
                double minY = 0.0;
                double width = adjustedWidth;
                double height = inputHeight;
                params.setViewport(new Rectangle2D(minX, minY, width, height));
            } else {
                double adjustedHeight = inputWidth / outputRatio;
                double minX = 0.0;
                double minY = 0.5 * (inputHeight - adjustedHeight);
                double width = inputWidth;
                double height = adjustedHeight;
                params.setViewport(new Rectangle2D(minX, minY, width, height));
            }
        }
        return params;
    }

    private static SnapshotParameters computeTransform(double outputWidth, double outputHeight, double inputWidth, double inputHeight, SnapshotParameters params) {
        double widthScale = outputWidth / inputWidth;
        double heightScale = outputHeight / inputHeight;
        double scale = Math.max(widthScale, heightScale);
        params.setTransform((Transform)new Scale(scale, scale));
        return params;
    }

    private class Recorder
    extends AnimationTimer {
        private final SceneVideoRecordingRequest request;
        private int bufferStart;
        private int bufferEnd;
        private int currentRecordingBufferIndex;
        private int bufferIndexIncrement = -1;
        private int numberOfBufferTicks = -1;
        private int currentPhase = 0;
        private MP4H264MovieBuilder movieBuilder;
        private final SnapshotParameters params;
        private final Runnable stopListener;
        private BufferedImage bufferedImage;
        private WritableImage jfxImage;

        public Recorder(SceneVideoRecordingRequest request, SnapshotParameters params, Runnable stopListener) {
            this.request = request;
            this.params = params;
            this.stopListener = stopListener;
            this.bufferStart = request.getBufferStart();
            this.bufferEnd = request.getBufferEnd();
            H264Settings settings = new H264Settings();
            settings.setBitrate(request.getWidth() * request.getHeight() / 100);
            settings.setUsageType(EUsageType.CAMERA_VIDEO_REAL_TIME);
            settings.setProfileIdc(EProfileIdc.PRO_HIGH);
            try {
                this.movieBuilder = new MP4H264MovieBuilder(request.getFile(), request.getWidth(), request.getHeight(), (int)request.getFrameRate(), settings);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.bufferedImage = new BufferedImage(request.getWidth(), request.getHeight(), 2);
            this.jfxImage = new WritableImage(request.getWidth(), request.getHeight());
        }

        public void handle(long now) {
            if (VideoRecordingManager.this.currentSessionMode.get() != SessionMode.PAUSE) {
                VideoRecordingManager.this.messager.submitMessage(VideoRecordingManager.this.topics.getSessionCurrentMode(), SessionMode.PAUSE);
                return;
            }
            if (VideoRecordingManager.this.sessionDT.get() == null || VideoRecordingManager.this.bufferRecordTickPeriod.get() == null) {
                return;
            }
            YoBufferPropertiesReadOnly bufferProperties = VideoRecordingManager.this.currentBufferProperties.getAndSet(null);
            if (bufferProperties == null) {
                return;
            }
            switch (this.currentPhase) {
                case 0: {
                    if (this.initialize(bufferProperties)) {
                        ++this.currentPhase;
                    }
                    return;
                }
                case 1: {
                    if (this.recordNextFrame(bufferProperties)) {
                        ++this.currentPhase;
                    }
                    return;
                }
            }
            try {
                this.movieBuilder.close();
                this.stop();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private boolean initialize(YoBufferPropertiesReadOnly bufferProperties) {
            if (this.bufferStart < 0) {
                this.bufferStart = bufferProperties.getInPoint();
            }
            if (this.bufferEnd < 0) {
                this.bufferEnd = bufferProperties.getOutPoint();
            }
            double dt = Conversions.nanosecondsToSeconds((long)VideoRecordingManager.this.sessionDT.get()) * (double)VideoRecordingManager.this.bufferRecordTickPeriod.get().intValue();
            double recordDT = this.request.getRealTimeRate() / this.request.getFrameRate();
            this.bufferIndexIncrement = (int)Math.ceil(recordDT / dt);
            this.currentRecordingBufferIndex = this.bufferStart;
            this.numberOfBufferTicks = SharedMemoryTools.computeSubLength((int)this.bufferStart, (int)this.bufferEnd, (int)bufferProperties.getSize());
            VideoRecordingManager.this.messager.submitMessage(VideoRecordingManager.this.topics.getYoBufferCurrentIndexRequest(), this.currentRecordingBufferIndex);
            return true;
        }

        private boolean recordNextFrame(YoBufferPropertiesReadOnly bufferProperties) {
            if (this.currentRecordingBufferIndex != bufferProperties.getCurrentIndex()) {
                return false;
            }
            this.encodeNextFrame(VideoRecordingManager.this.scene.snapshot(this.params, this.jfxImage));
            this.numberOfBufferTicks -= this.bufferIndexIncrement;
            if (this.numberOfBufferTicks < 0) {
                return true;
            }
            this.currentRecordingBufferIndex = SharedMemoryTools.increment((int)this.currentRecordingBufferIndex, (int)this.bufferIndexIncrement, (int)bufferProperties.getSize());
            VideoRecordingManager.this.messager.submitMessage(VideoRecordingManager.this.topics.getYoBufferCurrentIndexRequest(), this.currentRecordingBufferIndex);
            return false;
        }

        private void encodeNextFrame(WritableImage jfxImageToEncode) {
            if (jfxImageToEncode == null) {
                return;
            }
            this.bufferedImage = SwingFXUtils.fromFXImage((Image)jfxImageToEncode, (BufferedImage)this.bufferedImage);
            try {
                this.movieBuilder.encodeFrame(this.bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.stop();
            }
        }

        public void stop() {
            super.stop();
            this.stopListener.run();
        }
    }
}

