/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor;

import com.jfoenix.controls.JFXColorPicker;
import com.jfoenix.controls.JFXRadioButton;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic2DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXVisualTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;

public class YoGraphic2DStyleEditorPaneController {
    public static final double DEFAULT_STROKE_WIDTH = YoGraphicFX2D.DEFAULT_STROKE_WIDTH.get();
    @FXML
    private GridPane mainPane;
    @FXML
    private JFXRadioButton fillRadioButton;
    @FXML
    private JFXColorPicker fillColorPicker;
    @FXML
    private JFXRadioButton strokeRadioButton;
    @FXML
    private JFXColorPicker strokeColorPicker;
    @FXML
    private TextField strokeWidthTextField;
    @FXML
    private ImageView strokeWidthValidImageView;
    private final ObjectProperty<Color> fillColorProperty = new SimpleObjectProperty((Object)this, "fillColor", null);
    private final ObjectProperty<Color> strokeColorProperty = new SimpleObjectProperty((Object)this, "strokeColor", null);
    private final BooleanProperty strokeWidthValidityProperty = new SimpleBooleanProperty((Object)this, "strokeWidthValidityProperty", false);
    private final DoubleProperty strokeWidthProperty = new SimpleDoubleProperty((Object)this, "strokeWidth", DEFAULT_STROKE_WIDTH);
    private ObservableBooleanValue inputsValidityProperty;

    public void initialize(SessionVisualizerToolkit toolkit) {
        new ToggleGroup().getToggles().addAll((Object[])new Toggle[]{this.fillRadioButton, this.strokeRadioButton});
        this.fillColorPicker.disableProperty().bind((ObservableValue)this.strokeRadioButton.selectedProperty());
        this.strokeColorPicker.disableProperty().bind((ObservableValue)this.fillRadioButton.selectedProperty());
        YoGraphicFXControllerTools.numericalValidityBinding(this.strokeWidthTextField.textProperty(), this.strokeWidthValidityProperty);
        YoGraphicFXControllerTools.bindValidityImageView((ObservableBooleanValue)this.strokeWidthValidityProperty, this.strokeWidthValidImageView);
        this.inputsValidityProperty = this.strokeWidthValidityProperty;
        this.strokeWidthTextField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.strokeWidthValidityProperty.get()) {
                this.strokeWidthProperty.set(Double.parseDouble(newValue));
            }
        });
        this.fillRadioButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.fillColorProperty.set((Object)((Color)this.fillColorPicker.getValue()));
                this.strokeColorProperty.set(null);
            } else {
                this.strokeColorProperty.set((Object)((Color)this.strokeColorPicker.getValue()));
                this.fillColorProperty.set(null);
            }
        });
        this.fillColorPicker.valueProperty().addListener((o, oldValue, newValue) -> this.fillColorProperty.set(newValue));
        this.strokeColorPicker.valueProperty().addListener((o, oldValue, newValue) -> this.strokeColorProperty.set(newValue));
    }

    public void setInput(YoGraphic2DDefinition definition) {
        this.setInput(JavaFXVisualTools.toColor(definition.getFillColor(), null), JavaFXVisualTools.toColor(definition.getStrokeColor(), null), definition.getStrokeWidth());
    }

    public void setInput(Color fillColor, Color strokeColor, String strokeWidth) {
        if (fillColor != null) {
            this.fillRadioButton.setSelected(true);
            this.fillColorPicker.setValue((Object)fillColor);
        } else {
            this.strokeRadioButton.setSelected(true);
            this.strokeColorPicker.setValue((Object)strokeColor);
        }
        this.strokeWidthTextField.setText(strokeWidth);
    }

    public void bindYoGraphicFX2D(YoGraphicFX2D yoGraphicFX2DToBind) {
        this.fillColorProperty.addListener((o, oldValue, newValue) -> yoGraphicFX2DToBind.setFillColor((Color)newValue));
        this.strokeColorProperty.addListener((o, oldValue, newValue) -> yoGraphicFX2DToBind.setStrokeColor((Color)newValue));
        this.strokeWidthProperty.addListener((o, oldValue, newValue) -> yoGraphicFX2DToBind.setStrokeWidth(newValue.doubleValue()));
    }

    public void addInputNotification(Runnable callback) {
        ChangeListener changeListener = (o, oldValue, newValue) -> callback.run();
        this.fillColorProperty.addListener(changeListener);
        this.strokeColorProperty.addListener(changeListener);
        this.strokeWidthProperty.addListener(changeListener);
    }

    public ObservableBooleanValue inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public ReadOnlyObjectProperty<Color> fillColorProperty() {
        return this.fillColorProperty;
    }

    public ReadOnlyObjectProperty<Color> strokeColorProperty() {
        return this.strokeColorProperty;
    }

    public ReadOnlyDoubleProperty strokeWidthProperty() {
        return this.strokeWidthProperty;
    }

    public GridPane getMainPane() {
        return this.mainPane;
    }
}

