/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import javax.xml.bind.JAXBException;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoSlider.YoButtonDefinition;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardListDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000ButtonController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000KnobController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.bcf2000.YoBCF2000SliderController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.BufferedJavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.BCF2000SliderboardController;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;

public class YoBCF2000SliderboardWindowController {
    private static final String BCF2000 = "BCF2000";
    private static final String CONNECTED_STRING = "Connected to BCF2000 sliderboard";
    private static final String NOT_CONNECTED_STRING = "Not connected to BCF2000 sliderboard";
    @FXML
    private AnchorPane mainAnchorPane;
    @FXML
    private YoBCF2000KnobController knob0Controller;
    @FXML
    private YoBCF2000KnobController knob1Controller;
    @FXML
    private YoBCF2000KnobController knob2Controller;
    @FXML
    private YoBCF2000KnobController knob3Controller;
    @FXML
    private YoBCF2000KnobController knob4Controller;
    @FXML
    private YoBCF2000KnobController knob5Controller;
    @FXML
    private YoBCF2000KnobController knob6Controller;
    @FXML
    private YoBCF2000KnobController knob7Controller;
    @FXML
    private YoBCF2000ButtonController button0Controller;
    @FXML
    private YoBCF2000ButtonController button1Controller;
    @FXML
    private YoBCF2000ButtonController button2Controller;
    @FXML
    private YoBCF2000ButtonController button3Controller;
    @FXML
    private YoBCF2000ButtonController button4Controller;
    @FXML
    private YoBCF2000ButtonController button5Controller;
    @FXML
    private YoBCF2000ButtonController button6Controller;
    @FXML
    private YoBCF2000ButtonController button7Controller;
    @FXML
    private YoBCF2000ButtonController button8Controller;
    @FXML
    private YoBCF2000ButtonController button9Controller;
    @FXML
    private YoBCF2000ButtonController button10Controller;
    @FXML
    private YoBCF2000ButtonController button11Controller;
    @FXML
    private YoBCF2000ButtonController button12Controller;
    @FXML
    private YoBCF2000ButtonController button13Controller;
    @FXML
    private YoBCF2000ButtonController button14Controller;
    @FXML
    private YoBCF2000ButtonController button15Controller;
    @FXML
    private YoBCF2000SliderController slider0Controller;
    @FXML
    private YoBCF2000SliderController slider1Controller;
    @FXML
    private YoBCF2000SliderController slider2Controller;
    @FXML
    private YoBCF2000SliderController slider3Controller;
    @FXML
    private YoBCF2000SliderController slider4Controller;
    @FXML
    private YoBCF2000SliderController slider5Controller;
    @FXML
    private YoBCF2000SliderController slider6Controller;
    @FXML
    private YoBCF2000SliderController slider7Controller;
    @FXML
    private Label connectionStateLabel;
    @FXML
    private ImageView connectionStateImageView;
    private List<YoBCF2000KnobController> knobControllers;
    private List<YoBCF2000ButtonController> buttonControllers;
    private List<YoBCF2000SliderController> sliderControllers;
    private Stage window;
    private BCF2000SliderboardController sliderboard;

    public void initialize(SessionVisualizerToolkit toolkit) {
        int i;
        this.knobControllers = Arrays.asList(this.knob0Controller, this.knob1Controller, this.knob2Controller, this.knob3Controller, this.knob4Controller, this.knob5Controller, this.knob6Controller, this.knob7Controller);
        this.buttonControllers = Arrays.asList(this.button0Controller, this.button1Controller, this.button2Controller, this.button3Controller, this.button4Controller, this.button5Controller, this.button6Controller, this.button7Controller, this.button8Controller, this.button9Controller, this.button10Controller, this.button11Controller, this.button12Controller, this.button13Controller, this.button14Controller, this.button15Controller);
        this.sliderControllers = Arrays.asList(this.slider0Controller, this.slider1Controller, this.slider2Controller, this.slider3Controller, this.slider4Controller, this.slider5Controller, this.slider6Controller, this.slider7Controller);
        this.sliderboard = BCF2000SliderboardController.searchAndConnectToDevice();
        if (this.sliderboard == null) {
            LogTools.error((String)"Could not connect to BCF2000 sliderboard");
            this.connectionStateLabel.setText(NOT_CONNECTED_STRING);
            this.connectionStateImageView.setImage(SessionVisualizerIOTools.INVALID_ICON_IMAGE);
        } else {
            this.connectionStateLabel.setText(CONNECTED_STRING);
            this.connectionStateImageView.setImage(SessionVisualizerIOTools.VALID_ICON_IMAGE);
        }
        for (i = 0; i < this.knobControllers.size(); ++i) {
            YoBCF2000KnobController yoKnobController = this.knobControllers.get(i);
            SliderboardVariable knob = this.sliderboard == null ? null : this.sliderboard.getKnob(BCF2000SliderboardController.Knob.values()[i]);
            yoKnobController.initialize(toolkit, knob);
        }
        for (i = 0; i < this.buttonControllers.size(); ++i) {
            YoBCF2000ButtonController yoButtonController = this.buttonControllers.get(i);
            SliderboardVariable button = this.sliderboard == null ? null : this.sliderboard.getButton(BCF2000SliderboardController.Button.values()[i]);
            yoButtonController.initialize(toolkit, button);
        }
        for (i = 0; i < this.sliderControllers.size(); ++i) {
            YoBCF2000SliderController yoSliderController = this.sliderControllers.get(i);
            SliderboardVariable slider = this.sliderboard == null ? null : this.sliderboard.getSlider(BCF2000SliderboardController.Slider.values()[i]);
            yoSliderController.initialize(toolkit, slider);
        }
        if (this.sliderboard != null) {
            this.sliderboard.start();
        }
        this.window = new Stage(StageStyle.UTILITY);
        this.window.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ESCAPE) {
                this.window.close();
            }
        });
        toolkit.getMainWindow().addEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.window.close();
            }
        });
        this.window.setTitle("YoSliderboard controller");
        this.window.setScene(new Scene((Parent)this.mainAnchorPane));
        this.window.initOwner((Window)toolkit.getMainWindow());
        BufferedJavaFXMessager messager = toolkit.getMessager();
        SessionVisualizerTopics topics = toolkit.getTopics();
        File configurationFile = (File)messager.createInput(topics.getYoSliderboardLoadConfiguration()).get();
        if (configurationFile != null) {
            this.load(configurationFile);
        }
        messager.registerJavaFXSyncedTopicListener(topics.getYoSliderboardLoadConfiguration(), this::load);
        messager.registerJavaFXSyncedTopicListener(topics.getYoSliderboardSaveConfiguration(), this::save);
    }

    public void load(File file) {
        LogTools.info((String)("Loading from file: " + file));
        try {
            YoSliderboardListDefinition definition = XMLTools.loadYoSliderboardListDefinition(new FileInputStream(file));
            this.setInput(definition);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void save(File file) {
        LogTools.info((String)("Saving to file: " + file));
        try {
            XMLTools.saveYoSliderboardListDefinition(new FileOutputStream(file), this.toYoSliderboardListDefinition());
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
        }
    }

    public void setInput(YoSliderboardListDefinition input) {
        int i;
        List yoSliderboards = input.getYoSliderboards().stream().filter(yoSliderboard -> BCF2000.equals(yoSliderboard.getType())).collect(Collectors.toList());
        if (yoSliderboards == null || yoSliderboards.isEmpty()) {
            return;
        }
        YoSliderboardDefinition yoSliderboard2 = (YoSliderboardDefinition)yoSliderboards.get(0);
        if (yoSliderboard2.getKnobs() != null) {
            for (i = 0; i < Math.min(this.knobControllers.size(), yoSliderboard2.getKnobs().size()); ++i) {
                this.knobControllers.get(i).setInput((YoKnobDefinition)yoSliderboard2.getKnobs().get(i));
            }
        }
        if (yoSliderboard2.getButtons() != null) {
            for (i = 0; i < Math.min(this.buttonControllers.size(), yoSliderboard2.getButtons().size()); ++i) {
                this.buttonControllers.get(i).setInput((YoButtonDefinition)yoSliderboard2.getButtons().get(i));
            }
        }
        if (yoSliderboard2.getSliders() != null) {
            for (i = 0; i < Math.min(this.sliderControllers.size(), yoSliderboard2.getSliders().size()); ++i) {
                this.sliderControllers.get(i).setInput((YoSliderDefinition)yoSliderboard2.getSliders().get(i));
            }
        }
    }

    public void showWindow() {
        this.window.setOpacity(0.0);
        this.window.toFront();
        this.window.show();
        Timeline timeline = new Timeline();
        KeyFrame key = new KeyFrame(Duration.seconds((double)0.125), new KeyValue[]{new KeyValue((WritableValue)this.window.opacityProperty(), (Object)1.0)});
        timeline.getKeyFrames().add((Object)key);
        timeline.play();
    }

    public void close() {
        for (YoBCF2000ButtonController yoButtonController : this.buttonControllers) {
            yoButtonController.close();
        }
        for (YoBCF2000KnobController yoKnobController : this.knobControllers) {
            yoKnobController.close();
        }
        for (YoBCF2000SliderController yoSliderController : this.sliderControllers) {
            yoSliderController.close();
        }
        if (this.sliderboard != null) {
            this.sliderboard.closeAndDispose();
        }
        this.window.close();
    }

    public Stage getWindow() {
        return this.window;
    }

    public YoSliderboardListDefinition toYoSliderboardListDefinition() {
        YoSliderboardDefinition definition = new YoSliderboardDefinition();
        definition.setType(BCF2000);
        definition.setKnobs(this.knobControllers.stream().map(YoBCF2000KnobController::toYoKnobDefinition).collect(Collectors.toList()));
        definition.setButtons(this.buttonControllers.stream().map(YoBCF2000ButtonController::toYoButtonDefinition).collect(Collectors.toList()));
        definition.setSliders(this.sliderControllers.stream().map(YoBCF2000SliderController::toYoSliderDefinition).collect(Collectors.toList()));
        return new YoSliderboardListDefinition(null, Collections.singletonList(definition));
    }
}

