/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.SnapshotParameters;
import javafx.scene.SubScene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SceneVideoRecordingRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.IntegerConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.PositiveIntegerValueFilter;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class VideoRecordingPreviewPaneController {
    @FXML
    private Stage stage;
    @FXML
    private VBox mainPane;
    @FXML
    private AnchorPane imageViewContainer;
    @FXML
    private ImageView imageView;
    @FXML
    private Rectangle viewportRectangle;
    @FXML
    private Slider currentBufferIndexSlider;
    @FXML
    private ComboBox<String> resolutionComboBox;
    @FXML
    private TextField frameRateTextField;
    @FXML
    private TextField realTimeRateTextField;
    @FXML
    private TextField startIndexTextField;
    @FXML
    private TextField endIndexTextField;
    private final IntegerProperty width = new SimpleIntegerProperty((Object)this, "width", Resolution.FULL_HD_1920x1080.getWidth());
    private final IntegerProperty height = new SimpleIntegerProperty((Object)this, "height", Resolution.FULL_HD_1920x1080.getHeight());
    private Property<Integer> frameRate;
    private Property<Double> realTimeRate;
    private Property<Integer> startIndex;
    private Property<Integer> endIndex;
    private final Property<SnapshotParameters> paramsProperty = new SimpleObjectProperty((Object)this, "params", (Object)new SnapshotParameters());
    private final Property<SessionMode> currentSessionMode = new SimpleObjectProperty((Object)this, "currentSessionMode", null);
    private Property<YoBufferPropertiesReadOnly> bufferProperties;
    private Window owner;
    private SubScene targetScene;
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;

    public void initialize(Window owner, SubScene targetScene, JavaFXMessager messager, SessionVisualizerTopics topics) {
        this.owner = owner;
        this.targetScene = targetScene;
        this.messager = messager;
        this.topics = topics;
        this.resolutionComboBox.setItems(FXCollections.observableArrayList((Object[])Resolution.allDescriptions));
        this.resolutionComboBox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
            Resolution resolution = Resolution.fromDescription(newValue);
            this.width.set(resolution.getWidth());
            this.height.set(resolution.getHeight());
        });
        this.resolutionComboBox.getSelectionModel().select((Object)Resolution.FULL_HD_1920x1080.getDescription());
        messager.bindBidirectional(topics.getSessionCurrentMode(), this.currentSessionMode, false);
        TextFormatter frameRateFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)60, (UnaryOperator)new PositiveIntegerValueFilter());
        TextFormatter realTimeRateFormatter = new TextFormatter((StringConverter)new DoubleStringConverter(), (Object)1.0);
        TextFormatter startFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)-1, this.createBufferIndexFilter());
        TextFormatter endFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)-1, this.createBufferIndexFilter());
        this.frameRateTextField.setTextFormatter(frameRateFormatter);
        this.realTimeRateTextField.setTextFormatter(realTimeRateFormatter);
        this.startIndexTextField.setTextFormatter(startFormatter);
        this.endIndexTextField.setTextFormatter(endFormatter);
        this.frameRate = frameRateFormatter.valueProperty();
        this.realTimeRate = realTimeRateFormatter.valueProperty();
        this.startIndex = startFormatter.valueProperty();
        this.endIndex = endFormatter.valueProperty();
        this.width.addListener((o, oldValue, newValue) -> this.updatePreview());
        this.height.addListener((o, oldValue, newValue) -> this.updatePreview());
        this.frameRate.addListener((o, oldValue, newValue) -> this.updatePreview());
        this.realTimeRate.addListener((o, oldValue, newValue) -> this.updatePreview());
        this.stage.showingProperty().addListener((o, oldValue, newValue) -> this.updatePreview());
        this.currentBufferIndexSlider.valueProperty().addListener((o, oldValue, newValue) -> this.updatePreview());
        messager.submitMessage(topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
        MutableBoolean updatingBufferIndex = new MutableBoolean(false);
        this.bufferProperties = messager.createPropertyInput(topics.getYoBufferCurrentProperties());
        this.currentSessionMode.addListener((o, oldValue, newValue) -> {
            if (newValue != SessionMode.PAUSE) {
                messager.submitMessage(topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
            } else if (this.bufferProperties.getValue() != null) {
                this.currentBufferIndexSlider.setMax((double)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getSize());
                if ((Integer)this.startIndex.getValue() == -1) {
                    this.startIndex.setValue((Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getInPoint());
                }
                if ((Integer)this.endIndex.getValue() == -1) {
                    this.endIndex.setValue((Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getOutPoint());
                }
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        });
        messager.registerJavaFXSyncedTopicListener(topics.getYoBufferCurrentProperties(), m -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            this.currentBufferIndexSlider.setMax((double)m.getSize());
            if ((Integer)this.startIndex.getValue() == -1) {
                this.startIndex.setValue((Object)m.getInPoint());
            }
            if ((Integer)this.endIndex.getValue() == -1) {
                this.endIndex.setValue((Object)m.getOutPoint());
            }
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                this.currentBufferIndexSlider.setValue((double)m.getCurrentIndex());
                updatingBufferIndex.setFalse();
            }
        });
        this.currentBufferIndexSlider.valueProperty().addListener((o, oldValue, newValue) -> {
            if (this.currentSessionMode.getValue() != SessionMode.PAUSE) {
                return;
            }
            if (updatingBufferIndex.isFalse()) {
                updatingBufferIndex.setTrue();
                messager.submitMessage(topics.getYoBufferCurrentIndexRequest(), (Object)newValue.intValue());
                updatingBufferIndex.setFalse();
            }
        });
        this.stage.setTitle("Video export preview and properties");
        owner.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> this.close());
    }

    public void close() {
        this.stage.close();
    }

    private UnaryOperator<TextFormatter.Change> createBufferIndexFilter() {
        return change -> {
            try {
                int index = Integer.parseInt(change.getControlNewText());
                if (index < -1) {
                    return null;
                }
                if (index >= ((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getSize()) {
                    return null;
                }
                return change;
            }
            catch (NumberFormatException e) {
                return null;
            }
        };
    }

    public Stage getStage() {
        return this.stage;
    }

    private void updatePreview() {
        double outputHeight;
        double outputWidth;
        double inputWidth = this.targetScene.getWidth();
        double inputHeight = this.targetScene.getHeight();
        if (this.imageView.getFitWidth() > 0.0) {
            scale = this.imageView.getFitWidth() / inputWidth;
            outputWidth = scale * inputWidth;
            outputHeight = scale * inputHeight;
        } else if (this.imageView.getFitHeight() > 0.0) {
            scale = this.imageView.getFitHeight() / inputHeight;
            outputWidth = scale * inputWidth;
            outputHeight = scale * inputHeight;
        } else {
            outputWidth = inputWidth;
            outputHeight = inputHeight;
        }
        double outputRatio = this.width.getValue().doubleValue() / this.height.getValue().doubleValue();
        double inputRatio = inputWidth / inputHeight;
        VideoRecordingPreviewPaneController.computeTransform(outputWidth, outputHeight, inputWidth, inputHeight, (SnapshotParameters)this.paramsProperty.getValue());
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            WritableImage snapshot = this.targetScene.snapshot((SnapshotParameters)this.paramsProperty.getValue(), null);
            this.imageView.setImage((Image)snapshot);
            VideoRecordingPreviewPaneController.computeViewport(outputRatio, inputRatio, outputWidth, outputHeight, this.viewportRectangle);
            this.stage.sizeToScene();
        });
    }

    @FXML
    private void setIndicesToInOut() {
        this.startIndex.setValue((Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getInPoint());
        this.endIndex.setValue((Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getOutPoint());
    }

    @FXML
    void cancel(ActionEvent event) {
        this.close();
    }

    @FXML
    void exportVideo(ActionEvent event) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath("video"));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("MP4", new String[]{"*.mp4"}));
        File result = fileChooser.showSaveDialog(this.owner);
        if (result == null) {
            return;
        }
        SessionVisualizerIOTools.setDefaultFilePath("video", result);
        SceneVideoRecordingRequest request = new SceneVideoRecordingRequest();
        request.setFile(result);
        request.setBufferStart((Integer)this.startIndex.getValue());
        request.setBufferEnd((Integer)this.endIndex.getValue());
        request.setFrameRate(((Integer)this.frameRate.getValue()).intValue());
        request.setRealTimeRate((Double)this.realTimeRate.getValue());
        request.setWidth(this.width.get());
        request.setHeight(this.height.get());
        this.close();
        this.messager.submitMessage(this.topics.getSceneVideoRecordingRequest(), (Object)request);
    }

    private static void computeViewport(double outputRatio, double inputRatio, double imageWidth, double imageHeight, Rectangle rectangle) {
        double minX = 0.0;
        double minY = 0.0;
        double width = imageWidth;
        double height = imageHeight;
        if (!EuclidCoreTools.epsilonEquals((double)inputRatio, (double)outputRatio, (double)1.0E-6)) {
            if (inputRatio > outputRatio) {
                double adjustedWidth = imageHeight * outputRatio;
                minX = 0.5 * (imageWidth - adjustedWidth);
                minY = 0.0;
                width = adjustedWidth;
                height = imageHeight;
            } else {
                double adjustedHeight = imageWidth / outputRatio;
                minX = 0.0;
                minY = 0.5 * (imageHeight - adjustedHeight);
                width = imageWidth;
                height = adjustedHeight;
            }
        }
        rectangle.setX(minX);
        rectangle.setY(minY);
        rectangle.setWidth(width);
        rectangle.setHeight(height);
    }

    private static SnapshotParameters computeTransform(double outputWidth, double outputHeight, double inputWidth, double inputHeight, SnapshotParameters params) {
        double widthScale = outputWidth / inputWidth;
        double heightScale = outputHeight / inputHeight;
        double scale = Math.min(widthScale, heightScale);
        params.setTransform((Transform)new Scale(scale, scale));
        return params;
    }

    private static enum Resolution {
        SD_640x480("SD (640 x 480)", 640, 480),
        HD_1280x720("HD (1280 x 720)", 1280, 720),
        FULL_HD_1920x1080("Full HD (1920 x 1080)", 1920, 1080),
        QUAD_HD_2560x1440("Quad HD (2560 x 1440)", 2560, 1440);

        private static final Map<String, Resolution> descriptionToEnumConstant;
        private static final String[] allDescriptions;
        private final String description;
        private final int width;
        private final int height;

        private Resolution(String description, int width, int height) {
            this.description = description;
            this.width = width;
            this.height = height;
        }

        public String getDescription() {
            return this.description;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public static Resolution fromDescription(String description) {
            return descriptionToEnumConstant.get(description);
        }

        static {
            descriptionToEnumConstant = Arrays.stream(Resolution.values()).collect(Collectors.toMap(e -> e.getDescription(), Function.identity()));
            allDescriptions = (String[])Arrays.stream(Resolution.values()).map(Resolution::getDescription).toArray(String[]::new);
        }
    }
}

