/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.io.File;
import java.io.IOException;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.scs2.session.log.BlackMagicScrubber;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.FrameData;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.JavaFXPictureConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoDataReader;

public class BlackMagicVideoDataReader
implements VideoDataReader {
    private final BlackMagicScrubber blackMagicScrubber;
    private final JavaFXPictureConverter converter = new JavaFXPictureConverter();
    private final ConcurrentCopier<FrameData> imageBuffer = new ConcurrentCopier(FrameData::new);

    public BlackMagicVideoDataReader(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        this.blackMagicScrubber = new BlackMagicScrubber(camera, dataDirectory, hasTimeBase);
    }

    @Override
    public int getImageHeight() {
        return 0;
    }

    @Override
    public int getImageWidth() {
        return 0;
    }

    @Override
    public void readVideoFrame(long queryRobotTimestamp) {
        try {
            YUVPicture nextFrame = this.blackMagicScrubber.readVideoFrame(queryRobotTimestamp);
            FrameData copyForWriting = (FrameData)this.imageBuffer.getCopyForWriting();
            copyForWriting.queryRobotTimestamp = queryRobotTimestamp;
            copyForWriting.currentRobotTimestamp = this.blackMagicScrubber.getCurrentRobotTimestamp();
            copyForWriting.currentVideoTimestamp = this.blackMagicScrubber.getVideoTimestamp();
            copyForWriting.currentDemuxerTimestamp = this.blackMagicScrubber.getDemuxer().getCurrentPTS();
            copyForWriting.frame = this.converter.toFXImage(nextFrame, copyForWriting.frame);
            this.imageBuffer.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer monitor) throws IOException {
        this.blackMagicScrubber.cropVideo(outputFile, timestampFile, startTimestamp, endTimestamp, monitor);
    }

    @Override
    public String getName() {
        return this.blackMagicScrubber.getName();
    }

    @Override
    public Camera getCamera() {
        return this.blackMagicScrubber.getCamera();
    }

    @Override
    public FrameData pollCurrentFrame() {
        return (FrameData)this.imageBuffer.getCopyForReading();
    }

    @Override
    public int getCurrentIndex() {
        return this.blackMagicScrubber.getCurrentIndex();
    }

    @Override
    public boolean replacedRobotTimestampsContainsIndex(int index) {
        return this.blackMagicScrubber.replacedRobotTimestampsContainsIndex(index);
    }
}

