/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.search;

import us.ihmc.javaFXExtensions.control.UnboundedDoubleSpinnerValueFactory;

public class YoDoubleSpinnerValueFactory
extends UnboundedDoubleSpinnerValueFactory {
    static final double SPINNER_STEP_SIZE = 0.1;

    public YoDoubleSpinnerValueFactory(double initialValue) {
        super(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, initialValue, 0.1);
    }

    public void decrement(int steps) {
        this.setValue(YoDoubleSpinnerValueFactory.decrement((Double)this.getValue(), this.getMin(), this.getMax(), this.isWrapAround(), steps, this.getAmountToStepBy()));
    }

    public void increment(int steps) {
        this.setValue(YoDoubleSpinnerValueFactory.increment((Double)this.getValue(), this.getMin(), this.getMax(), this.isWrapAround(), steps, this.getAmountToStepBy()));
    }

    public static double decrement(double currentValue, double min, double max, boolean wrapAround, int steps, double amountToStepBy) {
        double newValue = YoDoubleSpinnerValueFactory.roundToULP(currentValue - amountToStepBy * (double)steps);
        if (newValue < min) {
            newValue = wrapAround ? YoDoubleSpinnerValueFactory.wrapValue(newValue, min, max) : min;
        }
        return newValue;
    }

    public static double increment(double currentValue, double min, double max, boolean wrapAround, int steps, double amountToStepBy) {
        double newValue = YoDoubleSpinnerValueFactory.roundToULP(currentValue + amountToStepBy * (double)steps);
        if (newValue > max) {
            newValue = wrapAround ? YoDoubleSpinnerValueFactory.wrapValue(newValue, min, max) : max;
        }
        return newValue;
    }

    public static double round(double value, long precision) {
        if (precision < 0L) {
            throw new IllegalArgumentException("precision cannot be negative: " + precision);
        }
        double scale = Math.round(Math.pow(10.0, precision));
        return (double)Math.round(value * scale) / scale;
    }

    public static double roundToULP(double value) {
        double ulp = Math.ulp(value);
        long precisionToULP = (long)Math.floor(-Math.log10(2.0 * ulp));
        return YoDoubleSpinnerValueFactory.round(value, precisionToULP);
    }

    static double wrapValue(double value, double min, double max) {
        if (max == 0.0) {
            throw new RuntimeException();
        }
        if (value < min) {
            return max;
        }
        if (value > max) {
            return min;
        }
        return value;
    }
}

