/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color;

import javafx.beans.property.IntegerProperty;
import javafx.scene.paint.Color;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.BaseColorFX;

public class YoColorRGBAIntFX
implements BaseColorFX {
    private IntegerProperty red;
    private IntegerProperty green;
    private IntegerProperty blue;
    private IntegerProperty alpha;

    public YoColorRGBAIntFX() {
    }

    public YoColorRGBAIntFX(IntegerProperty red, IntegerProperty green, IntegerProperty blue) {
        this(red, green, blue, null);
    }

    public YoColorRGBAIntFX(IntegerProperty red, IntegerProperty green, IntegerProperty blue, IntegerProperty alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
    }

    public YoColorRGBAIntFX(YoColorRGBAIntFX other) {
        this.red = other.red;
        this.green = other.green;
        this.blue = other.blue;
        this.alpha = other.alpha;
    }

    @Override
    public void clear() {
        this.red = null;
        this.green = null;
        this.blue = null;
        this.alpha = null;
    }

    public void setRed(IntegerProperty red) {
        this.red = red;
    }

    public void setGreen(IntegerProperty green) {
        this.green = green;
    }

    public void setBlue(IntegerProperty blue) {
        this.blue = blue;
    }

    public void setAlpha(IntegerProperty alpha) {
        this.alpha = alpha;
    }

    public IntegerProperty getRed() {
        return this.red;
    }

    public IntegerProperty getGreen() {
        return this.green;
    }

    public IntegerProperty getBlue() {
        return this.blue;
    }

    public IntegerProperty getAlpha() {
        return this.alpha;
    }

    @Override
    public YoColorRGBAIntFX clone() {
        return new YoColorRGBAIntFX(this);
    }

    @Override
    public Color get() {
        if (this.red == null && this.green == null && this.blue == null && this.alpha == null) {
            return null;
        }
        int r = this.red == null ? 0 : MathTools.clamp((int)this.red.get(), (int)0, (int)255);
        int g = this.green == null ? 0 : MathTools.clamp((int)this.green.get(), (int)0, (int)255);
        int b = this.blue == null ? 0 : MathTools.clamp((int)this.blue.get(), (int)0, (int)255);
        double o = this.alpha == null ? 1.0 : MathTools.clamp((double)((double)this.alpha.get() / 255.0), (double)0.0, (double)1.0);
        return Color.rgb((int)r, (int)g, (int)b, (double)o);
    }

    public String toString() {
        return "[red=" + String.valueOf(this.red) + ", green=" + String.valueOf(this.green) + ", blue=" + String.valueOf(this.blue) + ", alpha=" + String.valueOf(this.alpha) + "]";
    }
}

