/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.mcap;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import org.bytedeco.ffmpeg.global.avutil;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.session.mcap.FFMPEGVideoDataReader;

public class FFMPEGMultiVideoDataReader {
    private final List<FFMPEGVideoDataReader> readers = new ArrayList<FFMPEGVideoDataReader>();
    private final BackgroundExecutorManager backgroundExecutorManager;
    private Future<?> currentTask = null;

    public FFMPEGMultiVideoDataReader(File dataDirectory, BackgroundExecutorManager backgroundExecutorManager) {
        this.backgroundExecutorManager = backgroundExecutorManager;
        LogTools.info((String)"Searching for videos in {}", (Object)dataDirectory.getAbsolutePath());
        if (dataDirectory.isDirectory()) {
            List<Path> videoFiles;
            try {
                videoFiles = Files.walk(dataDirectory.toPath(), 1, new FileVisitOption[0]).filter(f -> f.toString().endsWith(".mp4") | f.toString().endsWith(".avi")).toList();
                LogTools.info((String)"Found video file(s): {}", (Object)videoFiles.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            for (int i = 0; i < videoFiles.size(); ++i) {
                this.readers.add(new FFMPEGVideoDataReader(videoFiles.get(i).toFile()));
            }
        }
    }

    public void readVideoFrameNow(long timestamp) {
        this.readers.forEach(reader -> reader.readFrameAtTimestamp(timestamp));
    }

    public void readVideoFrameInBackground(long timestamp) {
        if (this.currentTask == null || this.currentTask.isDone()) {
            this.currentTask = this.backgroundExecutorManager.executeInBackground(() -> this.readVideoFrameNow(timestamp));
        }
    }

    public int getNumberOfVideos() {
        return this.readers.size();
    }

    public List<FFMPEGVideoDataReader> getReaders() {
        return this.readers;
    }

    static {
        avutil.av_log_set_level((int)16);
    }
}

