/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers;

import com.jfoenix.controls.JFXButton;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.Pair;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.session.SessionMode;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.SessionAdvancedControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class SecondaryWindowControlsController
implements VisualizerController {
    private Window owner;
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;
    @FXML
    private VBox mainPane;
    @FXML
    private FlowPane buttonsContainer;
    @FXML
    private JFXButton previousKeyFrameButton;
    @FXML
    private JFXButton nextKeyFrameButton;
    @FXML
    private Node runningIconView;
    @FXML
    private Node playbackIconView;
    @FXML
    private Node pauseIconView;
    private Property<YoBufferPropertiesReadOnly> bufferProperties;

    public FlowPane getButtonsContainer() {
        return this.buttonsContainer;
    }

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.owner = toolkit.getWindow();
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.bufferProperties = this.messager.createPropertyInput(this.topics.getYoBufferCurrentProperties());
        ReadOnlyObjectProperty<int[]> keyFrameIndicesProperty = toolkit.getKeyFrameManager().keyFrameIndicesProperty();
        keyFrameIndicesProperty.addListener((o, oldValue, newValue) -> {
            boolean disableKeyFrameButtons = newValue == null || ((int[])newValue).length == 0;
            this.previousKeyFrameButton.setDisable(disableKeyFrameButtons);
            this.nextKeyFrameButton.setDisable(disableKeyFrameButtons);
        });
        boolean disableKeyFrameButtons = keyFrameIndicesProperty.get() == null || ((int[])keyFrameIndicesProperty.get()).length == 0;
        this.previousKeyFrameButton.setDisable(disableKeyFrameButtons);
        this.nextKeyFrameButton.setDisable(disableKeyFrameButtons);
        SessionAdvancedControlsController.setupMainControlsActiveMode(this, this.messager, this.topics, this.runningIconView, this.playbackIconView, this.pauseIconView);
    }

    @FXML
    private void startRunning() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.RUNNING);
    }

    @FXML
    private void startPlayback() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PLAYBACK);
    }

    @FXML
    private void pause() {
        this.messager.submitMessage(this.topics.getSessionCurrentMode(), (Object)SessionMode.PAUSE);
    }

    @FXML
    private void setInPoint() {
        if (this.bufferProperties.getValue() != null) {
            this.messager.submitMessage(this.topics.getYoBufferInPointIndexRequest(), (Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex());
        }
    }

    @FXML
    private void gotoInPoint() {
        if (this.bufferProperties.getValue() != null) {
            this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getInPoint());
        }
    }

    @FXML
    private void stepBack() {
        this.messager.submitMessage(this.topics.getYoBufferDecrementCurrentIndexRequest(), (Object)1);
    }

    @FXML
    private void stepForward() {
        this.messager.submitMessage(this.topics.getYoBufferIncrementCurrentIndexRequest(), (Object)1);
    }

    @FXML
    private void gotoOutPoint() {
        if (this.bufferProperties.getValue() != null) {
            this.messager.submitMessage(this.topics.getYoBufferCurrentIndexRequest(), (Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getOutPoint());
        }
    }

    @FXML
    private void setOutPoint() {
        if (this.bufferProperties.getValue() != null) {
            this.messager.submitMessage(this.topics.getYoBufferOutPointIndexRequest(), (Object)((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getCurrentIndex());
        }
    }

    @FXML
    private void gotoPreviousKeyFrame() {
        this.messager.submitMessage(this.topics.getGoToPreviousKeyFrame(), new Object());
    }

    @FXML
    private void addRemoveKeyFrame() {
        this.messager.submitMessage(this.topics.getToggleKeyFrame(), new Object());
    }

    @FXML
    private void gotoNextKeyFrame() {
        this.messager.submitMessage(this.topics.getGoToNextKeyFrame(), new Object());
    }

    @FXML
    private void requestZoomInGraphs() {
        this.messager.submitMessage(this.topics.getYoChartRequestZoomIn(), (Object)new Pair((Object)this.owner, (Object)true));
    }

    @FXML
    private void requestZoomOutGraphs() {
        this.messager.submitMessage(this.topics.getYoChartRequestZoomOut(), (Object)new Pair((Object)this.owner, (Object)true));
    }

    @FXML
    private void openSimpleControls() {
        this.messager.submitMessage(this.topics.getShowAdvancedControls(), (Object)false);
    }
}

