/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.charts;

public class ChartIntegerBounds {
    private final int lower;
    private final int upper;
    private int hashCode = 0;

    public ChartIntegerBounds(int lower, int upper) {
        this.lower = lower;
        this.upper = upper;
    }

    public ChartIntegerBounds(ChartIntegerBounds other) {
        this.lower = other.lower;
        this.upper = other.upper;
    }

    public ChartIntegerBounds center(int currentIndex, int minIndex, int maxIndex) {
        return this.zoom(currentIndex, 0, minIndex, maxIndex, 1.0);
    }

    public ChartIntegerBounds zoom(int currentIndex, int minLength, int minIndex, int maxIndex, double zoomFactor) {
        return ChartIntegerBounds.zoom(this, currentIndex, minLength, minIndex, maxIndex, zoomFactor);
    }

    public ChartIntegerBounds union(ChartIntegerBounds other) {
        return ChartIntegerBounds.union(this, other);
    }

    public ChartIntegerBounds include(int value) {
        return ChartIntegerBounds.include(this, value);
    }

    public int getLower() {
        return this.lower;
    }

    public int getUpper() {
        return this.upper;
    }

    public int length() {
        return this.upper - this.lower;
    }

    public boolean isInside(int index) {
        return index >= this.lower && index <= this.upper;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = 31 * this.lower + this.upper;
        }
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChartIntegerBounds) {
            ChartIntegerBounds other = (ChartIntegerBounds)object;
            return this.lower == other.lower && this.upper == other.upper;
        }
        return false;
    }

    public String toString() {
        return "Lower bound: " + this.lower + ", upper bound: " + this.upper;
    }

    public static ChartIntegerBounds include(ChartIntegerBounds bounds, int value) {
        return new ChartIntegerBounds(Math.min(bounds.lower, value), Math.max(bounds.upper, value));
    }

    public static ChartIntegerBounds union(ChartIntegerBounds bounds1, ChartIntegerBounds bounds2) {
        return new ChartIntegerBounds(Math.min(bounds1.lower, bounds2.lower), Math.max(bounds1.upper, bounds2.upper));
    }

    public static ChartIntegerBounds zoom(ChartIntegerBounds current, int currentIndex, int minLength, int minIndex, int maxIndex, double zoomFactor) {
        int oldLength = current.upper - current.lower;
        int newLength = (int)((double)oldLength / zoomFactor);
        if (newLength < minLength) {
            return current;
        }
        int newLower = currentIndex - newLength / 2;
        int newUpper = newLower + newLength;
        if (newLower < minIndex) {
            newLower = minIndex;
            newUpper = Math.min(newLower + newLength, maxIndex);
        } else if (newUpper > maxIndex) {
            newUpper = maxIndex;
            newLower = Math.max(newUpper - newLength, minIndex);
        }
        return new ChartIntegerBounds(newLower, newUpper);
    }
}

