/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.SubScene;
import javafx.stage.Stage;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.messager.MessagerAPIFactory;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionMessagerAPI;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.session.YoSharedBufferMessagerAPI;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionChangeListener;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerMessagerAPI;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.CameraSensorsManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartDataManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ChartRenderManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.EnvironmentManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.KeyFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.MultiViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionDataPreferenceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SnapshotManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.VideoRecordingManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoGraphicFXManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoRobotFXManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.SCS2JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.StringTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;
import us.ihmc.yoVariables.variable.YoVariable;

public class SessionVisualizerToolkit
extends ObservedAnimationTimer {
    private final SCS2JavaFXMessager messager;
    private final SessionVisualizerTopics topics = new SessionVisualizerTopics();
    private final YoManager yoManager = new YoManager();
    private final ChartDataManager chartDataManager;
    private final ChartRenderManager chartRenderManager = new ChartRenderManager();
    private final YoGraphicFXManager yoGraphicFXManager;
    private final YoCompositeSearchManager yoCompositeSearchManager;
    private final SnapshotManager snapshotManager;
    private final VideoRecordingManager videoRecordingManager;
    private final KeyFrameManager keyFrameManager;
    private final CameraSensorsManager cameraSensorsManager;
    private final BackgroundExecutorManager backgroundExecutorManager = new BackgroundExecutorManager(4);
    private final ReferenceFrameManager referenceFrameManager = new ReferenceFrameManager(this.yoManager, this.backgroundExecutorManager);
    private final YoRobotFXManager yoRobotFXManager;
    private final EnvironmentManager environmentManager;
    private final SecondaryWindowManager secondaryWindowManager;
    private final SessionDataPreferenceManager sessionDataPreferenceManager;
    private final MultiViewport3DManager viewport3DManager;
    private final Stage mainWindow;
    private final SubScene mainScene3D;
    private final Group mainView3DRoot;
    private final ObjectProperty<Session> activeSessionProperty = new SimpleObjectProperty((Object)this, "activeSession", null);
    private final ObservableList<RobotDefinition> sessionRobotDefinitions = FXCollections.observableArrayList();
    private final ObservableList<TerrainObjectDefinition> sessionTerrainObjectDefinitions = FXCollections.observableArrayList();
    private final ConcurrentLinkedQueue<SessionChangeListener> sessionChangeListeners = new ConcurrentLinkedQueue();

    public SessionVisualizerToolkit(Stage mainWindow, Group mainView3DRoot) throws Exception {
        this.mainWindow = mainWindow;
        this.mainView3DRoot = mainView3DRoot;
        MessagerAPIFactory apiFactory = new MessagerAPIFactory();
        apiFactory.createRootCategory("SCS2");
        apiFactory.includeMessagerAPIs(new MessagerAPIFactory.MessagerAPI[]{SessionMessagerAPI.API, YoSharedBufferMessagerAPI.API, SessionVisualizerMessagerAPI.API});
        this.messager = new SCS2JavaFXMessager(apiFactory.getAPIAndCloseFactory());
        this.topics.setupTopics();
        this.messager.startMessager();
        this.snapshotManager = new SnapshotManager(mainWindow, (JavaFXMessager)this.messager, this.topics);
        this.chartDataManager = new ChartDataManager((JavaFXMessager)this.messager, this.topics, this.yoManager, this.backgroundExecutorManager);
        this.yoGraphicFXManager = new YoGraphicFXManager((JavaFXMessager)this.messager, this.topics, this.yoManager, this.backgroundExecutorManager, this.referenceFrameManager);
        this.yoCompositeSearchManager = new YoCompositeSearchManager((JavaFXMessager)this.messager, this.topics, this.yoManager, this.backgroundExecutorManager);
        this.keyFrameManager = new KeyFrameManager((JavaFXMessager)this.messager, this.topics);
        this.yoRobotFXManager = new YoRobotFXManager((JavaFXMessager)this.messager, this.topics, this.yoManager, this.referenceFrameManager, this.backgroundExecutorManager);
        this.environmentManager = new EnvironmentManager((JavaFXMessager)this.messager, this.topics, this.backgroundExecutorManager);
        this.viewport3DManager = new MultiViewport3DManager(mainView3DRoot, this.yoManager, this.yoCompositeSearchManager, this.referenceFrameManager);
        this.mainScene3D = this.viewport3DManager.getMainViewport().getSubScene();
        mainView3DRoot.getChildren().addAll((Object[])new Node[]{this.yoRobotFXManager.getRootNode(), this.environmentManager.getRootNode(), this.yoGraphicFXManager.getRootNode3D()});
        this.environmentManager.addSkybox((Camera)this.viewport3DManager.getMainViewport().getCamera());
        this.messager.addFXTopicListener(this.topics.getCamera3DRequest(), this.viewport3DManager::submitRequest);
        this.videoRecordingManager = new VideoRecordingManager(this.mainScene3D, mainView3DRoot, this.topics, this.messager, this.backgroundExecutorManager);
        this.secondaryWindowManager = new SecondaryWindowManager(this);
        this.sessionDataPreferenceManager = new SessionDataPreferenceManager((Messager)this.messager, this.topics);
        this.cameraSensorsManager = new CameraSensorsManager((Node)mainView3DRoot, this.messager, this.topics, this.yoRobotFXManager);
        this.activeSessionProperty.addListener((o, oldValue, newValue) -> {
            List newTerrainObjectDefinitions;
            this.sessionRobotDefinitions.clear();
            this.sessionTerrainObjectDefinitions.clear();
            if (newValue == null) {
                return;
            }
            List newRobotDefinitions = newValue.getRobotDefinitions();
            if (newRobotDefinitions != null && !newRobotDefinitions.isEmpty()) {
                this.sessionRobotDefinitions.setAll((Collection)newRobotDefinitions);
            }
            if ((newTerrainObjectDefinitions = newValue.getTerrainObjectDefinitions()) != null && !newTerrainObjectDefinitions.isEmpty()) {
                this.sessionTerrainObjectDefinitions.setAll((Collection)newTerrainObjectDefinitions);
            }
        });
        this.messager.addFXTopicListener(this.topics.getSessionRobotDefinitionListChangeState(), change -> {
            if (change.getRemovedRobotDefinition() != null) {
                this.sessionRobotDefinitions.remove((Object)change.getRemovedRobotDefinition());
            }
            if (change.getAddedRobotDefinition() != null) {
                this.sessionRobotDefinitions.add((Object)change.getAddedRobotDefinition());
            }
        });
    }

    public void startSession(Session session, Runnable sessionLoadedCallback) {
        Session oldSession = (Session)this.activeSessionProperty.get();
        if (oldSession != null) {
            LogTools.warn((String)"Session already in progress. Stop the current session before starting a new one.");
            return;
        }
        this.activeSessionProperty.set((Object)session);
        session.setupWithMessager((Messager)this.messager);
        this.backgroundExecutorManager.executeInBackground(() -> {
            try {
                this.yoManager.startSession(session);
                this.yoRobotFXManager.startSession(session);
                this.environmentManager.startSession(session);
                this.referenceFrameManager.startSession(session);
                this.chartDataManager.startSession(session);
                this.chartRenderManager.startSession(session);
                this.yoCompositeSearchManager.startSession(session);
                this.keyFrameManager.startSession(session);
                this.secondaryWindowManager.startSession(session);
                while (!this.yoRobotFXManager.isSessionLoaded()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        if (sessionLoadedCallback != null) {
                            sessionLoadedCallback.run();
                        }
                        this.sessionChangeListeners.forEach(listener -> listener.sessionChanged(oldSession, session));
                        return;
                    }
                }
                this.yoGraphicFXManager.startSession(session);
                this.cameraSensorsManager.startSession(session);
                this.messager.submitMessage(this.topics.getSessionCurrentState(), SessionState.ACTIVE);
            }
            finally {
                if (sessionLoadedCallback != null) {
                    sessionLoadedCallback.run();
                }
                this.sessionChangeListeners.forEach(listener -> listener.sessionChanged(oldSession, session));
            }
        });
        this.mainWindow.setTitle(session.getSessionName());
    }

    public void stopSession(boolean shutdownSession) {
        Session oldSession = (Session)this.activeSessionProperty.get();
        if (oldSession == null) {
            return;
        }
        this.activeSessionProperty.set(null);
        this.backgroundExecutorManager.stopSession();
        this.yoRobotFXManager.stopSession();
        this.chartDataManager.stopSession();
        this.chartRenderManager.stopSession();
        this.yoGraphicFXManager.stopSession();
        this.referenceFrameManager.stopSession();
        this.yoCompositeSearchManager.stopSession();
        this.environmentManager.stopSession();
        this.keyFrameManager.stopSession();
        this.secondaryWindowManager.stopSession();
        this.cameraSensorsManager.stopSession();
        this.yoManager.stopSession();
        this.mainWindow.setTitle("No Active Session");
        if (shutdownSession) {
            this.messager.submitMessage(this.topics.getSessionCurrentState(), SessionState.INACTIVE);
        }
        this.sessionChangeListeners.forEach(listener -> listener.sessionChanged(oldSession, null));
    }

    public boolean hasActiveSession() {
        return this.activeSessionProperty.get() != null;
    }

    public Session getSession() {
        return (Session)this.activeSessionProperty.get();
    }

    public void addSessionChangedListener(SessionChangeListener listener) {
        this.sessionChangeListeners.add(listener);
    }

    public boolean removeSessionChangedListener(SessionChangeListener listener) {
        return this.sessionChangeListeners.remove(listener);
    }

    @Override
    public void handleImpl(long now) {
        this.secondaryWindowManager.handleSubmittedControllers();
    }

    public void stop() {
        super.stop();
        this.yoManager.stop();
        this.yoRobotFXManager.stop();
        this.yoGraphicFXManager.stop();
        this.backgroundExecutorManager.shutdown();
        this.environmentManager.dispose();
        this.messager.closeMessager();
        this.viewport3DManager.dispose();
        this.mainView3DRoot.getChildren().clear();
    }

    public SCS2JavaFXMessager getMessager() {
        return this.messager;
    }

    public SessionVisualizerTopics getTopics() {
        return this.topics;
    }

    public Stage getMainWindow() {
        return this.mainWindow;
    }

    public SubScene getMainScene3D() {
        return this.mainScene3D;
    }

    public Group getMainView3DRoot() {
        return this.mainView3DRoot;
    }

    public MultiViewport3DManager getViewport3DManager() {
        return this.viewport3DManager;
    }

    public YoManager getYoManager() {
        return this.yoManager;
    }

    public YoGraphicFXManager getYoGraphicFXManager() {
        return this.yoGraphicFXManager;
    }

    public YoGroupFX getYoGraphicFXRootGroup() {
        return this.yoGraphicFXManager.getRootGroup();
    }

    public YoGroupFX getYoGraphicFXSessionRootGroup() {
        return this.yoGraphicFXManager.getSessionRootGroup();
    }

    public YoRobotFXManager getYoRobotFXManager() {
        return this.yoRobotFXManager;
    }

    public ChartDataManager getChartDataManager() {
        return this.chartDataManager;
    }

    public ChartRenderManager getChartRenderManager() {
        return this.chartRenderManager;
    }

    public YoCompositeSearchManager getYoCompositeSearchManager() {
        return this.yoCompositeSearchManager;
    }

    public ReferenceFrameWrapper getWorldFrame() {
        return this.referenceFrameManager.getWorldFrame();
    }

    public ReferenceFrameManager getReferenceFrameManager() {
        return this.referenceFrameManager;
    }

    public EnvironmentManager getEnvironmentManager() {
        return this.environmentManager;
    }

    public KeyFrameManager getKeyFrameManager() {
        return this.keyFrameManager;
    }

    public SnapshotManager getSnapshotManager() {
        return this.snapshotManager;
    }

    public BackgroundExecutorManager getBackgroundExecutorManager() {
        return this.backgroundExecutorManager;
    }

    public VideoRecordingManager getVideoRecordingManager() {
        return this.videoRecordingManager;
    }

    public SecondaryWindowManager getWindowManager() {
        return this.secondaryWindowManager;
    }

    public SessionDataPreferenceManager getSessionDataPreferenceManager() {
        return this.sessionDataPreferenceManager;
    }

    public ObservableList<RobotDefinition> getSessionRobotDefinitions() {
        return this.sessionRobotDefinitions;
    }

    public ObservableList<TerrainObjectDefinition> getSessionTerrainObjectDefinitions() {
        return this.sessionTerrainObjectDefinitions;
    }

    public void generateChartGroupTitle(Object caller, Collection<YoVariable> variables, Consumer<String> callback) {
        callback.accept(StringTools.commonSubString(variables.stream().map(YoVariable::getName).collect(Collectors.toList())));
    }
}

