/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import us.ihmc.scs2.session.DaemonThreadFactory;

public class BackgroundExecutorManager {
    private final ScheduledExecutorService backgroundExecutor;
    private final Map<Object, ConcurrentLinkedQueue<Runnable>> taskQueues = new HashMap<Object, ConcurrentLinkedQueue<Runnable>>();
    private final Map<Object, Future<?>> activeFutureMap = new ConcurrentHashMap();
    private final List<Future<?>> futures = new ArrayList();
    private volatile boolean isStoppingSession = false;

    public BackgroundExecutorManager(int numberOfThreads) {
        this.backgroundExecutor = Executors.newScheduledThreadPool(numberOfThreads, (ThreadFactory)new DaemonThreadFactory(this.getClass().getSimpleName(), 5));
    }

    public void scheduleInBackgroundWithCondition(final BooleanSupplier condition, Runnable task) {
        if (this.isStoppingSession || this.backgroundExecutor.isShutdown()) {
            return;
        }
        final Runnable taskLocal = this.toPrintExceptionRunnable(task);
        Runnable delayedTask = new Runnable(){

            @Override
            public void run() {
                if (!condition.getAsBoolean()) {
                    BackgroundExecutorManager.this.backgroundExecutor.execute(this);
                    return;
                }
                taskLocal.run();
            }
        };
        this.backgroundExecutor.execute(delayedTask);
    }

    public void queueTaskToExecuteInBackground(Object owner, Runnable task) {
        this.queueTaskToExecuteInBackground(owner, false, task);
    }

    public void queueTaskToExecuteInBackground(Object owner, boolean cancelPreviousTasks, Runnable task) {
        if (this.isStoppingSession || this.backgroundExecutor.isShutdown()) {
            return;
        }
        ConcurrentLinkedQueue taskQueue = this.taskQueues.computeIfAbsent(owner, k -> new ConcurrentLinkedQueue());
        if (cancelPreviousTasks) {
            taskQueue.clear();
        }
        Runnable chainingTask = () -> {
            task.run();
            Runnable nextTask = (Runnable)taskQueue.poll();
            if (nextTask != null) {
                this.executeInBackground(nextTask);
            }
        };
        Future<?> activeFuture = this.activeFutureMap.get(owner);
        if (activeFuture == null || activeFuture.isDone()) {
            this.activeFutureMap.put(owner, this.executeInBackground(chainingTask));
        } else {
            taskQueue.add(chainingTask);
        }
    }

    public Future<?> executeInBackground(Runnable task) {
        if (this.isStoppingSession || this.backgroundExecutor.isShutdown()) {
            return null;
        }
        return this.backgroundExecutor.submit(this.toPrintExceptionRunnable(task));
    }

    public <V> Future<V> executeInBackground(Callable<V> task) {
        if (this.isStoppingSession || this.backgroundExecutor.isShutdown()) {
            return null;
        }
        return this.backgroundExecutor.submit(this.toPrintExceptionCallable(task));
    }

    private Runnable toPrintExceptionRunnable(Runnable runnable) {
        return () -> {
            block3: {
                if (this.isStoppingSession) {
                    return;
                }
                try {
                    runnable.run();
                }
                catch (Exception e) {
                    if (this.isStoppingSession) break block3;
                    e.printStackTrace();
                }
            }
        };
    }

    private <V> Callable<V> toPrintExceptionCallable(Callable<V> callable) {
        return () -> {
            if (this.isStoppingSession) {
                return null;
            }
            try {
                return callable.call();
            }
            catch (Exception e) {
                if (!this.isStoppingSession) {
                    e.printStackTrace();
                }
                return null;
            }
        };
    }

    public Future<?> scheduleTaskInBackground(Runnable periodicTask, long initialDelay, long period, TimeUnit unit) {
        ScheduledFuture<?> newFuture = this.backgroundExecutor.scheduleAtFixedRate(periodicTask, initialDelay, period, unit);
        this.futures.add(newFuture);
        return newFuture;
    }

    public Future<?> scheduleTaskInBackground(Runnable task, long delay, TimeUnit unit) {
        ScheduledFuture<?> newFuture = this.backgroundExecutor.schedule(this.toPrintExceptionRunnable(task), delay, unit);
        this.futures.add(newFuture);
        return newFuture;
    }

    public void stopSession() {
        this.isStoppingSession = true;
        this.futures.forEach(future -> {
            if (!future.isDone()) {
                future.cancel(false);
            }
        });
        this.futures.clear();
        this.isStoppingSession = false;
    }

    public void shutdown() {
        this.backgroundExecutor.shutdown();
    }
}

