/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.SetChangeListener;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.SnapshotParameters;
import javafx.scene.control.Button;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.image.Image;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.stage.Popup;
import javafx.stage.Window;
import us.ihmc.log.LogTools;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.yoChart.YoChartGroupConfigurationDefinition;
import us.ihmc.scs2.definition.yoChart.YoChartGroupConfigurationListDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.YoNameDisplay;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupLayout;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupModel;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.DynamicLineChart;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.TableSizeQuickAccess;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.ChartTable2D;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart.YoChartPanelController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ChartGroupTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.DragAndDropTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.xml.XMLTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoChartGroupPanelController
implements VisualizerController {
    private SessionVisualizerWindowToolkit toolkit;
    private YoCompositeSearchManager yoCompositeSearchManager;
    private final StringProperty chartGroupName = new SimpleStringProperty((Object)this, "chartGroupName", null);
    private final StringProperty userDefinedChartGroupName = new SimpleStringProperty((Object)this, "userDefinedChartGroupName", null);
    private final StringProperty automatedChartGroupName = new SimpleStringProperty((Object)this, "automatedChartGroupName", null);
    private final GridPane gridPane = new GridPane();
    private final BooleanProperty isRunning = new SimpleBooleanProperty((Object)this, "isRunning", false);
    private final ChartTable2D chartTable2D = new ChartTable2D(() -> this.createNewChartPanel(this.isRunning.get()));
    @FXML
    private AnchorPane mainPane;
    @FXML
    private Button dropDownMenuButton;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private final ObservableList<YoVariable> plottedVariableList = FXCollections.observableArrayList();
    private Property<YoNameDisplay> userDesiredDisplayProperty;
    private final Property<YoNameDisplay> nameDisplayProperty = new SimpleObjectProperty((Object)this, "nameDisplayProperty", (Object)YoNameDisplay.SHORT_NAME);

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.toolkit = toolkit;
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        this.mainPane.getChildren().add(0, (Object)this.gridPane);
        AnchorPane.setTopAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.gridPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.gridPane, (Double)0.0);
        this.gridPane.getStyleClass().add((Object)"chart-group-grid-pane");
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.messager.submitMessage(this.topics.getRegisterRecordable(), (Object)this.mainPane);
        this.messager.addFXTopicListener(this.topics.getDisableUserControls(), m -> this.mainPane.setDisable(m.booleanValue()));
        toolkit.getWindow().iconifiedProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue() != this.isRunning.get()) {
                return;
            }
            if (newValue.booleanValue()) {
                this.stop();
            } else {
                this.start();
            }
        });
        this.chartGroupName.bind((ObservableValue)this.automatedChartGroupName);
        this.userDefinedChartGroupName.addListener((ChangeListener)new ChangeListener<String>(){
            private Observable currentBind;
            {
                this.currentBind = YoChartGroupPanelController.this.automatedChartGroupName;
            }

            public void changed(ObservableValue<? extends String> o, String oldValue, String newValue) {
                if (newValue != null) {
                    if (this.currentBind != YoChartGroupPanelController.this.userDefinedChartGroupName) {
                        this.currentBind = YoChartGroupPanelController.this.userDefinedChartGroupName;
                        YoChartGroupPanelController.this.chartGroupName.unbind();
                        YoChartGroupPanelController.this.chartGroupName.bind((ObservableValue)YoChartGroupPanelController.this.userDefinedChartGroupName);
                    }
                } else if (this.currentBind != YoChartGroupPanelController.this.automatedChartGroupName) {
                    this.currentBind = YoChartGroupPanelController.this.automatedChartGroupName;
                    YoChartGroupPanelController.this.chartGroupName.unbind();
                    YoChartGroupPanelController.this.chartGroupName.bind((ObservableValue)YoChartGroupPanelController.this.automatedChartGroupName);
                }
            }
        });
        this.userDesiredDisplayProperty = this.messager.createPropertyInput(this.topics.getYoVariableNameDisplay());
        this.plottedVariableList.addListener(change -> this.updateAutoUniqueNameDisplay());
        this.userDesiredDisplayProperty.addListener((o, oldValue, newValue) -> {
            if (newValue == YoNameDisplay.SHORT_NAME) {
                this.updateAutoUniqueNameDisplay();
            } else {
                this.nameDisplayProperty.setValue((Object)newValue);
            }
        });
        if (this.userDesiredDisplayProperty.getValue() != YoNameDisplay.SHORT_NAME) {
            this.nameDisplayProperty.setValue((Object)((YoNameDisplay)((Object)this.userDesiredDisplayProperty.getValue())));
        }
        SetChangeListener plottedVariableChangeListener = change -> {
            if (change.wasAdded()) {
                this.plottedVariableList.add((Object)((YoVariable)change.getElementAdded()));
            }
            if (change.wasRemoved()) {
                this.plottedVariableList.remove(change.getElementRemoved());
            }
        };
        this.chartTable2D.addListener(c -> {
            YoChartPanelController chart = c.getChart();
            switch (c.type()) {
                case ADD: {
                    this.gridPane.add((Node)chart.getMainPane(), c.toCol(), c.toRow());
                    chart.getPlottedVariables().addListener(plottedVariableChangeListener);
                    chart.nameDisplayPropertyProperty().bind(this.nameDisplayProperty);
                    break;
                }
                case REMOVE: {
                    this.gridPane.getChildren().remove((Object)chart.getMainPane());
                    chart.getPlottedVariables().removeListener(plottedVariableChangeListener);
                    chart.nameDisplayPropertyProperty().unbind();
                    break;
                }
                case MOVE: {
                    GridPane.setConstraints((Node)chart.getMainPane(), (int)c.toCol(), (int)c.toRow());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected change type: " + c.type());
                }
            }
        });
    }

    public boolean isEmpty() {
        return this.chartTable2D.isEmpty();
    }

    public ChartTable2D.ChartTable2DSize getSize() {
        return this.chartTable2D.getSize();
    }

    public void resize(ChartTable2D.ChartTable2DSize desiredSize) {
        this.chartTable2D.resize(desiredSize);
    }

    private void updateAutoUniqueNameDisplay() {
        if (this.plottedVariableList.isEmpty()) {
            this.automatedChartGroupName.set(null);
            this.userDefinedChartGroupName.set(null);
        } else {
            this.toolkit.getGlobalToolkit().generateChartGroupTitle(this, (Collection<YoVariable>)this.plottedVariableList, value -> JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.automatedChartGroupName.set(value)));
        }
        if (this.userDesiredDisplayProperty.getValue() != YoNameDisplay.SHORT_NAME) {
            this.nameDisplayProperty.setValue((Object)((YoNameDisplay)((Object)this.userDesiredDisplayProperty.getValue())));
        } else {
            List distinctVariables = this.plottedVariableList.stream().distinct().toList();
            long distinctNameCount = distinctVariables.stream().map(YoVariable::getName).distinct().count();
            this.nameDisplayProperty.setValue((Object)(distinctNameCount < (long)distinctVariables.size() ? YoNameDisplay.UNIQUE_SHORT_NAME : YoNameDisplay.SHORT_NAME));
        }
    }

    public void setChartGroupConfiguration(YoChartGroupConfigurationDefinition definition) {
        if (!this.chartTable2D.set(definition)) {
            return;
        }
        this.userDefinedChartGroupName.set((Object)definition.getName());
    }

    private void handleCloseChart(ActionEvent event, YoChartPanelController chartToClose) {
        this.chartTable2D.removeChart(this.getChartIdentifier(chartToClose));
        this.chartTable2D.removeNullRowsAndColumns();
        event.consume();
    }

    public YoChartPanelController getChartController(ChartIdentifier chartIdentifier) {
        return this.chartTable2D.get(chartIdentifier.getRow(), chartIdentifier.getColumn());
    }

    public ChartIdentifier getChartIdentifier(YoChartPanelController controller) {
        return new ChartIdentifier(GridPane.getRowIndex((Node)controller.getMainPane()), GridPane.getColumnIndex((Node)controller.getMainPane()));
    }

    private YoChartPanelController createNewChartPanel(boolean start) {
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.CHART_PANEL_FXML_URL);
            AnchorPane graphNode = (AnchorPane)loader.load();
            YoChartPanelController controller = (YoChartPanelController)loader.getController();
            controller.initialize(this.toolkit);
            DynamicLineChart chartNode = controller.getLineChart();
            chartNode.setOnDragOver(e -> this.handleDragOver((DragEvent)e, controller));
            chartNode.setOnDragDropped(e -> this.handleDragDropped((DragEvent)e, controller));
            chartNode.setOnDragEntered(e -> this.handleDragEntered((DragEvent)e, controller));
            chartNode.setOnDragExited(e -> this.handleDragExited((DragEvent)e, controller));
            controller.getCloseButton().setOnAction(e -> this.handleCloseChart((ActionEvent)e, controller));
            controller.getChartMoveIcon().setOnDragDetected(e -> this.startChartMove((MouseEvent)e, controller));
            controller.getChartMoveIcon().setOnDragDone(e -> this.finishChartMove((DragEvent)e, controller));
            YoChartGroupPanelController.setGrowProperty((Node)graphNode);
            if (start) {
                controller.start();
            }
            return controller;
        }
        catch (IOException e2) {
            throw new RuntimeException("Could not create new line chart panel:", e2);
        }
    }

    private static void setGrowProperty(Node graphNode) {
        GridPane.setHgrow((Node)graphNode, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)graphNode, (Priority)Priority.ALWAYS);
    }

    public void start() {
        this.isRunning.set(true);
        this.chartTable2D.forEachChart(AnimationTimer::start);
    }

    public void stop() {
        this.isRunning.set(false);
        this.chartTable2D.forEachChart(AnimationTimer::stop);
    }

    public void stopAndClear() {
        this.stop();
        this.chartTable2D.clear();
    }

    public void closeAndDispose() {
        this.stopAndClear();
    }

    @FXML
    void openMenu(ActionEvent event) {
        Popup popup = new Popup();
        popup.autoHideProperty().set(true);
        TableSizeQuickAccess tableSizeQuickAccess = new TableSizeQuickAccess("Select graph table size:", this.chartTable2D.getSize(), this.chartTable2D.getMaxSize());
        AnchorPane rootNode = tableSizeQuickAccess.getMainPane();
        Pane backgroundPane = new Pane();
        backgroundPane.setStyle("-fx-background-radius:10;-fx-background-color:rgba(79,132,186,0.5);");
        backgroundPane.setEffect((Effect)new GaussianBlur(10.0));
        rootNode.getChildren().add(0, (Object)backgroundPane);
        AnchorPane.setTopAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setBottomAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setLeftAnchor((Node)backgroundPane, (Double)-5.0);
        AnchorPane.setRightAnchor((Node)backgroundPane, (Double)-5.0);
        rootNode.setOnMouseClicked(e -> {
            this.chartTable2D.resize(new ChartTable2D.ChartTable2DSize(tableSizeQuickAccess.selectedRowsProperty().get(), tableSizeQuickAccess.selectedColumnsProperty().get()));
            popup.hide();
        });
        tableSizeQuickAccess.getClearAllButton().setOnMouseClicked(e -> {
            this.chartTable2D.clear();
            popup.hide();
        });
        tableSizeQuickAccess.getClearEmptyButton().setOnMouseClicked(e -> {
            this.chartTable2D.removeEmptyCharts();
            this.chartTable2D.removeNullRowsAndColumns();
            popup.hide();
        });
        popup.getContent().add((Object)rootNode);
        this.dropDownMenuButton.setDisable(true);
        popup.setOnHiding(e -> this.dropDownMenuButton.setDisable(false));
        Bounds boundsInLocal = this.dropDownMenuButton.getBoundsInLocal();
        Point2D anchorPosition = this.dropDownMenuButton.localToScreen(boundsInLocal.getMinX(), boundsInLocal.getMaxY());
        popup.show((Node)this.dropDownMenuButton, anchorPosition.getX(), anchorPosition.getY());
        event.consume();
    }

    public Property<ChartTable2D.ChartTable2DSize> maxSizeProperty() {
        return this.chartTable2D.maxSizeProperty();
    }

    public void setUserDefinedChartGroupName(String name) {
        this.userDefinedChartGroupName.set((Object)name);
    }

    public ReadOnlyStringProperty chartGroupNameProperty() {
        return this.chartGroupName;
    }

    private void handleDragEntered(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event, controller)) {
            if (event.getTransferMode() == TransferMode.MOVE) {
                controller.setSelectionHighlight(true);
            } else {
                List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager);
                List<ChartGroupLayout> configurations = ChartGroupTools.toChartGroupLayouts(yoComposites);
                configurations = this.shiftConfigurationsToSelectedChart(controller, configurations);
                List<YoChartPanelController> controllers = this.controllersInConfigurations(configurations);
                controllers.forEach(c -> c.setSelectionHighlight(true));
            }
        }
        event.consume();
    }

    private void handleDragExited(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event, controller)) {
            this.chartTable2D.forEachChart(c -> c.setSelectionHighlight(false));
        }
        event.consume();
    }

    private void handleDragOver(DragEvent event, YoChartPanelController controller) {
        if (this.acceptDragEventForDrop(event, controller)) {
            if (controller.isEmpty()) {
                event.acceptTransferModes(TransferMode.ANY);
            } else {
                event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
            }
        }
        event.consume();
    }

    private void handleDragDropped(DragEvent event, YoChartPanelController controller) {
        boolean success = false;
        List<YoComposite> yoComposites = DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager);
        if (yoComposites != null) {
            if (event.getTransferMode() == TransferMode.MOVE) {
                yoComposites.forEach(yoComposite -> yoComposite.getYoComponents().forEach(controller::addYoVariableToPlot));
            } else {
                List<ChartGroupLayout> layouts = ChartGroupTools.toChartGroupLayouts(yoComposites);
                if ((layouts = this.shiftConfigurationsToSelectedChart(controller, layouts)).size() > 1) {
                    ContextMenu contextMenu = new ContextMenu();
                    for (ChartGroupLayout layout : layouts) {
                        Label label = new Label(layout.getName());
                        CustomMenuItem menuItem = new CustomMenuItem((Node)label);
                        label.setOnMouseEntered(e -> {
                            this.chartTable2D.forEachChart(c -> c.setSelectionHighlight(false));
                            this.controllersInConfiguration(layout).forEach(c -> c.setSelectionHighlight(true));
                        });
                        menuItem.setOnAction(e -> this.applyLayout(layout));
                        contextMenu.getItems().add((Object)menuItem);
                    }
                    contextMenu.show((Node)this.mainPane, event.getScreenX(), event.getScreenY());
                } else if (layouts.size() == 1) {
                    this.applyLayout(layouts.get(0));
                } else {
                    yoComposites.forEach(yoComposite -> yoComposite.getYoComponents().forEach(controller::addYoVariableToPlot));
                }
            }
            success = true;
        }
        event.setDropCompleted(success);
        event.consume();
    }

    private void startChartMove(MouseEvent event, YoChartPanelController controller) {
        if (!event.isPrimaryButtonDown()) {
            return;
        }
        ArrayList<YoVariable> yoVariables = new ArrayList<YoVariable>((Collection<YoVariable>)controller.getPlottedVariables());
        Node chartMoveIcon = controller.getChartMoveIcon();
        Dragboard dragBoard = chartMoveIcon.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        SnapshotParameters params = new SnapshotParameters();
        params.setTransform((Transform)new Scale(0.5, 0.5));
        dragBoard.setDragView((Image)controller.getMainPane().snapshot(params, null));
        ClipboardContent clipboardContent = new ClipboardContent();
        if (yoVariables.size() == 1) {
            YoVariable yoVariable = (YoVariable)yoVariables.get(0);
            if (yoVariable == null) {
                return;
            }
            clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_REFERENCE, Arrays.asList(YoCompositeTools.YO_VARIABLE, yoVariable.getFullNameString()));
        } else {
            ArrayList<String> content = new ArrayList<String>();
            for (YoVariable yoVariable : yoVariables) {
                content.add(YoCompositeTools.YO_VARIABLE);
                content.add(yoVariable.getFullNameString());
            }
            clipboardContent.put((Object)DragAndDropTools.YO_COMPOSITE_LIST_REFERENCE, content);
        }
        dragBoard.setContent((Map)clipboardContent);
        event.consume();
    }

    private void finishChartMove(DragEvent event, YoChartPanelController controller) {
        if (!event.isAccepted()) {
            return;
        }
        if (event.getTransferMode() != TransferMode.MOVE) {
            return;
        }
        controller.clear();
    }

    private void applyLayout(ChartGroupLayout layout) {
        this.chartTable2D.forEachChart(c -> c.setSelectionHighlight(false));
        for (ChartIdentifier chartIdentifier : layout.getChartIdentifiers()) {
            List<YoVariable> yoVariables = layout.getYoVariables(chartIdentifier);
            YoChartPanelController chartController = this.getChartController(chartIdentifier);
            chartController.addYoVariablesToPlot(yoVariables);
        }
    }

    private List<YoChartPanelController> controllersInConfiguration(ChartGroupModel configuration) {
        if (!this.doesConfigurationFit(configuration)) {
            return null;
        }
        return configuration.getChartIdentifiers().stream().map(this::getChartController).collect(Collectors.toList());
    }

    public List<YoChartPanelController> controllersInConfigurations(List<? extends ChartGroupModel> configurations) {
        return configurations.stream().flatMap(config -> config.getChartIdentifiers().stream()).distinct().map(this::getChartController).collect(Collectors.toList());
    }

    private List<ChartGroupLayout> shiftConfigurationsToSelectedChart(YoChartPanelController selectedChart, List<ChartGroupLayout> layouts) {
        ChartIdentifier selectedId = this.getChartIdentifier(selectedChart);
        return layouts.stream().map(config -> config.shift(selectedId.getRow(), selectedId.getColumn())).filter(this::doesConfigurationFit).collect(Collectors.toList());
    }

    private boolean acceptDragEventForDrop(DragEvent event, YoChartPanelController controller) {
        if (event.getGestureSource() == this.mainPane || event.getGestureSource() == controller.getChartMoveIcon()) {
            return false;
        }
        if (event.getTransferMode() == TransferMode.MOVE && !controller.isEmpty()) {
            return false;
        }
        return DragAndDropTools.retrieveYoCompositesFromDragBoard(event.getDragboard(), this.yoCompositeSearchManager) != null;
    }

    private boolean doesConfigurationFit(ChartGroupModel configuration) {
        return this.chartTable2D.getSize().contains(configuration.rowEnd(), configuration.columnEnd());
    }

    public boolean addVariableToPlot(String variableName, int row, int column, boolean resizeToFit) {
        if (resizeToFit) {
            if (row >= this.chartTable2D.getSize().getNumberOfRows() || column >= this.chartTable2D.getSize().getNumberOfCols()) {
                int numberOfRows = Math.max(row + 1, this.chartTable2D.getSize().getNumberOfRows());
                int numberOfCols = Math.max(column + 1, this.chartTable2D.getSize().getNumberOfCols());
                this.chartTable2D.resize(new ChartTable2D.ChartTable2DSize(numberOfRows, numberOfCols));
            }
        } else if (row >= this.chartTable2D.getSize().getNumberOfRows() || column >= this.chartTable2D.getSize().getNumberOfCols()) {
            return false;
        }
        YoChartPanelController chartController = this.chartTable2D.get(row, column);
        chartController.addYoVariableToPlot(variableName);
        return true;
    }

    public void loadChartGroupConfiguration(Window source, File file) {
        if (source != this.toolkit.getWindow()) {
            return;
        }
        LogTools.info((String)("Loading file: " + file));
        try {
            Object loaded = XMLTools.loadYoChartGroupConfigurationUndefined(new FileInputStream(file));
            if (loaded instanceof YoChartGroupConfigurationDefinition) {
                YoChartGroupConfigurationDefinition definition = (YoChartGroupConfigurationDefinition)loaded;
                this.setChartGroupConfiguration(definition);
            } else if (loaded instanceof YoChartGroupConfigurationListDefinition) {
                LogTools.error((String)"Chart group list is not supported. Probably loaded for the main window. Please load the file for a secondary window instead.");
            } else {
                LogTools.error((String)("Failed to load chart group configuration from file: " + file + ". definition type is not supported: " + loaded.getClass().getSimpleName()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveChartGroupConfiguration(Window source, File file) {
        if (source != null && source != this.toolkit.getWindow()) {
            return;
        }
        if (!Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Save must only be used from the FX Application Thread");
        }
        LogTools.info((String)("Saving file: " + file));
        try {
            XMLTools.saveYoChartGroupConfigurationDefinition(new FileOutputStream(file), this.toYoChartGroupConfigurationDefinition());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public YoChartGroupConfigurationDefinition toYoChartGroupConfigurationDefinition() {
        YoChartGroupConfigurationDefinition definition = new YoChartGroupConfigurationDefinition();
        definition.setName((String)this.chartGroupName.get());
        definition.setNumberOfRows(this.chartTable2D.getSize().getNumberOfRows());
        definition.setNumberOfColumns(this.chartTable2D.getSize().getNumberOfCols());
        definition.setChartConfigurations(this.chartTable2D.toChartDefinitions());
        return definition;
    }

    public AnchorPane getMainPane() {
        return this.mainPane;
    }
}

