/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.text.Text;
import javafx.stage.Stage;
import javafx.stage.Window;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.version.SCS2VersionChecker;

public class AboutWindowController
implements VisualizerController {
    @FXML
    private Stage stage;
    @FXML
    private Text nameAndVersionText;
    @FXML
    private Hyperlink repositoryLink;
    @FXML
    private Text lastestVersionText;
    @FXML
    private Hyperlink downloadLink;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        SessionVisualizerIOTools.addSCSIconToWindow((Window)this.stage);
        this.stage.initOwner((Window)toolkit.getWindow());
        this.nameAndVersionText.setText(this.nameAndVersionText.getText().replace("VERSION", SCS2VersionChecker.getCurrentBaseVersion()));
        this.repositoryLink.setText(SCS2VersionChecker.REPOSITORY_URL.toString());
        if (SCS2VersionChecker.getLatestBaseVersion() == null) {
            this.lastestVersionText.setText("unknown - check your internet connection");
        } else {
            this.lastestVersionText.setText(SCS2VersionChecker.getLatestBaseVersion());
        }
        this.downloadLink.setText(SCS2VersionChecker.DOWNLOAD_URL.toString());
        this.stage.show();
        JavaFXMissingTools.centerWindowInOwner((Window)this.stage, (Window)toolkit.getWindow());
    }

    @FXML
    public void openDownloadPageURL() {
        SessionVisualizerIOTools.openWebpage(SCS2VersionChecker.DOWNLOAD_URL);
    }

    public void openRepositoryURL(ActionEvent actionEvent) {
        SessionVisualizerIOTools.openWebpage(SCS2VersionChecker.REPOSITORY_URL);
    }
}

