/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.mcap;

import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Spinner;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.StringConverter;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.JavaFXFrameConverter;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.session.mcap.FFMPEGVideoDataReader;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;

public class FFMPEGVideoViewer {
    private static final double THUMBNAIL_HIGHLIGHT_SCALE = 1.05;
    private final ImageView thumbnail = new ImageView();
    private final Spinner<Double> offsetSpinner = new Spinner(-1.0E7, 1.0E7, 0.0, 0.001);
    private final StackPane thumbnailContainer = new StackPane(new Node[]{this.thumbnail, this.offsetSpinner});
    private final ImageView videoView = new ImageView();
    private final BooleanProperty updateVideoView = new SimpleBooleanProperty((Object)this, "updateVideoView", false);
    private final ObjectProperty<Stage> videoWindowProperty = new SimpleObjectProperty((Object)this, "videoWindow", null);
    private final JavaFXFrameConverter frameConverter = new JavaFXFrameConverter();
    private final FFMPEGVideoDataReader reader;
    private final double defaultThumbnailSize;
    private final ObjectProperty<Pane> imageViewRootPane = new SimpleObjectProperty((Object)this, "imageViewRootPane", null);

    public FFMPEGVideoViewer(Window owner, FFMPEGVideoDataReader reader, double defaultThumbnailSize) {
        this.reader = reader;
        this.defaultThumbnailSize = defaultThumbnailSize;
        StackPane.setAlignment(this.offsetSpinner, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin(this.offsetSpinner, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
        this.offsetSpinner.setEditable(true);
        this.offsetSpinner.getValueFactory().setConverter((StringConverter)new StringConverter<Double>(this){

            public String toString(Double object) {
                return object.toString() + "s";
            }

            public Double fromString(String string) {
                return Double.valueOf(string.replaceAll("s", "").trim());
            }
        });
        this.thumbnail.setPreserveRatio(true);
        this.videoView.setPreserveRatio(true);
        this.thumbnail.setFitWidth(defaultThumbnailSize);
        this.thumbnail.setOnMouseEntered(e -> {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), new KeyValue[]{new KeyValue((WritableValue)this.thumbnail.fitWidthProperty(), (Object)(1.05 * defaultThumbnailSize), Interpolator.EASE_BOTH)})});
            timeline.playFromStart();
        });
        this.thumbnail.setOnMouseExited(e -> {
            Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.1), new KeyValue[]{new KeyValue((WritableValue)this.thumbnail.fitWidthProperty(), (Object)defaultThumbnailSize, Interpolator.EASE_BOTH)})});
            timeline.playFromStart();
        });
        this.thumbnail.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> {
            Stage stage;
            if (e.getClickCount() != 2) {
                return;
            }
            this.videoView.setImage(this.thumbnail.getImage());
            if (this.videoWindowProperty.get() != null) {
                stage = (Stage)this.videoWindowProperty.get();
            } else {
                stage = new Stage();
                AnchorPane anchorPane = new AnchorPane();
                Pane root = FFMPEGVideoViewer.createImageViewPane(this.videoView);
                anchorPane.getChildren().add((Object)root);
                JavaFXMissingTools.setAnchorConstraints((Node)root, 0.0);
                this.imageViewRootPane.set((Object)root);
                this.videoWindowProperty.set((Object)stage);
                stage.getIcons().add((Object)SessionVisualizerIOTools.LOG_SESSION_IMAGE);
                stage.setTitle(this.reader.toString());
                owner.setOnHiding(e2 -> stage.close());
                Scene scene = new Scene((Parent)anchorPane);
                stage.setScene(scene);
                this.updateVideoView.bind((ObservableValue)stage.showingProperty());
            }
            Screen screen = (Screen)Screen.getScreensForRectangle((double)e.getScreenX(), (double)e.getScreenY(), (double)1.0, (double)1.0).get(0);
            Rectangle2D visualBounds = screen.getVisualBounds();
            double width = 0.5 * visualBounds.getWidth();
            double height = 0.5 * visualBounds.getHeight();
            double x = visualBounds.getMinX() + 0.5 * (visualBounds.getWidth() - width);
            double y = visualBounds.getMinY() + 0.5 * (visualBounds.getHeight() - height);
            stage.setX(x);
            stage.setY(y);
            stage.setWidth(width);
            stage.setHeight(height);
            stage.toFront();
            stage.show();
        });
        this.offsetSpinner.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.reader.setPlaybackOffset(Math.round(newValue * 1.0E9));
            this.reader.readCurrentFrame();
        });
    }

    private static Pane createImageViewPane(final ImageView imageView) {
        return new Pane(new Node[]{imageView}){

            protected void layoutChildren() {
                Image image = imageView.getImage();
                if (image == null) {
                    return;
                }
                double imageRatio = image.getWidth() / image.getHeight();
                double paneWidth = this.getWidth() - this.getPadding().getTop() - this.getPadding().getBottom();
                double paneHeight = this.getHeight() - this.getPadding().getLeft() - this.getPadding().getRight();
                double width = Math.min(paneWidth, paneHeight * imageRatio);
                double height = width / imageRatio;
                double x = 0.5 * (paneWidth - width);
                double y = 0.5 * (paneHeight - height);
                imageView.setFitWidth(width);
                imageView.setX(x + this.getPadding().getLeft());
                imageView.setY(y + this.getPadding().getTop());
            }
        };
    }

    public void update() {
        Frame currentFrame = this.reader.getCurrentFrame();
        if (currentFrame == null || currentFrame.image == null) {
            return;
        }
        Image currentImage = null;
        try {
            currentImage = this.frameConverter.convert(currentFrame);
        }
        catch (RuntimeException e) {
            LogTools.error((String)"Frame has {} image channels", (Object)currentFrame.imageChannels);
        }
        if (currentImage == null) {
            return;
        }
        this.thumbnailContainer.setPrefWidth(1.05 * this.defaultThumbnailSize);
        this.thumbnailContainer.setPrefHeight(1.05 * this.defaultThumbnailSize * currentImage.getHeight() / currentImage.getWidth());
        this.thumbnail.setImage(currentImage);
        if (this.updateVideoView.get()) {
            this.videoView.setImage(currentImage);
            if (this.imageViewRootPane.get() != null) {
                ((Pane)this.imageViewRootPane.get()).setPadding(new Insets(16.0, 16.0, 16.0, 16.0));
            }
        }
    }

    public void stop() {
        if (this.videoWindowProperty.get() != null) {
            ((Stage)this.videoWindowProperty.get()).close();
            this.videoWindowProperty.set(null);
        }
        this.reader.shutdown();
    }

    public Node getThumbnail() {
        return this.thumbnailContainer;
    }
}

