/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.creator;

import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.util.Pair;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.yoVariable.YoEquationDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField.StringSearchField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryIOTools;
import us.ihmc.scs2.symbolic.Equation;
import us.ihmc.scs2.symbolic.parser.EquationAliasManager;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoEquationEditorPaneController {
    @FXML
    private Pane mainPane;
    @FXML
    private TextField equationNameTextField;
    @FXML
    private TextArea equationTextArea;
    @FXML
    private ListView<YoEquationAliasController> aliasListView;
    @FXML
    private ImageView equationNameValidImageView;
    @FXML
    private ImageView equationValidImageView;
    @FXML
    private ImageView equationAliasesValidImageView;
    private final ObservableMap<String, YoEquationAliasController> aliasNameToControllerMap = FXCollections.observableHashMap();
    private final Property<YoEquationDefinition> definitionToEdit = new SimpleObjectProperty((Object)this, "definitionToEdit", null);
    private final BooleanProperty equationValidityProperty = new SimpleBooleanProperty((Object)this, "equationValidity", false);
    private final BooleanProperty equationNameValidityProperty = new SimpleBooleanProperty((Object)this, "equationNameValidity", false);
    private final BooleanProperty equationAliasesValidityProperty = new SimpleBooleanProperty((Object)this, "equationAliasesValidity", false);
    private ObservableBooleanValue validityProperty;
    private SessionVisualizerToolkit toolkit;
    private Runnable updateListener;

    public void initialize(SessionVisualizerToolkit toolkit, Predicate<YoEquationDefinition> nameValidator) {
        this.toolkit = toolkit;
        MutableBoolean isUpdatingDefinition = new MutableBoolean(false);
        this.definitionToEdit.addListener((o, oldValue, newValue) -> {
            isUpdatingDefinition.setTrue();
            try {
                this.equationNameTextField.setText(newValue.getName());
                this.equationNameValidityProperty.set(!newValue.getName().isBlank() && nameValidator.test((YoEquationDefinition)newValue));
                this.equationTextArea.setText(newValue.getEquation());
                List aliases = newValue.getAliases();
                this.setAliases(aliases.stream().map(a -> new Pair((Object)a.getName(), (Object)a.getValue())).collect(Collectors.toList()), true);
                this.updateEquation(aliases.isEmpty(), false);
            }
            finally {
                isUpdatingDefinition.setFalse();
            }
        });
        this.equationNameTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (this.definitionToEdit.getValue() == null) {
                return;
            }
            if (isUpdatingDefinition.isTrue()) {
                return;
            }
            YoEquationDefinition definition = (YoEquationDefinition)this.definitionToEdit.getValue();
            definition.setName(newValue);
            this.equationNameValidityProperty.set(!newValue.isBlank() && nameValidator.test(definition));
            this.updateListener.run();
        });
        this.equationTextArea.textProperty().addListener((o, oldValue, newValue) -> {
            if (this.definitionToEdit.getValue() == null || isUpdatingDefinition.isTrue()) {
                return;
            }
            YoEquationDefinition definition = (YoEquationDefinition)this.definitionToEdit.getValue();
            definition.setEquation(newValue);
            this.updateEquation(true, false);
        });
        this.aliasListView.setCellFactory(param -> new YoEquationAliasListCell());
        this.aliasListView.getItems().addListener(c -> {
            this.aliasNameToControllerMap.clear();
            this.aliasNameToControllerMap.putAll(this.aliasListView.getItems().stream().collect(Collectors.toMap(a -> a.aliasNameLabel.getText(), a -> a)));
            this.equationAliasesValidityProperty.unbind();
            if (c.getList().isEmpty()) {
                this.equationAliasesValidityProperty.set(true);
            } else {
                BooleanProperty aliasInputValidity = ((YoEquationAliasController)this.aliasListView.getItems().get((int)0)).aliasValueSearchField.getValidityProperty();
                for (int i = 1; i < c.getList().size(); ++i) {
                    aliasInputValidity = Bindings.and((ObservableBooleanValue)aliasInputValidity, (ObservableBooleanValue)((YoEquationAliasController)this.aliasListView.getItems().get((int)i)).aliasValueSearchField.getValidityProperty());
                }
                this.equationAliasesValidityProperty.bind((ObservableValue)aliasInputValidity);
            }
        });
        this.validityProperty = Bindings.createBooleanBinding(() -> this.equationValidityProperty.get() && this.equationNameValidityProperty.get() && this.equationAliasesValidityProperty.get(), (Observable[])new Observable[]{this.equationValidityProperty, this.equationNameValidityProperty, this.equationAliasesValidityProperty});
        YoGraphicFXControllerTools.bindValidityImageView((ObservableBooleanValue)this.equationNameValidityProperty, this.equationNameValidImageView);
        YoGraphicFXControllerTools.bindValidityImageView((ObservableBooleanValue)this.equationValidityProperty, this.equationValidImageView);
        YoGraphicFXControllerTools.bindValidityImageView((ObservableBooleanValue)this.equationAliasesValidityProperty, this.equationAliasesValidImageView);
    }

    private void updateEquation(boolean updateAliases, boolean removeUnusedAliases) {
        Equation equation;
        if (this.definitionToEdit.getValue() == null) {
            return;
        }
        YoEquationDefinition definition = (YoEquationDefinition)this.definitionToEdit.getValue();
        try {
            equation = Equation.parse((String)definition.getEquation());
            this.equationValidityProperty.set(true);
        }
        catch (Exception e) {
            LogTools.error((String)"Unable to parse equation: {}", (Object)e.getMessage());
            this.equationValidityProperty.set(false);
            this.updateListener.run();
            return;
        }
        if (updateAliases) {
            this.updateAliases(equation, removeUnusedAliases);
        }
        this.updateListener.run();
    }

    private void updateAliases(Equation equation, boolean removeUnusedAliases) {
        YoEquationDefinition.EquationInputDefinition aliasValue;
        ArrayList<Pair<String, YoEquationDefinition.EquationInputDefinition>> newAliases = new ArrayList<Pair<String, YoEquationDefinition.EquationInputDefinition>>();
        for (EquationAliasManager.EquationAlias alias : equation.getBuilder().getAliasManager().getUserAliases().values()) {
            String aliasName = alias.name();
            aliasValue = alias.input().toInputDefinition();
            newAliases.add((Pair<String, YoEquationDefinition.EquationInputDefinition>)new Pair((Object)aliasName, (Object)aliasValue));
        }
        for (String aliasName : equation.getBuilder().getAliasManager().getMissingInputs()) {
            YoEquationAliasController aliasController = (YoEquationAliasController)this.aliasNameToControllerMap.get((Object)aliasName);
            aliasValue = aliasController == null ? null : aliasController.getAliasValue();
            newAliases.add((Pair<String, YoEquationDefinition.EquationInputDefinition>)new Pair((Object)aliasName, (Object)aliasValue));
        }
        newAliases.sort(Comparator.comparing(Pair::getKey));
        this.setAliases(newAliases, removeUnusedAliases);
    }

    private void setAliases(List<Pair<String, YoEquationDefinition.EquationInputDefinition>> newAliases, boolean removeOldAliases) {
        if (removeOldAliases) {
            this.aliasListView.getItems().clear();
            for (Pair<String, YoEquationDefinition.EquationInputDefinition> alias : newAliases) {
                String aliasName = (String)alias.getKey();
                YoEquationDefinition.EquationInputDefinition aliasValue = (YoEquationDefinition.EquationInputDefinition)alias.getValue();
                this.aliasListView.getItems().add((Object)this.newAliasController(aliasName, aliasValue));
            }
        } else {
            ArrayList<YoEquationAliasController> newAliasControllers = new ArrayList<YoEquationAliasController>((Collection<YoEquationAliasController>)this.aliasListView.getItems());
            for (Pair<String, YoEquationDefinition.EquationInputDefinition> alias : newAliases) {
                String aliasName = (String)alias.getKey();
                YoEquationDefinition.EquationInputDefinition aliasValue = (YoEquationDefinition.EquationInputDefinition)alias.getValue();
                YoEquationAliasController aliasController = (YoEquationAliasController)this.aliasNameToControllerMap.get((Object)aliasName);
                if (aliasController == null) {
                    newAliasControllers.add(this.newAliasController(aliasName, aliasValue));
                    continue;
                }
                aliasController.setAliasValue(aliasValue);
            }
            newAliasControllers.sort(Comparator.comparing(a -> a.aliasNameLabel.getText()));
            this.aliasListView.getItems().setAll(newAliasControllers);
        }
    }

    private YoEquationAliasController newAliasController(String aliasName, YoEquationDefinition.EquationInputDefinition aliasValue) {
        YoCompositeSearchManager yoCompositeSearchManager = this.toolkit.getYoCompositeSearchManager();
        YoEquationAliasController aliasController = new YoEquationAliasController(aliasName, aliasValue, yoCompositeSearchManager);
        aliasController.aliasValueSearchField.supplierProperty().addListener((o, oldValue, newValue) -> {
            if (newValue != null) {
                this.updateAliasValue(aliasController);
            }
        });
        return aliasController;
    }

    private void updateAliasValue(YoEquationAliasController aliasController) {
        if (this.definitionToEdit.getValue() == null) {
            return;
        }
        String aliasName = aliasController.getAliasName();
        List definitionAliases = ((YoEquationDefinition)this.definitionToEdit.getValue()).getAliases();
        YoEquationDefinition.EquationAliasDefinition newAlias = new YoEquationDefinition.EquationAliasDefinition(aliasName, aliasController.getAliasValue());
        YoEquationDefinition.EquationAliasDefinition old = definitionAliases.stream().filter(a -> a.getName().equals(aliasName)).findFirst().orElse(null);
        if (old != null) {
            definitionAliases.set(definitionAliases.indexOf(old), newAlias);
        } else {
            definitionAliases.add(newAlias);
        }
        this.updateListener.run();
    }

    @FXML
    public void removeUnusedAliases() {
        this.updateEquation(true, true);
    }

    public Pane getMainPane() {
        return this.mainPane;
    }

    public TextField getEquationNameTextField() {
        return this.equationNameTextField;
    }

    public TextArea getEquationTextArea() {
        return this.equationTextArea;
    }

    public Property<YoEquationDefinition> definitionProperty() {
        return this.definitionToEdit;
    }

    public YoEquationDefinition getDefinition() {
        return (YoEquationDefinition)this.definitionToEdit.getValue();
    }

    public ObservableBooleanValue validityProperty() {
        return this.validityProperty;
    }

    public void setUpdateListener(Runnable updateListener) {
        this.updateListener = updateListener;
    }

    private static class YoEquationAliasController {
        private final Label aliasNameLabel;
        private final StringSearchField aliasValueSearchField;
        private final HBox mainPane = new HBox(5.0);

        public YoEquationAliasController(String aliasName, YoEquationDefinition.EquationInputDefinition aliasValue, YoCompositeSearchManager searchManager) {
            this.aliasNameLabel = new Label();
            this.setAliasName(aliasName);
            JFXTextField textField = new JFXTextField();
            textField.setPrefWidth(200.0);
            HBox.setHgrow((Node)this.aliasNameLabel, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)textField, (Priority)Priority.ALWAYS);
            this.mainPane.getChildren().addAll((Object[])new Node[]{this.aliasNameLabel, textField});
            this.aliasValueSearchField = new StringSearchField((TextField)textField, searchManager);
            this.setAliasValue(aliasValue);
            this.aliasValueSearchField.setupAutoCompletion();
            this.aliasValueSearchField.supplierProperty().addListener((o, oldValue, newValue) -> {
                if (newValue == null) {
                    LogTools.info((String)"Alias {} is not valid.", (Object)aliasName);
                }
            });
        }

        public void setAliasName(String aliasName) {
            this.aliasNameLabel.setText(aliasName);
        }

        private void setAliasValue(YoEquationDefinition.EquationInputDefinition aliasValue) {
            if (aliasValue == null) {
                this.aliasValueSearchField.getTextField().setText("");
            } else {
                this.aliasValueSearchField.getTextField().setText(aliasValue.computeSimpleStringValue());
            }
        }

        public Pane getMainPane() {
            return this.mainPane;
        }

        public String getAliasName() {
            return this.aliasNameLabel.getText();
        }

        public YoEquationDefinition.EquationInputDefinition getAliasValue() {
            if (this.aliasValueSearchField.supplierProperty().get() == null) {
                return null;
            }
            if (this.aliasValueSearchField.isNumber()) {
                return new YoEquationDefinition.EquationInputDefinition(((StringProperty)this.aliasValueSearchField.supplierProperty().get()).getValue());
            }
            if (this.aliasValueSearchField.isYoComposite()) {
                if (this.aliasValueSearchField.getYoComposite().getYoComponents().size() == 1) {
                    return new YoEquationDefinition.EquationInputDefinition(SharedMemoryIOTools.toYoVariableDefinition((YoVariable)this.aliasValueSearchField.getYoComposite().getYoComponents().get(0)));
                }
                LogTools.warn((String)"Complex YoComposites are not handled yet, {}", (Object)this.aliasValueSearchField.getYoComposite().getPattern());
            }
            return null;
        }
    }

    private static class YoEquationAliasListCell
    extends ListCell<YoEquationAliasController> {
        protected void updateItem(YoEquationAliasController item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (item != null && !empty) {
                this.setGraphic((Node)item.getMainPane());
            } else {
                this.setGraphic(null);
            }
        }
    }
}

