/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu;

import java.io.File;
import javafx.fxml.FXML;
import javafx.scene.control.MenuItem;
import javafx.stage.Window;
import javafx.util.Pair;
import org.kordamp.ikonli.javafx.FontIcon;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryWindowManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;

public class YoChartMenuController
implements VisualizerController {
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private Window owner;
    private boolean isYAxisVisible = false;
    @FXML
    private MenuItem toggleYAxisMenuItem;
    @FXML
    private FontIcon toggleYAxisIcon;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.owner = toolkit.getWindow();
    }

    @FXML
    public void toggleChartYAxis() {
        this.isYAxisVisible = !this.isYAxisVisible;
        this.messager.submitMessage(this.topics.getYoChartShowYAxis(), (Object)new Pair((Object)this.owner, (Object)this.isYAxisVisible));
        this.updateMenuItemText();
    }

    private void updateMenuItemText() {
        if (this.isYAxisVisible) {
            this.toggleYAxisMenuItem.setText("Hide Charts Y-Axis");
            this.toggleYAxisIcon.getStyleClass().clear();
            this.toggleYAxisIcon.getStyleClass().addAll((Object[])new String[]{"hide-icon-view", "menu-item-icon-view"});
        } else {
            this.toggleYAxisMenuItem.setText("Show Charts Y-Axis");
            this.toggleYAxisIcon.getStyleClass().clear();
            this.toggleYAxisIcon.getStyleClass().addAll((Object[])new String[]{"show-icon-view", "menu-item-icon-view"});
        }
    }

    @FXML
    public void loadChartGroup() {
        File result = SessionVisualizerIOTools.yoChartConfigurationOpenFileDialog(this.owner);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoChartGroupLoadConfiguration(), (Object)new Pair((Object)this.owner, (Object)result));
        }
    }

    @FXML
    public void saveChartGroup() {
        File result = SessionVisualizerIOTools.yoChartConfigurationSaveFileDialog(this.owner);
        if (result != null) {
            this.messager.submitMessage(this.topics.getYoChartGroupSaveConfiguration(), (Object)new Pair((Object)this.owner, (Object)result));
        }
    }

    @FXML
    public void newChartWindow() {
        this.messager.submitMessage(this.topics.getOpenWindowRequest(), (Object)SecondaryWindowManager.NewWindowRequest.chartWindow(this.owner));
    }
}

