/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.SixDoFJointDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionRobotDefinitionListChange;
import us.ihmc.scs2.sessionVisualizer.jfx.Camera3DRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.FrameNode;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.yoRobot.NewRobotVisualRequest;
import us.ihmc.scs2.sessionVisualizer.jfx.yoRobot.YoRobotFX;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class YoRobotFXManager
extends ObservedAnimationTimer
implements Manager {
    private final Group rootNode = new Group();
    private final List<YoRobotFX> robots = new ArrayList<YoRobotFX>();
    private final ObservableList<RobotDefinition> robotDefinitions = FXCollections.observableArrayList();
    private int numberOfRobotDefinitions = -1;

    public YoRobotFXManager(final JavaFXMessager messager, final SessionVisualizerTopics topics, final YoManager yoManager, final ReferenceFrameManager referenceFrameManager, final BackgroundExecutorManager backgroundExecutorManager) {
        this.robotDefinitions.addListener((ListChangeListener)new ListChangeListener<RobotDefinition>(){

            public void onChanged(ListChangeListener.Change<? extends RobotDefinition> c) {
                while (c.next()) {
                    if (c.wasAdded()) {
                        List<YoRobotFX> robotsToAttach = c.getAddedSubList().stream().map(this::newYoRobotFX).toList();
                        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                            YoRobotFXManager.this.robots.addAll(robotsToAttach);
                            YoRobotFXManager.this.rootNode.getChildren().addAll(robotsToAttach.stream().map(YoRobotFX::getRootNode).toList());
                            if (YoRobotFXManager.this.robots.size() == 1) {
                                YoRobotFX robotToTrack = YoRobotFXManager.this.robots.get(0);
                                SixDoFJointDefinition rootJoint = ((RobotDefinition)YoRobotFXManager.this.robotDefinitions.get(0)).getFloatingRootJointDefinition();
                                if (rootJoint != null) {
                                    String mainBody = rootJoint.getSuccessor().getName();
                                    backgroundExecutorManager.scheduleInBackgroundWithCondition(() -> YoRobotFXManager.this.isSessionLoaded(), () -> {
                                        FrameNode rigidBodyFrameNode = robotToTrack.findRigidBodyFrameNode(mainBody);
                                        if (rigidBodyFrameNode != null && rigidBodyFrameNode.getNode() != null) {
                                            messager.submitMessage(topics.getCamera3DRequest(), (Object)new Camera3DRequest(Camera3DRequest.FocalPointRequest.trackNode(rigidBodyFrameNode.getNode())));
                                        }
                                    });
                                }
                            }
                        });
                    }
                    if (!c.wasRemoved()) continue;
                    List<YoRobotFX> robotsToRemove = c.getRemoved().stream().map(robotDefinition -> YoRobotFXManager.this.getRobotFX((RobotDefinition)robotDefinition)).filter(Optional::isPresent).map(Optional::get).toList();
                    JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                        YoRobotFXManager.this.rootNode.getChildren().removeAll(robotsToRemove.stream().map(YoRobotFX::getRootNode).toList());
                        YoRobotFXManager.this.robots.removeAll(robotsToRemove);
                    });
                }
            }

            private YoRobotFX newYoRobotFX(RobotDefinition robotDefinition) {
                YoRobotFX robot = new YoRobotFX(yoManager, referenceFrameManager, robotDefinition);
                robot.loadRobot(command -> backgroundExecutorManager.queueTaskToExecuteInBackground(this, command));
                return robot;
            }
        });
        messager.addTopicListener(topics.getCamera3DRequest(), request -> {
            if (!this.isSessionLoaded()) {
                throw new IllegalOperationException("Session has not been loaded yet.");
            }
            Camera3DRequest.FocalPointRequest focalPointRequest = request.getFocalPointRequest();
            if (focalPointRequest == null) {
                return;
            }
            String rigidBodyName = focalPointRequest.getRigidBodyName();
            String robotName = focalPointRequest.getRobotName();
            if (rigidBodyName != null) {
                Optional<FrameNode> result = robotName != null ? this.getRobotFX(robotName).map(r -> r.findRigidBodyFrameNode(rigidBodyName)) : this.robots.stream().map(r -> r.findRigidBodyFrameNode(rigidBodyName)).filter(Objects::nonNull).findFirst();
                result.ifPresent(rigidBodyFrameNode -> {
                    if (rigidBodyFrameNode.getNode() != null) {
                        messager.submitMessage(topics.getCamera3DRequest(), (Object)new Camera3DRequest(Camera3DRequest.FocalPointRequest.trackNode(rigidBodyFrameNode.getNode())));
                    }
                });
            }
        });
        messager.addTopicListener(topics.getRobotVisualRequest(), this::handleRobotVisualRequest);
        messager.addFXTopicListener(topics.getSessionRobotDefinitionListChangeState(), this::handleSessionRobotDefinitionListChangeState);
    }

    private void handleSessionRobotDefinitionListChangeState(SessionRobotDefinitionListChange change) {
        if (change.getAddedRobotDefinition() == null) {
            LogTools.warn((String)"Received request but robot definition is null, ignoring.");
            return;
        }
        switch (change.getChangeType()) {
            case ADD: {
                this.robotDefinitions.add((Object)change.getAddedRobotDefinition());
                break;
            }
            case REMOVE: {
                this.robotDefinitions.remove((Object)change.getRemovedRobotDefinition());
                break;
            }
            case REPLACE: {
                this.robotDefinitions.remove((Object)change.getRemovedRobotDefinition());
                this.robotDefinitions.add((Object)change.getAddedRobotDefinition());
            }
        }
    }

    private void handleRobotVisualRequest(NewRobotVisualRequest request) {
        String robotName = request.getRobotName();
        if (robotName == null) {
            LogTools.warn((String)"Received request but robot name is null, ignoring.");
            return;
        }
        if (robotName.equals("AllOfTheRobots!")) {
            if (request.getRequestedVisible() != null) {
                this.robots.forEach(robot -> robot.getRootNode().setVisible(request.getRequestedVisible().booleanValue()));
            }
            if (request.getRequestedDrawMode() != null) {
                this.robots.forEach(robot -> robot.setDrawMode(request.getRequestedDrawMode()));
            }
        } else {
            YoRobotFX robot2 = this.robots.stream().filter(r -> r.getRobotDefinition().getName().equalsIgnoreCase(robotName)).findFirst().orElse(null);
            if (robot2 == null) {
                LogTools.warn((String)"Could not find robot named: {}, ignoring request.", (Object)robotName);
                return;
            }
            if (request.getRequestedVisible() != null) {
                robot2.getRootNode().setVisible(request.getRequestedVisible().booleanValue());
            }
            if (request.getRequestedDrawMode() != null) {
                robot2.setDrawMode(request.getRequestedDrawMode());
            }
        }
    }

    public ObservableList<RobotDefinition> getRobotDefinitions() {
        return this.robotDefinitions;
    }

    @Override
    public void handleImpl(long now) {
        this.robots.forEach(YoRobotFX::render);
    }

    @Override
    public void startSession(Session session) {
        this.start();
        List robotDefinitions = session.getRobotDefinitions();
        this.numberOfRobotDefinitions = robotDefinitions.size();
        this.robotDefinitions.addAll((Collection)robotDefinitions);
    }

    @Override
    public void stopSession() {
        this.robotDefinitions.clear();
        this.numberOfRobotDefinitions = -1;
    }

    @Override
    public boolean isSessionLoaded() {
        if (this.robots.size() < this.numberOfRobotDefinitions) {
            return false;
        }
        return this.robots.stream().allMatch(YoRobotFX::isRobotLoaded);
    }

    public RigidBodyReadOnly getRobotRootBody(String robotName) {
        return this.getRobotFX(robotName).map(YoRobotFX::getRootBody).orElse(null);
    }

    private Optional<YoRobotFX> getRobotFX(RobotDefinition robotDefinition) {
        return this.getRobotFX(robotDefinition.getName());
    }

    private Optional<YoRobotFX> getRobotFX(String robotName) {
        return this.robots.stream().filter(robot -> robot.getRobotDefinition().getName().equalsIgnoreCase(robotName)).findFirst();
    }

    public Group getRootNode() {
        return this.rootNode;
    }
}

