/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoComposite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartGroupModel;

public class YoCompositePattern {
    private final String type;
    private final String[] componentIdentifiers;
    private final List<String[]> alternateComponentIdentifiers = new ArrayList<String[]>();
    private final boolean crossRegistry;
    private final List<ChartGroupModel> preferredChartConfigurations;

    public static YoCompositePattern singleton(String type) {
        return new YoCompositePattern(type, false, null, new ArrayList<ChartGroupModel>());
    }

    public YoCompositePattern(String type, boolean crossRegistry, String[] componentIdentifiers, List<ChartGroupModel> preferredChartConfigurations) {
        this(type, crossRegistry, componentIdentifiers, Collections.emptyList(), preferredChartConfigurations);
    }

    public YoCompositePattern(String type, boolean crossRegistry, String[] componentIdentifiers, List<String[]> alternateComponentIdentifiers, List<ChartGroupModel> preferredChartConfigurations) {
        this.type = type;
        this.crossRegistry = crossRegistry;
        if (componentIdentifiers != null) {
            componentIdentifiers = (String[])Stream.of(componentIdentifiers).toArray(String[]::new);
            if (preferredChartConfigurations == null) {
                preferredChartConfigurations = new ArrayList<ChartGroupModel>();
            }
            for (ChartGroupModel chartIdentifierList : preferredChartConfigurations) {
                if (chartIdentifierList.size() == componentIdentifiers.length) continue;
                throw new IllegalArgumentException("Unexpected chart configuration size for composite " + type + ".\nThe size of each preferred chart configuration should be equal to the number of components in the composite.\nProblematic chart configuration: " + chartIdentifierList.getName() + " configuration size " + chartIdentifierList.size() + " expected " + componentIdentifiers.length + ".");
            }
        }
        if (componentIdentifiers == null && !alternateComponentIdentifiers.isEmpty()) {
            throw new IllegalArgumentException("Unexpected alternate component identifiers for composite " + type + ".\nThe alternate component identifiers can only be set if the component identifiers are set.\nProblematic alternate component identifiers: " + alternateComponentIdentifiers);
        }
        this.componentIdentifiers = componentIdentifiers;
        this.preferredChartConfigurations = preferredChartConfigurations;
        alternateComponentIdentifiers.forEach(this::addAlternateComponentIdentifiers);
    }

    public void addAlternateComponentIdentifiers(String[] alternateComponentIdentifiers) {
        if (alternateComponentIdentifiers.length != this.componentIdentifiers.length) {
            throw new IllegalArgumentException("Unexpected alternate component identifiers size for composite " + this.type + ".\nThe size of each alternate component identifiers should be equal to the number of components in the composite.\nProblematic alternate component identifiers: " + Arrays.toString(alternateComponentIdentifiers) + " expected " + this.componentIdentifiers.length + ".");
        }
        this.alternateComponentIdentifiers.add(alternateComponentIdentifiers);
    }

    public String getType() {
        return this.type;
    }

    public String[] getComponentIdentifiers() {
        return this.componentIdentifiers;
    }

    public List<String[]> getAlternateComponentIdentifiers() {
        return this.alternateComponentIdentifiers;
    }

    public boolean isCrossRegistry() {
        return this.crossRegistry;
    }

    public List<ChartGroupModel> getPreferredChartConfigurations() {
        return this.preferredChartConfigurations;
    }

    public String toString() {
        return this.type + ", components " + Arrays.toString(this.componentIdentifiers);
    }
}

