/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import java.util.function.UnaryOperator;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.Pane;
import javafx.util.StringConverter;
import us.ihmc.scs2.definition.yoChart.YoChartIdentifierDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartIdentifier;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.UIElement;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ChartTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.IntegerConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.PositiveIntegerValueFilter;

public class YoChartIdentifierEditorController
implements UIElement {
    @FXML
    private Pane mainPane;
    @FXML
    private Label chartIdLabel;
    @FXML
    private Label rowLabel;
    @FXML
    private Label columnLabel;
    @FXML
    private TextField rowTextField;
    @FXML
    private TextField columnTextField;
    private final ObjectProperty<YoChartIdentifierDefinition> chartIdentifierProperty = new SimpleObjectProperty((Object)new YoChartIdentifierDefinition());

    public void initialize(SessionVisualizerToolkit toolkit) {
        TextFormatter rowTextFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)0, (UnaryOperator)new PositiveIntegerValueFilter());
        TextFormatter columnTextFormatter = new TextFormatter((StringConverter)new IntegerConverter(), (Object)0, (UnaryOperator)new PositiveIntegerValueFilter());
        this.rowTextField.setTextFormatter(rowTextFormatter);
        this.columnTextField.setTextFormatter(columnTextFormatter);
        ObjectProperty rowProperty = rowTextFormatter.valueProperty();
        ObjectProperty columnProperty = columnTextFormatter.valueProperty();
        rowProperty.addListener((o, oldValue, newValue) -> this.chartIdentifierProperty.set((Object)new YoChartIdentifierDefinition(newValue.intValue(), ((Integer)columnProperty.get()).intValue())));
        columnProperty.addListener((o, oldValue, newValue) -> this.chartIdentifierProperty.set((Object)new YoChartIdentifierDefinition(((Integer)rowProperty.get()).intValue(), newValue.intValue())));
        this.chartIdentifierProperty.addListener((o, oldValue, newValue) -> {
            rowProperty.set((Object)newValue.getRow());
            columnProperty.set((Object)newValue.getColumn());
        });
    }

    public void setInput(int row, int column) {
        this.chartIdentifierProperty.set((Object)new YoChartIdentifierDefinition(row, column));
    }

    public void setInput(YoChartIdentifierDefinition chartIdentifier) {
        this.setInput(ChartTools.toChartIdentifier(chartIdentifier));
    }

    public void setInput(ChartIdentifier chartIdentifier) {
        this.chartIdentifierProperty.set((Object)ChartTools.toYoChartIdentifierDefinition(chartIdentifier));
    }

    public ObjectProperty<YoChartIdentifierDefinition> chartIdentifierProperty() {
        return this.chartIdentifierProperty;
    }

    public Label getChartIdLabel() {
        return this.chartIdLabel;
    }

    public Label getRowLabel() {
        return this.rowLabel;
    }

    public Label getColumnLabel() {
        return this.columnLabel;
    }

    public void closeAndDispose() {
    }

    @Override
    public Pane getMainPane() {
        return this.mainPane;
    }
}

