/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import gnu.trove.list.array.TLongArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import us.ihmc.euclid.tools.EuclidCoreTools;

public class TimestampScrubber {
    private final boolean hasTimebase;
    private final boolean interlaced;
    private long[] robotTimestamps;
    private long[] videoTimestamps;
    private int currentIndex = 0;
    private long currentRobotTimestamp = 0L;
    private long videoTimestamp;
    private boolean[] replacedRobotTimestampIndex;

    public TimestampScrubber(File timestampFile, boolean hasTimebase, boolean interlaced) throws IOException {
        this.hasTimebase = hasTimebase;
        this.interlaced = interlaced;
        this.parseTimestampData(timestampFile);
    }

    private void parseTimestampData(File timestampFile) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(timestampFile));){
            String line;
            if (this.hasTimebase) {
                if (bufferedReader.readLine() == null) {
                    throw new IOException("Cannot read numerator");
                }
                if (bufferedReader.readLine() == null) {
                    throw new IOException("Cannot read denumerator");
                }
            }
            TLongArrayList robotTimestamps = new TLongArrayList();
            TLongArrayList videoTimestamps = new TLongArrayList();
            while ((line = bufferedReader.readLine()) != null) {
                String[] stamps = line.split("\\s");
                long robotStamp = Long.parseLong(stamps[0]);
                long videoStamp = Long.parseLong(stamps[1]);
                if (this.interlaced) {
                    videoStamp /= 2L;
                }
                robotTimestamps.add(robotStamp);
                videoTimestamps.add(videoStamp);
            }
            this.robotTimestamps = robotTimestamps.toArray();
            this.videoTimestamps = videoTimestamps.toArray();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        this.checkAndReplaceDuplicates();
    }

    private void checkAndReplaceDuplicates() {
        this.replacedRobotTimestampIndex = new boolean[this.robotTimestamps.length];
        int duplicatesAtEndOfFile = this.getNumberOfDuplicatesAtEndOfFile();
        int currentIndex = 0;
        while (currentIndex < this.robotTimestamps.length - duplicatesAtEndOfFile) {
            if (this.robotTimestamps[currentIndex] != this.robotTimestamps[currentIndex + 1]) {
                ++currentIndex;
                continue;
            }
            this.replacedRobotTimestampIndex[currentIndex + 1] = true;
            int nextNonDuplicateIndex = this.getNextNonDuplicateIndex(currentIndex);
            for (int i = currentIndex; i < nextNonDuplicateIndex; ++i) {
                long firstAdjustedTimestamp;
                this.robotTimestamps[i + 1] = firstAdjustedTimestamp = (long)EuclidCoreTools.interpolate((double)this.robotTimestamps[i], (double)this.robotTimestamps[nextNonDuplicateIndex], (double)(1.0 / (double)(nextNonDuplicateIndex - i)));
            }
            currentIndex = nextNonDuplicateIndex;
        }
    }

    private int getNumberOfDuplicatesAtEndOfFile() {
        int duplicatesAtEndOfFile = 1;
        for (int i = this.robotTimestamps.length - 1; i > 0; --i) {
            if (this.robotTimestamps[i] != this.robotTimestamps[i - 1]) continue;
            ++duplicatesAtEndOfFile;
        }
        return duplicatesAtEndOfFile;
    }

    private int getNextNonDuplicateIndex(int index) {
        while (index < this.robotTimestamps.length - 1 && this.robotTimestamps[index] == this.robotTimestamps[index + 1]) {
            ++index;
        }
        return index + 1;
    }

    public long getVideoTimestampFromRobotTimestamp(long queryRobotTimestamp) {
        this.currentIndex = this.searchRobotTimestampsForIndex(queryRobotTimestamp);
        this.videoTimestamp = this.videoTimestamps[this.currentIndex];
        this.currentRobotTimestamp = this.robotTimestamps[this.currentIndex];
        return this.videoTimestamp;
    }

    private int searchRobotTimestampsForIndex(long queryRobotTimestamp) {
        if (queryRobotTimestamp <= this.robotTimestamps[0]) {
            return 0;
        }
        if (queryRobotTimestamp >= this.robotTimestamps[this.robotTimestamps.length - 1]) {
            return this.robotTimestamps.length - 1;
        }
        int index = Arrays.binarySearch(this.robotTimestamps, queryRobotTimestamp);
        if (index < 0) {
            int nextIndex;
            index = nextIndex = -index - 1;
        }
        return index;
    }

    public long[] getCroppedRobotTimestamps(long startRobotTimestamp, long endRobotTimestamp) {
        int startIndex = this.findIndexOfRobotTimestamps(startRobotTimestamp);
        int endIndex = this.findIndexOfRobotTimestamps(endRobotTimestamp);
        return Arrays.copyOfRange(this.robotTimestamps, startIndex, endIndex + 1);
    }

    private int findIndexOfRobotTimestamps(long value) {
        if (value <= this.robotTimestamps[0]) {
            return 0;
        }
        if (value >= this.robotTimestamps[this.robotTimestamps.length - 1]) {
            return this.robotTimestamps.length - 1;
        }
        int index = Arrays.binarySearch(this.robotTimestamps, value);
        if (index < 0) {
            int nextIndex;
            index = nextIndex = -index - 1;
        }
        return index;
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public long getCurrentRobotTimestamp() {
        return this.currentRobotTimestamp;
    }

    public int getRobotTimestampsLength() {
        return this.robotTimestamps.length;
    }

    public long getRobotTimestampAtIndex(int i) {
        return this.robotTimestamps[i];
    }

    public long getVideoTimestampAtIndex(int i) {
        return this.videoTimestamps[i];
    }

    public long[] getRobotTimestampsArray() {
        return this.robotTimestamps;
    }

    public long[] getVideoTimestampsArray() {
        return this.videoTimestamps;
    }

    public long getCurrentVideoTimestamp() {
        return this.videoTimestamp;
    }

    public boolean getReplacedRobotTimestampIndex(int index) {
        return this.replacedRobotTimestampIndex[index];
    }
}

