/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.DoubleConsumer;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Shape3D;
import javafx.util.Duration;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.yoComposite.YoOrientation3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoQuaternionDefinition;
import us.ihmc.scs2.definition.yoComposite.YoTuple3DDefinition;
import us.ihmc.scs2.definition.yoComposite.YoYawPitchRollDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicRobotDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.FrameNode;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.RigidBodyFrameNodeFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.YoVariableDatabase;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.BaseColorFX;
import us.ihmc.scs2.sharedMemory.LinkedYoDouble;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimOneDoFJointBasics;

public class YoGhostRobotFX
extends YoGraphicFX3D {
    private final Group rootNode = new Group();
    private final YoVariableDatabase yoVariableDatabase;
    private final Property<RobotDefinition> robotDefinitionProperty = new SimpleObjectProperty((Object)this, "robotDefinition", null);
    private final Property<YoGraphicRobotDefinition.YoRobotStateDefinition> robotStateDefinitionProperty = new SimpleObjectProperty((Object)this, "robotStateDefinition", null);
    private boolean robotDefinitionChanged = true;
    private boolean robotStateDefinitionChanged = true;
    private Robot robot;
    private final ObservableMap<String, FrameNode> rigidBodyFrameNodeMap = FXCollections.observableMap(new ConcurrentHashMap(64));
    private final List<LinkedYoVariable<?>> linkedYoVariables = new ArrayList();
    private final AtomicBoolean forceUpdate = new AtomicBoolean(true);
    private final List<Runnable> clearStateBindingTasks = new ArrayList<Runnable>();
    private boolean initializeMaterial = true;
    private PhongMaterial overridingMaterial = null;
    private final List<Runnable> reverseOverridingMaterialTasks = new ArrayList<Runnable>();
    private final BooleanProperty rootJointPoseValid = new SimpleBooleanProperty((Object)this, "rootJointPoseValid", true);

    public YoGhostRobotFX(YoVariableDatabase yoVariableDatabase) {
        this.setColor((BaseColorFX)null);
        this.yoVariableDatabase = yoVariableDatabase;
        this.drawModeProperty.addListener((o, oldValue, newValue) -> JavaFXMissingTools.setDrawModeRecursive((Node)this.rootNode, newValue));
        this.rootJointPoseValid.addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.rootNode.setScaleX(1.0);
            } else {
                this.rootNode.setScaleX(0.0);
            }
        });
        this.rigidBodyFrameNodeMap.addListener(change -> {
            if (change.wasRemoved()) {
                FrameNode removedNode = (FrameNode)change.getValueRemoved();
                JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.rootNode.getChildren().remove((Object)removedNode.getNode()));
            } else if (change.wasAdded()) {
                FrameNode addedNode = (FrameNode)change.getValueAdded();
                Node node = addedNode.getNode();
                node.setScaleX(0.0);
                node.setScaleY(0.0);
                node.setScaleZ(0.0);
                if (this.overridingMaterial != null) {
                    this.overrideMaterialRecursive(node, this.overridingMaterial);
                }
                JavaFXMissingTools.setDrawModeRecursive(node, this.getDrawMode());
                Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1.0), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1.0), new KeyValue((WritableValue)node.scaleZProperty(), (Object)1.0)})});
                timeline.setCycleCount(1);
                JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                    addedNode.updatePose();
                    timeline.playFromStart();
                    this.rootNode.getChildren().add((Object)addedNode.getNode());
                });
            }
        });
    }

    public void setRobotDefinition(RobotDefinition robotDefinition) {
        if (!robotDefinition.equals(this.robotDefinitionProperty.getValue())) {
            this.setRobotStateDefinition(null);
        }
        this.robotDefinitionProperty.setValue((Object)robotDefinition);
        this.robotDefinitionChanged = true;
    }

    public void setRobotStateDefinition(YoGraphicRobotDefinition.YoRobotStateDefinition robotStateDefinition) {
        this.robotStateDefinitionProperty.setValue((Object)robotStateDefinition);
        this.robotStateDefinitionChanged = true;
    }

    private void updateRobotDefinition() {
        if (!this.robotDefinitionChanged) {
            return;
        }
        this.robotDefinitionChanged = false;
        this.rigidBodyFrameNodeMap.clear();
        this.reverseOverridingMaterialTasks.clear();
        RobotDefinition newRobotDefinition = (RobotDefinition)this.robotDefinitionProperty.getValue();
        if (newRobotDefinition == null) {
            this.robot = null;
            return;
        }
        this.robot = new Robot(newRobotDefinition, ReferenceFrameTools.constructARootFrame((String)"dummy"), false);
        RigidBodyFrameNodeFactories.createRobotFrameNodeMap((RigidBodyReadOnly)this.robot.getRootBody(), newRobotDefinition, null, this.rigidBodyFrameNodeMap);
        this.robotStateDefinitionChanged = true;
    }

    private void updateRobotStateDefinition() {
        if (!this.robotStateDefinitionChanged) {
            return;
        }
        this.clearRobotStateBindings();
        if (this.robot == null) {
            return;
        }
        this.robotStateDefinitionChanged = false;
        YoGraphicRobotDefinition.YoRobotStateDefinition newRobotStateDefinition = (YoGraphicRobotDefinition.YoRobotStateDefinition)this.robotStateDefinitionProperty.getValue();
        if (newRobotStateDefinition == null) {
            return;
        }
        YoTuple3DDefinition rootJointPositionDefinition = newRobotStateDefinition.getRootJointPosition();
        BooleanBinding rootJointPositionValidity = null;
        if (rootJointPositionDefinition != null) {
            Pose3DBasics pose = this.robot.getFloatingRootJoint().getJointPose();
            BooleanProperty xValid = this.setupBinding(rootJointPositionDefinition.getX(), arg_0 -> ((Pose3DBasics)pose).setX(arg_0));
            BooleanProperty yValid = this.setupBinding(rootJointPositionDefinition.getY(), arg_0 -> ((Pose3DBasics)pose).setY(arg_0));
            BooleanProperty zValid = this.setupBinding(rootJointPositionDefinition.getZ(), arg_0 -> ((Pose3DBasics)pose).setZ(arg_0));
            rootJointPositionValidity = xValid.and((ObservableBooleanValue)yValid).and((ObservableBooleanValue)zValid);
        }
        YoOrientation3DDefinition rootJointOrientationDefinition = newRobotStateDefinition.getRootJointOrientation();
        BooleanBinding rootJointOrientationValidity = null;
        if (rootJointOrientationDefinition != null) {
            QuaternionBasics orientation = this.robot.getFloatingRootJoint().getJointPose().getOrientation();
            if (rootJointOrientationDefinition instanceof YoYawPitchRollDefinition) {
                YoYawPitchRollDefinition yawPitchRollDefinition = (YoYawPitchRollDefinition)rootJointOrientationDefinition;
                BooleanProperty yawValid = this.setupBinding(yawPitchRollDefinition.getYaw(), newValue -> orientation.setYawPitchRoll(newValue, orientation.getPitch(), orientation.getRoll()));
                BooleanProperty pitchValid = this.setupBinding(yawPitchRollDefinition.getPitch(), newValue -> orientation.setYawPitchRoll(orientation.getYaw(), newValue, orientation.getRoll()));
                BooleanProperty rollValid = this.setupBinding(yawPitchRollDefinition.getRoll(), newValue -> orientation.setYawPitchRoll(orientation.getYaw(), orientation.getPitch(), newValue));
                rootJointOrientationValidity = yawValid.and((ObservableBooleanValue)pitchValid).and((ObservableBooleanValue)rollValid);
            } else if (rootJointOrientationDefinition instanceof YoQuaternionDefinition) {
                YoQuaternionDefinition quaternionDefinition = (YoQuaternionDefinition)rootJointOrientationDefinition;
                BooleanProperty xValid = this.setupBinding(quaternionDefinition.getX(), newValue -> orientation.setUnsafe(newValue, orientation.getY(), orientation.getZ(), orientation.getS()));
                BooleanProperty yValid = this.setupBinding(quaternionDefinition.getY(), newValue -> orientation.setUnsafe(orientation.getX(), newValue, orientation.getZ(), orientation.getS()));
                BooleanProperty zValid = this.setupBinding(quaternionDefinition.getZ(), newValue -> orientation.setUnsafe(orientation.getX(), orientation.getY(), newValue, orientation.getS()));
                BooleanProperty sValid = this.setupBinding(quaternionDefinition.getS(), newValue -> orientation.setUnsafe(orientation.getX(), orientation.getY(), orientation.getZ(), newValue));
                rootJointOrientationValidity = xValid.and((ObservableBooleanValue)yValid).and((ObservableBooleanValue)zValid).and((ObservableBooleanValue)sValid);
            } else {
                LogTools.error((String)("Unsupported root joint orientation: " + rootJointOrientationDefinition));
            }
        }
        if (rootJointPositionValidity != null && rootJointOrientationValidity != null) {
            this.rootJointPoseValid.bind((ObservableValue)Bindings.and(rootJointPositionValidity, rootJointOrientationValidity));
        } else if (rootJointPositionValidity != null) {
            this.rootJointPoseValid.bind(rootJointPositionValidity);
        } else if (rootJointOrientationValidity != null) {
            this.rootJointPoseValid.bind(rootJointOrientationValidity);
        }
        if (newRobotStateDefinition.getJointPositions() != null) {
            for (YoGraphicRobotDefinition.YoOneDoFJointStateDefinition jointPositionDefinition : newRobotStateDefinition.getJointPositions()) {
                String jointName = jointPositionDefinition.getJointName();
                SimOneDoFJointBasics joint = this.robot.getOneDoFJoint(jointName);
                if (joint == null) {
                    LogTools.error((String)("Could not find joint: " + jointName));
                    continue;
                }
                this.setupBinding(jointPositionDefinition.getJointPosition(), arg_0 -> ((SimOneDoFJointBasics)joint).setQ(arg_0));
            }
        }
        this.forceUpdate.set(true);
    }

    private BooleanProperty setupBinding(String variableName, DoubleConsumer setter) {
        DoubleProperty doubleProperty = this.toDoubleProperty(variableName);
        SimpleBooleanProperty validityProperty = new SimpleBooleanProperty((Object)this, variableName + " - valid", true);
        ChangeListener changeListener = (arg_0, arg_1, arg_2) -> this.lambda$setupBinding$12((BooleanProperty)validityProperty, setter, arg_0, arg_1, arg_2);
        doubleProperty.addListener(changeListener);
        changeListener.changed((ObservableValue)doubleProperty, null, (Object)doubleProperty.getValue());
        this.clearStateBindingTasks.add(() -> doubleProperty.removeListener(changeListener));
        return validityProperty;
    }

    private DoubleProperty toDoubleProperty(String variableName) {
        if (variableName == null) {
            return new SimpleDoubleProperty((Object)this, "dummy", 0.0);
        }
        DoubleProperty doubleProperty = CompositePropertyTools.toDoubleProperty(this.yoVariableDatabase, variableName);
        if (doubleProperty instanceof YoDoubleProperty) {
            YoDoubleProperty yoDoubleProperty = (YoDoubleProperty)doubleProperty;
            LinkedYoDouble linkedYoDouble = yoDoubleProperty.getLinkedBuffer();
            this.linkedYoVariables.add((LinkedYoVariable<?>)linkedYoDouble);
            this.clearStateBindingTasks.add(() -> {
                yoDoubleProperty.dispose();
                linkedYoDouble.dispose();
            });
        }
        return doubleProperty;
    }

    @Override
    public void computeBackground() {
        this.updateRobotDefinition();
        this.updateRobotStateDefinition();
    }

    @Override
    public void render() {
        if (this.robot == null) {
            return;
        }
        boolean updateRobot = false;
        for (int i = 0; i < this.linkedYoVariables.size(); ++i) {
            updateRobot |= this.linkedYoVariables.get(i).pull();
        }
        if (!updateRobot) {
            updateRobot = this.forceUpdate.getAndSet(false);
        }
        if (updateRobot) {
            this.robot.getRootBody().updateFramesRecursively();
            this.rigidBodyFrameNodeMap.values().forEach(FrameNode::updatePose);
        }
        if (this.initializeMaterial || this.getColor() == null != (this.overridingMaterial == null)) {
            this.initializeMaterial = false;
            if (this.getColor() == null) {
                this.reverseOverridingMaterialTasks.forEach(Runnable::run);
                this.reverseOverridingMaterialTasks.clear();
                this.overridingMaterial = null;
            } else {
                this.overridingMaterial = new PhongMaterial();
                this.overrideMaterialRecursive((Node)this.rootNode, this.overridingMaterial);
            }
        }
        if (this.getColor() != null) {
            this.overridingMaterial.setDiffuseColor(this.getColor().get());
        }
    }

    private void overrideMaterialRecursive(Node start, PhongMaterial material) {
        if (start instanceof Group) {
            Group group = (Group)start;
            group.getChildren().forEach(child -> this.overrideMaterialRecursive((Node)child, material));
        } else if (start instanceof Shape3D) {
            Shape3D shape = (Shape3D)start;
            Material originalMaterial = shape.getMaterial();
            this.reverseOverridingMaterialTasks.add(() -> shape.setMaterial(originalMaterial));
            shape.setMaterial((Material)material);
        }
    }

    public RobotDefinition getRobotDefinition() {
        return (RobotDefinition)this.robotDefinitionProperty.getValue();
    }

    public YoGraphicRobotDefinition.YoRobotStateDefinition getRobotStateDefinition() {
        return (YoGraphicRobotDefinition.YoRobotStateDefinition)this.robotStateDefinitionProperty.getValue();
    }

    @Override
    public void clear() {
        this.robot = null;
        this.rigidBodyFrameNodeMap.clear();
        this.rootNode.getChildren().clear();
        this.clearRobotStateBindings();
    }

    private void clearRobotStateBindings() {
        this.clearStateBindingTasks.forEach(Runnable::run);
        this.clearStateBindingTasks.clear();
        this.linkedYoVariables.clear();
    }

    @Override
    public YoGraphicFX clone() {
        YoGhostRobotFX clone = new YoGhostRobotFX(this.yoVariableDatabase);
        clone.setName(this.getName());
        clone.setColor(this.getColor());
        clone.setVisible(this.isVisible());
        clone.setRobotDefinition((RobotDefinition)this.robotDefinitionProperty.getValue());
        clone.setRobotStateDefinition((YoGraphicRobotDefinition.YoRobotStateDefinition)this.robotStateDefinitionProperty.getValue());
        clone.setDrawMode(this.getDrawMode());
        return clone;
    }

    @Override
    public Node getNode() {
        return this.rootNode;
    }

    private /* synthetic */ void lambda$setupBinding$12(BooleanProperty validityProperty, DoubleConsumer setter, ObservableValue o, Number oldValue, Number newValue) {
        boolean isValid = newValue != null && Double.isFinite(newValue.doubleValue());
        validityProperty.set(isValid);
        if (isValid) {
            setter.accept(newValue.doubleValue());
        }
        this.forceUpdate.set(true);
    }
}

