/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.mcap;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Function;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.apache.commons.lang3.mutable.MutableLong;
import us.ihmc.scs2.session.mcap.MCAPConsoleLogManager;
import us.ihmc.scs2.session.mcap.MCAPLogFileReader;
import us.ihmc.scs2.session.mcap.MCAPLogSession;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.MenuTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.simulation.SpyList;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoLong;

public class MCAPConsoleLogOutputPaneController {
    private static final int MAX_UPDATES_PER_FRAME = 10;
    @FXML
    private Pane mainPane;
    @FXML
    private ListView<MCAPConsoleLogManager.MCAPConsoleLogItem> consoleOutputListView;
    private EventHandler<MouseEvent> goToLogEventMouseEventHandler;
    private Consumer<YoBufferPropertiesReadOnly> scrollLastLogItemListener;
    private MCAPLogSession session;
    private final ConcurrentLinkedQueue<MCAPConsoleLogItemListCell> listCellsToUpdate = new ConcurrentLinkedQueue();
    private final ObservedAnimationTimer observedAnimationTimer = new ObservedAnimationTimer(){

        @Override
        public void handleImpl(long now) {
            MCAPConsoleLogItemListCell cell;
            for (int i = 0; i < 10 && (cell = MCAPConsoleLogOutputPaneController.this.listCellsToUpdate.poll()) != null; ++i) {
                cell.updateTextFill();
            }
        }
    };

    public void initialize(SessionVisualizerToolkit toolkit) {
        MenuTools.setupContextMenu(this.consoleOutputListView, new Function[]{mcapConsoleLogItemListView -> {
            MenuItem goToLogItem = new MenuItem("Go to Log Item (Double Click)");
            goToLogItem.setOnAction(event -> {
                MCAPConsoleLogManager.MCAPConsoleLogItem selectedLogItem = (MCAPConsoleLogManager.MCAPConsoleLogItem)mcapConsoleLogItemListView.getSelectionModel().getSelectedItem();
                if (selectedLogItem != null) {
                    MCAPConsoleLogOutputPaneController.gotToLogItem(this.session, selectedLogItem);
                }
            });
            return goToLogItem;
        }, mcapConsoleLogItemListView -> {
            MenuItem copyLogItem = new MenuItem("Copy Log Item (Ctrl+C)");
            copyLogItem.setOnAction(event -> MCAPConsoleLogOutputPaneController.copySelectedLogItemsToClipboard((ListView<MCAPConsoleLogManager.MCAPConsoleLogItem>)mcapConsoleLogItemListView));
            return copyLogItem;
        }});
        this.consoleOutputListView.setOnKeyPressed(event -> {
            if (event.getCode().equals((Object)KeyCode.C) && event.isControlDown()) {
                MCAPConsoleLogOutputPaneController.copySelectedLogItemsToClipboard(this.consoleOutputListView);
                event.consume();
            }
        });
    }

    public void startSession(final MCAPLogSession session) {
        this.session = session;
        MCAPLogFileReader mcapLogFileReader = session.getMCAPLogFileReader();
        this.consoleOutputListView.setCellFactory(param -> new MCAPConsoleLogItemListCell((ListView<MCAPConsoleLogManager.MCAPConsoleLogItem>)param, session, mcapLogFileReader.getCurrentTimestamp()));
        this.consoleOutputListView.getItems().clear();
        SpyList sessionLogItems = mcapLogFileReader.getConsoleLogManager().getAllConsoleLogItems();
        this.consoleOutputListView.getItems().setAll((Collection)sessionLogItems);
        sessionLogItems.addListener(change -> {
            if (change.wasAdded()) {
                int newItemsSize = sessionLogItems.size();
                JavaFXMissingTools.runLater(this.getClass(), () -> {
                    for (int i = this.consoleOutputListView.getItems().size(); i < newItemsSize; ++i) {
                        this.consoleOutputListView.getItems().add((Object)((MCAPConsoleLogManager.MCAPConsoleLogItem)sessionLogItems.get(i)));
                    }
                });
            }
        });
        this.consoleOutputListView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        final MutableLong requestingLogTimestamp = new MutableLong(Long.MIN_VALUE);
        this.goToLogEventMouseEventHandler = event -> {
            if (event.getButton() != MouseButton.PRIMARY) {
                return;
            }
            if (event.getClickCount() != 2) {
                return;
            }
            if (!event.isStillSincePress()) {
                return;
            }
            MCAPConsoleLogManager.MCAPConsoleLogItem selectedLogItem = (MCAPConsoleLogManager.MCAPConsoleLogItem)this.consoleOutputListView.getSelectionModel().getSelectedItem();
            if (selectedLogItem == null) {
                return;
            }
            requestingLogTimestamp.setValue(selectedLogItem.logTime());
            MCAPConsoleLogOutputPaneController.gotToLogItem(session, selectedLogItem);
        };
        this.scrollLastLogItemListener = new Consumer<YoBufferPropertiesReadOnly>(){
            private long lastTimestamp = Long.MIN_VALUE;
            private int lastSearchResult = Integer.MIN_VALUE;

            @Override
            public void accept(YoBufferPropertiesReadOnly bufferProperties) {
                long currentTimestamp = session.getMCAPLogFileReader().getCurrentTimestamp().getValue();
                if (requestingLogTimestamp.getValue() != Long.MIN_VALUE && requestingLogTimestamp.getValue() == currentTimestamp) {
                    requestingLogTimestamp.setValue(Long.MIN_VALUE);
                    this.lastTimestamp = currentTimestamp;
                    return;
                }
                if (currentTimestamp == this.lastTimestamp) {
                    return;
                }
                this.lastTimestamp = currentTimestamp;
                int searchResult = Collections.binarySearch(MCAPConsoleLogOutputPaneController.this.consoleOutputListView.getItems(), new MCAPConsoleLogManager.MCAPConsoleLogItem(currentTimestamp, null, null, null, null, null, 0L), Comparator.comparingLong(MCAPConsoleLogManager.MCAPConsoleLogItem::logTime));
                if (searchResult < 0) {
                    searchResult = -searchResult - 1;
                }
                if (searchResult == this.lastSearchResult) {
                    return;
                }
                this.lastSearchResult = searchResult;
                int finalSearchResult = Math.max(0, searchResult - 2);
                JavaFXMissingTools.runLater(MCAPConsoleLogOutputPaneController.this.getClass(), () -> MCAPConsoleLogOutputPaneController.this.consoleOutputListView.scrollTo(finalSearchResult));
            }
        };
        this.consoleOutputListView.addEventFilter(MouseEvent.MOUSE_CLICKED, this.goToLogEventMouseEventHandler);
        session.addCurrentBufferPropertiesListener(this.scrollLastLogItemListener);
        this.observedAnimationTimer.start();
    }

    private static void gotToLogItem(MCAPLogSession session, MCAPConsoleLogManager.MCAPConsoleLogItem selectedLogItem) {
        int logIndex = session.getMCAPLogFileReader().getIndexFromTimestamp(selectedLogItem.logTime());
        session.submitLogPositionRequest(logIndex);
    }

    private static void copySelectedLogItemsToClipboard(ListView<MCAPConsoleLogManager.MCAPConsoleLogItem> mcapConsoleLogItemListView) {
        ObservableList selectedItems = mcapConsoleLogItemListView.getSelectionModel().getSelectedItems();
        StringBuilder logItemString = new StringBuilder();
        for (MCAPConsoleLogManager.MCAPConsoleLogItem logItem : selectedItems) {
            logItemString.append("[%s] [%s] [%s]: %s\n".formatted(logItem.logLevel(), logItem.instant(), logItem.processName(), logItem.message()));
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.putString(logItemString.toString());
        Clipboard.getSystemClipboard().setContent((Map)clipboardContent);
    }

    public void stopSession() {
        this.consoleOutputListView.getItems().clear();
        if (this.goToLogEventMouseEventHandler != null) {
            this.consoleOutputListView.removeEventFilter(MouseEvent.MOUSE_CLICKED, this.goToLogEventMouseEventHandler);
        }
        this.goToLogEventMouseEventHandler = null;
        if (this.scrollLastLogItemListener != null) {
            this.session.removeCurrentBufferPropertiesListener(this.scrollLastLogItemListener);
        }
        this.scrollLastLogItemListener = null;
        this.observedAnimationTimer.stop();
        this.listCellsToUpdate.clear();
    }

    private class MCAPConsoleLogItemListCell
    extends ListCell<MCAPConsoleLogManager.MCAPConsoleLogItem> {
        private final Color defaultColor = Color.BLACK;
        private final Map<MCAPConsoleLogManager.MCAPLogLevel, Color> logLevelToColorMap = Map.of(MCAPConsoleLogManager.MCAPLogLevel.UNKNOWN, this.defaultColor, MCAPConsoleLogManager.MCAPLogLevel.INFO, Color.CORNFLOWERBLUE, MCAPConsoleLogManager.MCAPLogLevel.WARNING, Color.ORANGE, MCAPConsoleLogManager.MCAPLogLevel.ERROR, Color.RED, MCAPConsoleLogManager.MCAPLogLevel.FATAL, Color.DARKRED);
        private final Color futureColor = Color.GRAY.deriveColor(0.0, 1.0, 1.0, 0.5);
        private final Map<MCAPConsoleLogManager.MCAPLogLevel, String> logLevelToStringMap = Map.of(MCAPConsoleLogManager.MCAPLogLevel.UNKNOWN, "  ???", MCAPConsoleLogManager.MCAPLogLevel.DEBUG, "DEBUG", MCAPConsoleLogManager.MCAPLogLevel.INFO, " INFO", MCAPConsoleLogManager.MCAPLogLevel.WARNING, " WARN", MCAPConsoleLogManager.MCAPLogLevel.ERROR, "ERROR", MCAPConsoleLogManager.MCAPLogLevel.FATAL, "FATAL");
        private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS a z");
        private final ZoneId zoneId = ZoneId.systemDefault();
        private final ListView<MCAPConsoleLogManager.MCAPConsoleLogItem> owner;
        private final YoLong currentTimestamp;
        private YoVariableChangedListener timestampListener;
        private Paint previousTextFill;

        public MCAPConsoleLogItemListCell(ListView<MCAPConsoleLogManager.MCAPConsoleLogItem> owner, MCAPLogSession session, YoLong currentTimestamp) {
            this.owner = owner;
            this.currentTimestamp = currentTimestamp;
        }

        protected void updateItem(MCAPConsoleLogManager.MCAPConsoleLogItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setGraphic(null);
                if (this.timestampListener != null) {
                    this.currentTimestamp.removeListener(this.timestampListener);
                }
                this.timestampListener = null;
            } else {
                this.setFont(Font.font((String)"Monospaced", (double)14.0));
                DoubleBinding cellWidthProperty = this.owner.widthProperty().subtract(15);
                this.minWidthProperty().bind((ObservableValue)cellWidthProperty);
                this.prefWidthProperty().bind((ObservableValue)cellWidthProperty);
                this.maxWidthProperty().bind((ObservableValue)cellWidthProperty);
                this.setWrapText(true);
                this.updateTextFill();
                this.timestampListener = v -> MCAPConsoleLogOutputPaneController.this.listCellsToUpdate.add(this);
                this.currentTimestamp.addListener(this.timestampListener);
                String dateTimeFormatted = this.dateTimeFormatter.format(item.instant().atZone(this.zoneId));
                String logLevelString = this.logLevelToStringMap.get(item.logLevel() == null ? MCAPConsoleLogManager.MCAPLogLevel.UNKNOWN : item.logLevel());
                this.setText("[%s] [%s]\n\t[%s]: %s".formatted(logLevelString, dateTimeFormatted, item.processName(), item.message()));
                this.setGraphic(null);
            }
        }

        private void updateTextFill() {
            MCAPConsoleLogManager.MCAPConsoleLogItem item = (MCAPConsoleLogManager.MCAPConsoleLogItem)this.getItem();
            if (item == null) {
                this.previousTextFill = null;
                return;
            }
            Object newTextFill = item.logTime() > this.currentTimestamp.getValue() ? this.futureColor : (this.logLevelToColorMap.containsKey(item.logLevel()) ? (Paint)this.logLevelToColorMap.get(item.logLevel()) : (Paint)this.logLevelToColorMap.get(MCAPConsoleLogManager.MCAPLogLevel.UNKNOWN));
            if (this.previousTextFill != newTextFill) {
                this.setTextFill((Paint)newTextFill);
                this.previousTextFill = newTextFill;
            }
        }
    }
}

