/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.mcap;

import com.jfoenix.controls.JFXTextField;
import com.jfoenix.controls.JFXTrimSlider;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.control.TitledPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import javafx.util.converter.LongStringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.log.LogTools;
import us.ihmc.messager.TopicListener;
import us.ihmc.messager.TopicListenerBase;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.SessionRobotDefinitionListChange;
import us.ihmc.scs2.session.mcap.MCAPLogCropper;
import us.ihmc.scs2.session.mcap.MCAPLogFileReader;
import us.ihmc.scs2.session.mcap.MCAPLogSession;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.LogSessionManagerController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.mcap.FFMPEGMultiVideoDataReader;
import us.ihmc.scs2.sessionVisualizer.jfx.session.mcap.FFMPEGMultiVideoViewer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.mcap.MCAPConsoleLogOutputPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.PositiveIntegerValueFilter;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class MCAPLogSessionManagerController
implements SessionControlsController {
    private static final double THUMBNAIL_WIDTH = 200.0;
    public static final String LOG_FILE_KEY = "MCAPLogFilePath";
    private static final String ROBOT_MODEL_FILE_KEY = "MCAPRobotModelFilePath";
    private static final String DEFAULT_MODEL_TEXT_FIELD_TEXT = "Path to model file";
    private final ObjectProperty<FFMPEGMultiVideoViewer> multiVideoViewerObjectProperty = new SimpleObjectProperty((Object)this, "multiVideoThumbnailViewer", null);
    private final ObjectProperty<MCAPLogSession> activeSessionProperty = new SimpleObjectProperty((Object)this, "activeSession", null);
    private final LongProperty desiredLogDTProperty = new SimpleLongProperty((Object)this, "desiredLogDT", TimeUnit.MILLISECONDS.toNanos(1L));
    @FXML
    private AnchorPane mainPane;
    @FXML
    private ProgressIndicator loadingSpinner;
    @FXML
    private Button openSessionButton;
    @FXML
    private Button endSessionButton;
    @FXML
    private Label sessionNameLabel;
    @FXML
    private Label dateLabel;
    @FXML
    private Label logPathLabel;
    @FXML
    private Pane cropControlsContainer;
    @FXML
    private ToggleButton showTrimsButton;
    @FXML
    private Button startTrimToCurrentButton;
    @FXML
    private Button endTrimToCurrentButton;
    @FXML
    private Button resetTrimsButton;
    @FXML
    private Button cropAndExportButton;
    @FXML
    private ComboBox<MCAPLogCropper.OutputFormat> outputFormatComboBox;
    @FXML
    private JFXTrimSlider logPositionSlider;
    @FXML
    private Pane cropProgressMonitorPane;
    @FXML
    private JFXTextField currentModelFilePathTextField;
    @FXML
    private TextField desiredLogDTTextField;
    @FXML
    private TextField bufferRecordTickPeriodTextField;
    @FXML
    private TitledPane thumbnailsTitledPane;
    @FXML
    private FlowPane videoThumbnailPane;
    @FXML
    private TitledPane consoleOutputTitledPane;
    @FXML
    private MCAPConsoleLogOutputPaneController consoleOutputPaneController;
    private Stage stage;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;
    private BackgroundExecutorManager backgroundExecutorManager;
    private File defaultRobotModelFile = null;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit) {
        this.stage = new Stage();
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.backgroundExecutorManager = toolkit.getBackgroundExecutorManager();
        this.logPositionSlider.setValueFactory(param -> new LogSessionManagerController.TimeStringBinding(param.valueProperty(), position -> {
            if (this.activeSessionProperty.get() == null) {
                return 0L;
            }
            MCAPLogFileReader mcapLogFileReader = ((MCAPLogSession)this.activeSessionProperty.get()).getMCAPLogFileReader();
            return mcapLogFileReader.getRelativeTimestampAtIndex(position.intValue());
        }));
        TextFormatter recordPeriodFormatter = new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)0, (UnaryOperator)new PositiveIntegerValueFilter());
        this.bufferRecordTickPeriodTextField.setTextFormatter(recordPeriodFormatter);
        this.messager.bindBidirectional(this.topics.getBufferRecordTickPeriod(), (Property)recordPeriodFormatter.valueProperty(), false);
        this.desiredLogDTTextField.setTextFormatter(new TextFormatter((StringConverter)new LongStringConverter(), (Object)1000L, (UnaryOperator)new PositiveIntegerValueFilter()));
        MutableBoolean desiredLogDTTextFieldUpdate = new MutableBoolean(false);
        this.desiredLogDTTextField.textProperty().addListener((o, oldValue, newValue) -> {
            if (desiredLogDTTextFieldUpdate.isTrue()) {
                return;
            }
            desiredLogDTTextFieldUpdate.setTrue();
            try {
                this.desiredLogDTProperty.set(TimeUnit.MICROSECONDS.toNanos(Long.parseLong(newValue)));
            }
            catch (NumberFormatException e) {
                this.desiredLogDTTextField.setText(Long.toString(TimeUnit.NANOSECONDS.toMicros(this.desiredLogDTProperty.get())));
            }
            finally {
                desiredLogDTTextFieldUpdate.setFalse();
            }
        });
        this.desiredLogDTProperty.addListener((o, oldValue, newValue) -> {
            if (desiredLogDTTextFieldUpdate.isTrue()) {
                return;
            }
            desiredLogDTTextFieldUpdate.setTrue();
            this.desiredLogDTTextField.setText(Long.toString(TimeUnit.NANOSECONDS.toMicros(newValue.longValue())));
            desiredLogDTTextFieldUpdate.setFalse();
        });
        ChangeListener activeSessionListener = (o, oldValue, newValue) -> {
            if (newValue == null) {
                this.clearControls();
            } else {
                this.messager.submitMessage(this.topics.getStartNewSessionRequest(), newValue);
                this.initializeControls((MCAPLogSession)newValue);
            }
        };
        AtomicBoolean logPositionUpdate = new AtomicBoolean(true);
        this.logPositionSlider.valueProperty().addListener((o, oldValue, newValue) -> {
            MCAPLogSession logSession = (MCAPLogSession)this.activeSessionProperty.get();
            if (logSession == null || logPositionUpdate.get()) {
                return;
            }
            logSession.submitLogPositionRequest(newValue.intValue());
        });
        AtomicBoolean sliderFeedbackEnabled = new AtomicBoolean(true);
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> sliderFeedbackEnabled.set(false));
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_DRAGGED, e -> sliderFeedbackEnabled.set(false));
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> sliderFeedbackEnabled.set(true));
        Consumer<YoBufferPropertiesReadOnly> logPositionUpdateListener = properties -> {
            MCAPLogSession logSession = (MCAPLogSession)this.activeSessionProperty.get();
            if (sliderFeedbackEnabled.get()) {
                int currentLogPosition = logSession.getMCAPLogFileReader().getCurrentIndex();
                JavaFXMissingTools.runLater(this.getClass(), () -> {
                    if (logSession == null || logSession.getMCAPLogFileReader() == null) {
                        return;
                    }
                    if (currentLogPosition != this.logPositionSlider.valueProperty().intValue()) {
                        logPositionUpdate.set(true);
                        this.logPositionSlider.setValue((double)currentLogPosition);
                        logPositionUpdate.set(false);
                    }
                });
            }
        };
        this.activeSessionProperty.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeCurrentBufferPropertiesListener(logPositionUpdateListener);
            }
            if (newValue != null) {
                newValue.addCurrentBufferPropertiesListener(logPositionUpdateListener);
                if (newValue.getInitialRobotModelFile() != null && this.defaultRobotModelFile == null) {
                    this.currentModelFilePathTextField.setText(newValue.getInitialRobotModelFile().getAbsolutePath());
                } else if (newValue.getInitialRobotModelFile() == null) {
                    this.currentModelFilePathTextField.setText(DEFAULT_MODEL_TEXT_FIELD_TEXT);
                }
            }
        });
        this.multiVideoViewerObjectProperty.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.stop();
            }
            if (newValue != null) {
                newValue.start();
            }
        });
        Session session = toolkit.getSession();
        if (session instanceof MCAPLogSession) {
            MCAPLogSession mcapLogSession = (MCAPLogSession)session;
            this.desiredLogDTProperty.set(mcapLogSession.getDesiredLogDT());
            this.activeSessionProperty.set((Object)mcapLogSession);
            this.initializeControls(mcapLogSession);
        } else {
            this.clearControls();
        }
        this.activeSessionProperty.addListener(activeSessionListener);
        this.thumbnailsTitledPane.expandedProperty().addListener((o, oldValue, newValue) -> JavaFXMissingTools.runLater(this.getClass(), () -> ((Stage)this.stage).sizeToScene()));
        this.consoleOutputTitledPane.expandedProperty().addListener((o, oldValue, newValue) -> JavaFXMissingTools.runLater(this.getClass(), () -> ((Stage)this.stage).sizeToScene()));
        this.logPositionSlider.showTrimProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty());
        this.logPositionSlider.showTrimProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.resetTrims();
            }
        });
        this.startTrimToCurrentButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.endTrimToCurrentButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.resetTrimsButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.outputFormatComboBox.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.cropAndExportButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.cropProgressMonitorPane.getChildren().addListener(c -> {
            c.getList().forEach(node -> JavaFXMissingTools.setAnchorConstraints(node, 0.0));
            this.stage.sizeToScene();
        });
        this.loadingSpinner.visibleProperty().addListener((o, oldValue, newValue) -> this.openSessionButton.setDisable(newValue.booleanValue()));
        this.openSessionButton.setOnAction(e -> this.openLogFile());
        this.endSessionButton.setOnAction(e -> {
            MCAPLogSession logSession = (MCAPLogSession)this.activeSessionProperty.get();
            if (logSession != null) {
                logSession.shutdownSession();
            }
            this.activeSessionProperty.set(null);
        });
        this.messager.addFXTopicListener(this.topics.getDisableUserControls(), m -> {
            this.openSessionButton.setDisable(m.booleanValue());
            this.endSessionButton.setDisable(m.booleanValue());
            this.cropControlsContainer.setDisable(m.booleanValue());
            this.logPositionSlider.setDisable(m.booleanValue());
        });
        this.consoleOutputPaneController.initialize(toolkit);
        this.stage.setScene(new Scene((Parent)this.mainPane));
        this.stage.setTitle("MCAP Log session controls");
        this.stage.getIcons().add((Object)SessionVisualizerIOTools.LOG_SESSION_IMAGE);
        toolkit.getMainWindow().addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.shutdown();
            }
        });
    }

    private void initializeControls(MCAPLogSession session) {
        File logFile = session.getMCAPFile();
        MCAPLogFileReader mcapLogFileReader = session.getMCAPLogFileReader();
        this.sessionNameLabel.setText(session.getSessionName());
        this.dateLabel.setText(LogSessionManagerController.parseTimestamp(logFile.getName()));
        this.logPathLabel.setText(logFile.getAbsolutePath());
        this.endSessionButton.setDisable(false);
        this.logPositionSlider.setDisable(false);
        this.logPositionSlider.setValue(0.0);
        this.logPositionSlider.setMin(0.0);
        this.logPositionSlider.setMax((double)(mcapLogFileReader.getNumberOfEntries() - 1));
        this.cropControlsContainer.setDisable(false);
        FFMPEGMultiVideoDataReader multiReader = new FFMPEGMultiVideoDataReader(logFile.getParentFile(), this.backgroundExecutorManager);
        multiReader.readVideoFrameNow(mcapLogFileReader.getCurrentRelativeTimestamp());
        mcapLogFileReader.getCurrentTimestamp().addListener(v -> multiReader.readVideoFrameInBackground(mcapLogFileReader.getCurrentRelativeTimestamp()));
        this.multiVideoViewerObjectProperty.set((Object)new FFMPEGMultiVideoViewer((Window)this.stage, (Pane)this.videoThumbnailPane, multiReader, 200.0));
        boolean logHasVideos = multiReader.getNumberOfVideos() > 0;
        this.thumbnailsTitledPane.setText(logHasVideos ? "Logged videos" : "No video");
        this.thumbnailsTitledPane.setExpanded(logHasVideos);
        this.thumbnailsTitledPane.setDisable(!logHasVideos);
        this.consoleOutputPaneController.startSession(session);
        JavaFXMissingTools.runNFramesLater(5, () -> this.stage.sizeToScene());
        JavaFXMissingTools.runNFramesLater(6, () -> this.stage.toFront());
    }

    private void clearControls() {
        this.sessionNameLabel.setText("N/D");
        this.dateLabel.setText("N/D");
        this.logPathLabel.setText("N/D");
        this.endSessionButton.setDisable(true);
        this.logPositionSlider.setDisable(true);
        this.showTrimsButton.setSelected(false);
        this.cropControlsContainer.setDisable(true);
        this.multiVideoViewerObjectProperty.set(null);
        this.consoleOutputPaneController.stopSession();
    }

    public void openLogFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath(LOG_FILE_KEY));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("MCAP Log file", new String[]{"*.mcap"}));
        fileChooser.setTitle("Choose MCAP log file");
        File result = fileChooser.showOpenDialog((Window)this.stage);
        if (result == null) {
            return;
        }
        this.unloadSession();
        this.setIsLoading(true);
        this.backgroundExecutorManager.executeInBackground(() -> {
            try {
                LogTools.info((String)"Creating log session.");
                MCAPLogSession newSession = new MCAPLogSession(result, this.desiredLogDTProperty.get(), this.defaultRobotModelFile);
                LogTools.info((String)"Created log session.");
                JavaFXMissingTools.runLater(this.getClass(), () -> this.activeSessionProperty.set((Object)newSession));
                SessionVisualizerIOTools.setDefaultFilePath(LOG_FILE_KEY, result);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.setIsLoading(false);
            }
        });
    }

    public void setIsLoading(boolean isLoading) {
        this.loadingSpinner.setVisible(isLoading);
    }

    @FXML
    public void resetTrims() {
        this.logPositionSlider.setTrimStartValue(0.0);
        this.logPositionSlider.setTrimEndValue(this.logPositionSlider.getMax());
    }

    @FXML
    public void snapStartTrimToCurrent() {
        this.logPositionSlider.setTrimStartValue(this.logPositionSlider.getValue());
    }

    @FXML
    public void snapEndTrimToCurrent() {
        this.logPositionSlider.setTrimEndValue(this.logPositionSlider.getValue());
    }

    @FXML
    public void cropAndExport() throws IOException {
        MCAPLogFileReader mcapLogFileReader = ((MCAPLogSession)this.activeSessionProperty.get()).getMCAPLogFileReader();
        MCAPLogCropper cropper = new MCAPLogCropper(mcapLogFileReader.getMCAP());
        long startTimestamp = mcapLogFileReader.getTimestampAtIndex((int)this.logPositionSlider.getTrimStartValue());
        long endTimestamp = mcapLogFileReader.getTimestampAtIndex((int)this.logPositionSlider.getTrimEndValue());
        cropper.setStartTimestamp(startTimestamp);
        cropper.setEndTimestamp(endTimestamp);
        cropper.setOutputFormat((MCAPLogCropper.OutputFormat)this.outputFormatComboBox.getValue());
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath(LOG_FILE_KEY));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("MCAP Log file", new String[]{"*.mcap"}));
        fileChooser.setTitle("Choose MCAP log file");
        File result = fileChooser.showSaveDialog((Window)this.stage);
        if (result == null) {
            return;
        }
        this.backgroundExecutorManager.executeInBackground(() -> {
            this.setIsLoading(true);
            this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)true);
            try (FileOutputStream os = new FileOutputStream(result);){
                cropper.crop(os);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)false);
                this.setIsLoading(false);
            }
        });
    }

    @Override
    public void notifySessionLoaded() {
        this.setIsLoading(false);
    }

    @Override
    public void unloadSession() {
    }

    @Override
    public void shutdown() {
        this.stage.close();
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }

    @FXML
    public void requestLoadRobotModelFile(ActionEvent actionEvent) {
        File result = SessionVisualizerIOTools.showOpenDialog((Window)this.stage, "Choose robot model file", new FileChooser.ExtensionFilter("Robot model file", new String[]{"*.urdf", "*.sdf"}), ROBOT_MODEL_FILE_KEY);
        if (result == null) {
            return;
        }
        this.backgroundExecutorManager.executeInBackground(() -> this.submitRobotDefinitionRequest(result));
    }

    private void submitRobotDefinitionRequest(final File result) {
        MCAPLogSession logSession = (MCAPLogSession)this.activeSessionProperty.get();
        if (logSession == null) {
            this.defaultRobotModelFile = result;
            this.currentModelFilePathTextField.setText(result.getAbsolutePath());
            return;
        }
        boolean hasARobot = !logSession.getRobotDefinitions().isEmpty();
        SessionRobotDefinitionListChange request = hasARobot ? SessionRobotDefinitionListChange.replace((File)result, (RobotDefinition)((RobotDefinition)logSession.getRobotDefinitions().get(0))) : SessionRobotDefinitionListChange.add((File)result);
        this.messager.submitMessage(this.topics.getSessionRobotDefinitionListChangeRequest(), (Object)request);
        this.currentModelFilePathTextField.setText("Loading...");
        TopicListener<SessionRobotDefinitionListChange> listener = new TopicListener<SessionRobotDefinitionListChange>(){

            public void receivedMessageForTopic(SessionRobotDefinitionListChange m) {
                if (m.getAddedRobotDefinition() != null) {
                    MCAPLogSessionManagerController.this.currentModelFilePathTextField.setText(result.getAbsolutePath());
                    MCAPLogSessionManagerController.this.defaultRobotModelFile = result;
                } else {
                    MCAPLogSessionManagerController.this.currentModelFilePathTextField.setText("Failed to load.");
                    MCAPLogSessionManagerController.this.defaultRobotModelFile = null;
                }
                MCAPLogSessionManagerController.this.messager.removeFXTopicListener(MCAPLogSessionManagerController.this.topics.getSessionRobotDefinitionListChangeState(), (TopicListenerBase)this);
            }
        };
        this.messager.addFXTopicListener(this.topics.getSessionRobotDefinitionListChangeState(), (TopicListener)listener);
    }
}

