/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.mcap;

import java.io.File;
import java.util.concurrent.atomic.AtomicLong;
import org.bytedeco.javacv.FFmpegFrameGrabber;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameGrabber;

public class FFMPEGVideoDataReader {
    private final File videoFile;
    private final FFmpegFrameGrabber frameGrabber;
    private Frame currentFrame = null;
    private final long maxVideoTimestamp;
    private final AtomicLong playbackOffset = new AtomicLong(0L);
    private final AtomicLong currentTimestamp = new AtomicLong(0L);

    public FFMPEGVideoDataReader(File file) {
        this.videoFile = file;
        this.frameGrabber = new FFmpegFrameGrabber(file);
        try {
            this.frameGrabber.start();
            this.currentFrame = this.frameGrabber.grabFrame();
        }
        catch (FrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
        this.maxVideoTimestamp = this.frameGrabber.getLengthInTime() * 1000L;
    }

    public Frame getCurrentFrame() {
        return this.currentFrame;
    }

    public void readFrameAtTimestamp(long timestamp) {
        long clampedTime;
        if (this.currentTimestamp.get() != timestamp) {
            this.currentTimestamp.set(Math.min(this.maxVideoTimestamp, Math.max(0L, timestamp)));
        }
        if ((clampedTime = Math.min(this.maxVideoTimestamp, Math.max(0L, this.currentTimestamp.get() + this.playbackOffset.get()))) != this.frameGrabber.getTimestamp()) {
            try {
                this.frameGrabber.setVideoTimestamp(this.convertNanosecondToVideoTimestamp(clampedTime));
                this.currentFrame = this.frameGrabber.grabFrame();
            }
            catch (FrameGrabber.Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void readCurrentFrame() {
        this.readFrameAtTimestamp(this.currentTimestamp.get());
    }

    public long getVideoLengthInSeconds() {
        return this.maxVideoTimestamp / 1000000000L;
    }

    public void setPlaybackOffset(long offset) {
        this.playbackOffset.set(offset);
    }

    public long getPlaybackOffset() {
        return this.playbackOffset.get();
    }

    public long getCurrentTimestamp() {
        return this.currentTimestamp.get();
    }

    public void shutdown() {
        try {
            this.frameGrabber.stop();
            this.frameGrabber.release();
        }
        catch (FFmpegFrameGrabber.Exception e) {
            throw new RuntimeException(e);
        }
    }

    private long convertNanosecondToVideoTimestamp(long nanosecondTimestamp) {
        return nanosecondTimestamp / 1000L;
    }
}

