/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.prefs.Preferences;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.image.Image;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.apache.commons.lang3.SystemUtils;
import us.ihmc.commons.nio.FileTools;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.session.SessionIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;

public class SessionVisualizerIOTools {
    private static final ClassLoader classLoader = SessionVisualizerIOTools.class.getClassLoader();
    public static final Path SCS2_HOME = SessionIOTools.SCS2_HOME;
    public static final Path SCS2_CONFIGURATION_DEFAULT_PATH = SCS2_HOME.resolve("Configurations");
    public static final String scsConfigurationFileExtension = ".scs2";
    public static final String scsMainConfigurationFileExtension = ".scs2.main";
    public static final String yoChartGroupConfigurationFileExtension = ".scs2.chart";
    public static final String yoGraphicConfigurationFileExtension = ".scs2.yoGraphic";
    public static final String yoCompositeConfigurationFileExtension = ".scs2.yoComposite";
    public static final String yoEntryConfigurationFileExtension = ".scs2.yoEntry";
    public static final String yoSliderboardConfigurationFileExtension = ".scs2.yoSliderboard";
    public static final String yoVariableGroupConfigurationFileExtension = ".scs2.yoVariableGroup";
    public static final String yoEquationFileExtension = ".scs2.yoEquation";
    public static final String videoFileExtension = ".mp4";
    public static final FileChooser.ExtensionFilter scs2InfoFilter;
    public static final FileChooser.ExtensionFilter scs2ConfigurationFilter;
    public static final FileChooser.ExtensionFilter yoChartGroupConfigurationFilter;
    public static final FileChooser.ExtensionFilter yoGraphicConfigurationFilter;
    public static final FileChooser.ExtensionFilter yoCompositeConfigurationFilter;
    public static final FileChooser.ExtensionFilter yoEntryConfigurationFilter;
    public static final FileChooser.ExtensionFilter yoSliderboardConfigurationFilter;
    public static final FileChooser.ExtensionFilter yoVariableGroupConfigurationFilter;
    public static final FileChooser.ExtensionFilter yoEquationFilter;
    public static final FileChooser.ExtensionFilter videoExtensionFilter;
    private static final String CSS_FOLDER = "css/";
    private static final String FXML_FOLDER = "fxml/";
    private static final String ICONS_FOLDER = "icons/";
    private static final String IMAGES_FOLDER = "images/";
    private static final String SKYBOX_FOLDER = "skybox/";
    private static final String CONFIGURATION_FOLDER = "configuration/";
    private static final String YO_GRAPHIC_FOLDER = "yoGraphic/";
    private static final String SESSION_FOLDER = "session/";
    public static final URL GENERAL_STYLESHEET;
    public static final Image SCS_ICON_IMAGE;
    public static final Image INVALID_ICON_IMAGE;
    public static final Image VALID_ICON_IMAGE;
    public static final Image REMOTE_SESSION_IMAGE;
    public static final Image LOG_SESSION_IMAGE;
    private static final String CHART = "chart/";
    private static final String YO_COMPOSITE = "yoComposite/";
    private static final String YO_COMPOSITE_CREATOR = "yoComposite/creator/";
    private static final String YO_COMPOSITE_PATTERN = "yoComposite/pattern/";
    private static final String YO_COMPOSITE_SEARCH = "yoComposite/search/";
    private static final String YO_COMPOSITE_ENTRY = "yoComposite/entry/";
    private static final String YO_GRAPHIC = "yoGraphic/";
    private static final String YO_GRAPHIC_2D = "yoGraphic/graphic2D/";
    private static final String YO_GRAPHIC_3D = "yoGraphic/graphic3D/";
    private static final String YO_GRAPHIC_GROUP = "yoGraphic/group/";
    private static final String YO_EDITOR = "editor/";
    private static final String YO_SLIDERBOARD = "yoSliderboard/";
    private static final String YO_SLIDERBOARD_BCF2000 = "yoSliderboard/bcf2000/";
    private static final String YO_SLIDERBOARD_XTOUCHCOMPACT = "yoSliderboard/xtouchcompact/";
    public static final String DEFAULT_YO_COMPOSITE_PATTERNS_FILE = "DefaultYoCompositePatterns.scs2.yoComposite";
    public static final URL YO_COMPOSITE_PATTERN_EDITOR_PANE_URL;
    public static final URL YO_COMPOSITE_PATTERN_PROPERTY_WINDOW_URL;
    public static final URL YO_COMPOSITE_AND_EQUATION_EDITOR_WINDOW_URL;
    public static final URL YO_COMPOSITE_CREATOR_DIALOG_URL;
    public static final URL YO_EQUATION_EDITOR_PANE_URL;
    public static final URL YO_EQUATION_EDITOR_HELP_PANE_URL;
    public static final URL YO_COMPOSITE_SEARCH_PANEL_URL;
    public static final URL YO_SEARCH_TAB_PANE_URL;
    public static final URL YO_ENTRY_LIST_VIEW_URL;
    public static final URL YO_REGISTRY_STATISTICS_URL;
    public static final URL GRAPHIC_2D_CROSS_URL;
    public static final URL GRAPHIC_2D_PLUS_URL;
    public static final URL GRAPHIC_2D_CIRCLE_URL;
    public static final URL GRAPHIC_2D_CIRCLE_CROSS_URL;
    public static final URL GRAPHIC_2D_CIRCLE_PLUS_URL;
    public static final URL GRAPHIC_2D_DIAMOND_URL;
    public static final URL GRAPHIC_2D_DIAMOND_PLUS_URL;
    public static final URL GRAPHIC_2D_SQUARE_URL;
    public static final URL GRAPHIC_2D_SQUARE_CROSS_URL;
    public static final Path GRAPHIC_2D_CUSTOM_GRAPHICS;
    public static final URL GRAPHIC_3D_SPHERE_URL;
    public static final URL GRAPHIC_3D_CUBE_URL;
    public static final URL GRAPHIC_3D_TETRAHEDRON_URL;
    public static final URL GRAPHIC_3D_ICOSAHEDRON_URL;
    public static final Path GRAPHIC_3D_CUSTOM_GRAPHICS;
    public static final URL YO_SLIDERBOARD_BCF2000_WINDOW_URL;
    public static final URL YO_SLIDERBOARD_XTOUCHCOMPACT_WINDOW_URL;
    public static final URL YO_MULTI_SLIDERBOARD_WINDOW_URL;
    public static final URL MAIN_WINDOW_URL;
    public static final URL SECONDARY_WINDOW_URL;
    public static final URL SIDE_PANE_URL;
    public static final URL USER_SIDE_PANE_URL;
    public static final URL ABOUT_WINDOW_URL;
    public static final URL VIDEO_PREVIEW_PANE_URL;
    public static final URL SESSION_DATA_EXPORT_STAGE_URL;
    public static final URL SESSION_VARIABLE_FILTER_PANE_URL;
    public static final URL PLOTTER2D_OPTIONS_STAGE_URL;
    public static final URL CAMERA3D_OPTIONS_PANE_URL;
    public static final URL CHART_PANEL_FXML_URL;
    public static final URL CHART_GROUP_PANEL_URL;
    public static final URL CHART_GROUP_MODEL_EDITOR_PANE_URL;
    public static final URL CHART_IDENTIFIER_EDITOR_PANE_URL;
    public static final URL CHART_OPTION_DIALOG_URL;
    public static final URL CHART_VARIABLE_OPTION_PANE_URL;
    public static final URL CHART_BASELINE_EDITOR_PANE_URL;
    public static final URL YO_GRAPHIC_ITEM_CREATOR_URL;
    public static final URL YO_GRAPHIC_PROPERTY_URL;
    public static final URL YO_COMPOSITE_EDITOR_URL;
    public static final URL SIMPLE_COLOR_EDITOR_PANE_URL;
    public static final URL YO_COLOR_RGBA_EDITOR_PANE_URL;
    public static final URL YO_COLOR_RGBA_SINGLE_EDITOR_PANE_URL;
    public static final URL YO_GRAPHIC_ROBOT_COLLISIONS_BUTTON_URL;
    public static final URL YO_GRAPHIC_TERRAIN_COLLISIONS_BUTTON_URL;
    public static final URL YO_GRAPHIC_ROBOT_MASS_PROPERTIES_BUTTON_URL;
    public static final URL REMOTE_SESSION_MANAGER_PANE_FXML_URL;
    public static final URL REMOTE_SESSION_INFO_PANE_FXML_URL;
    public static final URL LOG_SESSION_MANAGER_PANE_FXML_URL;
    public static final URL LOG_CROP_PROGRESS_PANE_FXML_URL;
    public static final URL MCAP_LOG_SESSION_MANAGER_PANE_FXML_URL;
    public static final String SKYBOX_CLOUDY_FOLDER = "cloudy/";
    public static final Image SKYBOX_TOP_IMAGE;
    public static final Image SKYBOX_BOTTOM_IMAGE;
    public static final Image SKYBOX_LEFT_IMAGE;
    public static final Image SKYBOX_RIGHT_IMAGE;
    public static final Image SKYBOX_FRONT_IMAGE;
    public static final Image SKYBOX_BACK_IMAGE;
    public static final String SKYBOX_SCS1_FOLDER = "brightSky/";
    public static final Image SCS1_SKYBOX_TOP_IMAGE;
    public static final Image SCS1_SKYBOX_BOTTOM_IMAGE;
    public static final Image SCS1_SKYBOX_LEFT_IMAGE;
    public static final Image SCS1_SKYBOX_RIGHT_IMAGE;
    public static final Image SCS1_SKYBOX_FRONT_IMAGE;
    public static final Image SCS1_SKYBOX_BACK_IMAGE;
    private static Stage phantomStage;

    public static void addSCSIconToDialog(Dialog<?> dialog) {
        SessionVisualizerIOTools.addSCSIconToWindow(dialog.getDialogPane().getScene().getWindow());
    }

    public static void addSCSIconToWindow(Window window) {
        if (window instanceof Stage) {
            ((Stage)window).getIcons().add((Object)SCS_ICON_IMAGE);
        }
    }

    public static URL getCSSResource(String filename) {
        return classLoader.getResource(CSS_FOLDER + filename + ".css");
    }

    public static URL getFXMLResource(String filename) {
        return classLoader.getResource(FXML_FOLDER + filename + ".fxml");
    }

    public static URL getFXMLResource(String location, String filename) {
        return classLoader.getResource(FXML_FOLDER + location + filename + ".fxml");
    }

    public static InputStream getYoGraphicFXIconResource(Class<? extends YoGraphicFXItem> yoGraphicFXType) {
        if (yoGraphicFXType == null) {
            return null;
        }
        return SessionVisualizerIOTools.getIconResource("yoGraphic/" + yoGraphicFXType.getSimpleName() + ".png");
    }

    public static FXMLLoader getYoGraphicFXEditorFXMLLoader(Class<? extends YoGraphicFXItem> yoGraphicFXType) {
        String location = null;
        if (YoGraphicFX2D.class.isAssignableFrom(yoGraphicFXType)) {
            location = YO_GRAPHIC_2D;
        } else if (YoGraphicFX3D.class.isAssignableFrom(yoGraphicFXType)) {
            location = YO_GRAPHIC_3D;
        } else {
            throw new IllegalArgumentException("Unhandled graphic type: " + yoGraphicFXType.getSimpleName());
        }
        URL fxmlResource = SessionVisualizerIOTools.getFXMLResource(location, yoGraphicFXType.getSimpleName() + "EditorPane");
        Objects.requireNonNull(fxmlResource, "Could not find FXML resource for " + yoGraphicFXType.getSimpleName());
        return new FXMLLoader(fxmlResource);
    }

    public static FXMLLoader getYoGraphicFXGroupEditorFXMLLoader(Class<? extends YoGraphicFXItem> yoGraphicFXType) {
        String location = null;
        if (YoGraphicFX2D.class.isAssignableFrom(yoGraphicFXType)) {
            location = "yoGraphic/group/graphic2D/";
        } else if (YoGraphicFX3D.class.isAssignableFrom(yoGraphicFXType)) {
            location = "yoGraphic/group/graphic3D/";
        } else {
            throw new IllegalArgumentException("Unhandled graphic type: " + yoGraphicFXType.getSimpleName());
        }
        URL fxmlResource = SessionVisualizerIOTools.getFXMLResource(location, yoGraphicFXType.getSimpleName() + "GroupEditorPane");
        Objects.requireNonNull(fxmlResource, "Could not find FXML resource for grouped " + yoGraphicFXType.getSimpleName());
        return new FXMLLoader(fxmlResource);
    }

    public static InputStream getIconResource(String iconNameWithExtension) {
        return classLoader.getResourceAsStream(ICONS_FOLDER + iconNameWithExtension);
    }

    public static InputStream getImageResource(String imageNameWithExtension) {
        return classLoader.getResourceAsStream(IMAGES_FOLDER + imageNameWithExtension);
    }

    public static InputStream getSkyboxResource(String skyboxNameWithExtension) {
        return classLoader.getResourceAsStream(SKYBOX_FOLDER + skyboxNameWithExtension);
    }

    public static InputStream getConfigurationResource(String filenameWithExtension) {
        return classLoader.getResourceAsStream(CONFIGURATION_FOLDER + filenameWithExtension);
    }

    public static URL getYoGraphicResource(String filenameWithExtension) {
        return classLoader.getResource("yoGraphic/" + filenameWithExtension);
    }

    public static URL getYoGraphicResource(String location, String filenameWithExtension) {
        return classLoader.getResource("yoGraphic/" + location + filenameWithExtension);
    }

    public static Image loadIcon(String iconNameWithExtension) {
        return SessionVisualizerIOTools.createImage(iconNameWithExtension, () -> SessionVisualizerIOTools.getIconResource(iconNameWithExtension));
    }

    public static Image loadImage(String imageNameWithExtension) {
        return SessionVisualizerIOTools.createImage(imageNameWithExtension, () -> SessionVisualizerIOTools.getImageResource(imageNameWithExtension));
    }

    public static Image loadSkyboxImage(String skyboxImageNameWithExtension) {
        return SessionVisualizerIOTools.createImage(skyboxImageNameWithExtension, () -> SessionVisualizerIOTools.getSkyboxResource(skyboxImageNameWithExtension));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image createImage(String name, Supplier<InputStream> isSupplier) {
        int i = 0;
        while (i < 3) {
            try (InputStream is = isSupplier.get();){
                Image image2 = new Image(is);
                if (image2.getWidth() != 0.0) {
                    Image image = image2;
                    return image;
                }
                LogTools.error((String)"Failed to load image {}, retrying.", (Object)name);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return null;
    }

    public static File scs2ConfigurationOpenFileDialog(Window owner) {
        return SessionVisualizerIOTools.showOpenDialog(owner, "Load SCS2 Configuration", scs2ConfigurationFilter);
    }

    public static File scs2ConfigurationSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save SCS2 Configuration", scs2ConfigurationFilter);
    }

    public static File yoChartConfigurationOpenFileDialog(Window owner) {
        return SessionVisualizerIOTools.showOpenDialog(owner, "Load YoChartGroup", yoChartGroupConfigurationFilter);
    }

    public static File yoChartConfigurationSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save YoChartGroup", yoChartGroupConfigurationFilter);
    }

    public static File yoGraphicConfigurationOpenFileDialog(Window owner) {
        return SessionVisualizerIOTools.showOpenDialog(owner, "Load YoGraphic", yoGraphicConfigurationFilter);
    }

    public static File yoGraphicConfigurationSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save YoGraphic", yoGraphicConfigurationFilter);
    }

    public static File yoCompositeConfigurationOpenFileDialog(Window owner) {
        return SessionVisualizerIOTools.showOpenDialog(owner, "Load YoComposite", yoCompositeConfigurationFilter);
    }

    public static File yoCompositeConfigurationSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save YoComposite", yoCompositeConfigurationFilter);
    }

    public static File yoEntryConfigurationOpenFileDialog(Window owner) {
        return SessionVisualizerIOTools.showOpenDialog(owner, "Load YoEntry", yoEntryConfigurationFilter);
    }

    public static File yoEntryConfigurationSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save YoEntry", yoEntryConfigurationFilter);
    }

    public static File yoSliderboardConfigurationOpenFileDialog(Window owner) {
        return SessionVisualizerIOTools.showOpenDialog(owner, "Load YoSliderboard", yoSliderboardConfigurationFilter);
    }

    public static File yoSliderboardConfigurationSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save YoSliderboard", yoSliderboardConfigurationFilter);
    }

    public static File yoVariableGroupConfigurationOpenFileDialog(Window owner) {
        return SessionVisualizerIOTools.showOpenDialog(owner, "Load YoVariable Group", yoVariableGroupConfigurationFilter);
    }

    public static File yoVariableGroupConfigurationSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save YoVariable Group", yoVariableGroupConfigurationFilter);
    }

    public static File yoEquationOpenFileDialog(Window owner) {
        return SessionVisualizerIOTools.showOpenDialog(owner, "Load YoEquation", yoEquationFilter);
    }

    public static File yoEquationSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save YoEquation", yoEquationFilter);
    }

    public static File videoExportSaveFileDialog(Window owner) {
        return SessionVisualizerIOTools.showSaveDialog(owner, "Save Video", videoExtensionFilter, "video");
    }

    public static File showSaveDialog(Window owner, String title, FileChooser.ExtensionFilter extensionFilter) {
        return SessionVisualizerIOTools.showSaveDialog(owner, title, extensionFilter, "filePath");
    }

    public static File showSaveDialog(Window owner, String title, FileChooser.ExtensionFilter extensionFilter, String pathKey) {
        File result;
        boolean usePhantomStage;
        List extensions = extensionFilter != null ? extensionFilter.getExtensions() : Collections.emptyList();
        boolean hasExtension = !extensions.isEmpty();
        FileChooser fileChooser = SessionVisualizerIOTools.fileChooser(title, extensionFilter, pathKey);
        if (hasExtension && !SystemUtils.IS_OS_WINDOWS) {
            fileChooser.setInitialFileName((String)extensions.get(0));
        }
        boolean bl = usePhantomStage = owner == null;
        if (usePhantomStage) {
            owner = SessionVisualizerIOTools.getPhantomStage();
        }
        if ((result = fileChooser.showSaveDialog(owner)) == null) {
            return null;
        }
        if (hasExtension) {
            String filename = result.getName();
            boolean containsExtension = false;
            for (int i = 0; i < extensions.size(); ++i) {
                int firstIndexOfExtension;
                String extension = (String)extensions.get(i);
                if (extension.charAt(0) == '*') {
                    extension = extension.substring(1);
                }
                if ((firstIndexOfExtension = filename.indexOf(extension)) == -1) continue;
                containsExtension = true;
                if (firstIndexOfExtension == filename.length() - extension.length()) break;
                String newFilename = filename.substring(0, firstIndexOfExtension) + extension;
                result = new File(result.getParentFile(), newFilename);
                break;
            }
            if (!containsExtension) {
                String newFilename = filename + ((String)extensions.get(0)).replace("*", "");
                if ((result = new File(result.getParentFile(), newFilename)).exists()) {
                    Alert alert = new Alert(Alert.AlertType.WARNING, result.getName() + " already exists.\nDo you want to replace it?", new ButtonType[]{ButtonType.YES, ButtonType.NO});
                    alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                    alert.initOwner(owner);
                    alert.setTitle("Confirm Save As");
                    JavaFXMissingTools.centerDialogInOwner(alert);
                    Optional confirmation = alert.showAndWait();
                    if (!confirmation.isPresent() || confirmation.get() == ButtonType.NO) {
                        return null;
                    }
                }
            }
        }
        SessionVisualizerIOTools.setDefaultFilePath(pathKey, result);
        return result;
    }

    public static File showOpenDialog(Window owner, String title, FileChooser.ExtensionFilter extensionFilter) {
        return SessionVisualizerIOTools.showOpenDialog(owner, title, extensionFilter, "filePath");
    }

    public static File showOpenDialog(Window owner, String title, FileChooser.ExtensionFilter extensionFilter, String pathKey) {
        File result;
        boolean usePhantomStage;
        FileChooser fileChooser = SessionVisualizerIOTools.fileChooser(title, extensionFilter, pathKey);
        boolean bl = usePhantomStage = owner == null;
        if (usePhantomStage) {
            owner = SessionVisualizerIOTools.getPhantomStage();
            SessionVisualizerIOTools.getPhantomStage().show();
        }
        if ((result = fileChooser.showOpenDialog(owner)) != null) {
            SessionVisualizerIOTools.setDefaultFilePath(pathKey, result);
        }
        return result;
    }

    private static Stage getPhantomStage() {
        if (phantomStage == null) {
            Stage stage = new Stage();
            SessionVisualizerIOTools.addSCSIconToWindow((Window)stage);
            stage.initStyle(StageStyle.UNDECORATED);
            stage.setX(stage.getX() - 0.5 * stage.getWidth());
            stage.setY(stage.getY() - 0.5 * stage.getHeight());
            stage.setWidth(0.0);
            stage.setHeight(0.0);
            stage.show();
            phantomStage = stage;
        }
        return phantomStage;
    }

    private static FileChooser fileChooser(String title, FileChooser.ExtensionFilter extensionFilter, String pathKey) {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(title);
        fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath(pathKey));
        fileChooser.getExtensionFilters().add((Object)extensionFilter);
        return fileChooser;
    }

    public static File getDefaultFilePath() {
        return SessionVisualizerIOTools.getDefaultFilePath("filePath");
    }

    public static File getDefaultFilePath(String key) {
        Preferences prefs;
        String filePath;
        if (key == null) {
            key = "filePath";
        }
        if ((filePath = (prefs = Preferences.userNodeForPackage(SessionVisualizerIOTools.class)).get(key, null)) != null && Files.isDirectory(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            return new File(filePath);
        }
        return null;
    }

    public static void setDefaultFilePath(File file) {
        SessionVisualizerIOTools.setDefaultFilePath("filePath", file);
    }

    public static void setDefaultFilePath(String key, File file) {
        Preferences prefs = Preferences.userNodeForPackage(SessionVisualizerIOTools.class);
        if (file != null) {
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            prefs.put(key, file.getAbsolutePath());
        }
    }

    public static boolean openWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean openWebpage(URL url) {
        try {
            return SessionVisualizerIOTools.openWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
    }

    static {
        try {
            FileTools.ensureDirectoryExists((Path)SCS2_CONFIGURATION_DEFAULT_PATH);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        scs2InfoFilter = new FileChooser.ExtensionFilter("SCS2 Info File", new String[]{"*.scs2.info"});
        scs2ConfigurationFilter = new FileChooser.ExtensionFilter("SCS2 Config File", new String[]{"*.scs2"});
        yoChartGroupConfigurationFilter = new FileChooser.ExtensionFilter("SCS2 YoChartGroup File", new String[]{"*.scs2.chart"});
        yoGraphicConfigurationFilter = new FileChooser.ExtensionFilter("SCS2 YoGraphic File", new String[]{"*.scs2.yoGraphic"});
        yoCompositeConfigurationFilter = new FileChooser.ExtensionFilter("SCS2 YoComposite File", new String[]{"*.scs2.yoComposite"});
        yoEntryConfigurationFilter = new FileChooser.ExtensionFilter("SCS2 YoEntry File", new String[]{"*.scs2.yoEntry"});
        yoSliderboardConfigurationFilter = new FileChooser.ExtensionFilter("SCS2 YoSliderboard File", new String[]{"*.scs2.yoSliderboard"});
        yoVariableGroupConfigurationFilter = new FileChooser.ExtensionFilter("SCS2 YoVariable Group File", new String[]{"*.scs2.yoVariableGroup"});
        yoEquationFilter = new FileChooser.ExtensionFilter("SCS2 YoEquation File", new String[]{"*.scs2.yoEquation"});
        videoExtensionFilter = new FileChooser.ExtensionFilter("MP4", new String[]{"*.mp4"});
        GENERAL_STYLESHEET = SessionVisualizerIOTools.getCSSResource("GeneralStylesheet");
        SCS_ICON_IMAGE = SessionVisualizerIOTools.loadIcon("scs-icon.png");
        INVALID_ICON_IMAGE = SessionVisualizerIOTools.loadIcon("invalid-icon.png");
        VALID_ICON_IMAGE = SessionVisualizerIOTools.loadIcon("valid-icon.png");
        REMOTE_SESSION_IMAGE = SessionVisualizerIOTools.loadIcon("viz-icon.png");
        LOG_SESSION_IMAGE = SessionVisualizerIOTools.loadIcon("log-icon.png");
        YO_COMPOSITE_PATTERN_EDITOR_PANE_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_PATTERN, "YoCompositePatternEditorPane");
        YO_COMPOSITE_PATTERN_PROPERTY_WINDOW_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_PATTERN, "YoCompositePatternPropertyWindow");
        YO_COMPOSITE_AND_EQUATION_EDITOR_WINDOW_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_CREATOR, "YoCompositeAndEquationEditorWindow");
        YO_COMPOSITE_CREATOR_DIALOG_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_CREATOR, "YoCompositeCreatorDialog");
        YO_EQUATION_EDITOR_PANE_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_CREATOR, "YoEquationEditorPane");
        YO_EQUATION_EDITOR_HELP_PANE_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_CREATOR, "YoEquationEditorHelpPane");
        YO_COMPOSITE_SEARCH_PANEL_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_SEARCH, "YoCompositeSearchPane");
        YO_SEARCH_TAB_PANE_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_SEARCH, "YoSearchTabPane");
        YO_ENTRY_LIST_VIEW_URL = SessionVisualizerIOTools.getFXMLResource(YO_COMPOSITE_ENTRY, "YoEntryListView");
        YO_REGISTRY_STATISTICS_URL = SessionVisualizerIOTools.getFXMLResource("YoRegistryStatisticsPane");
        GRAPHIC_2D_CROSS_URL = SessionVisualizerIOTools.getYoGraphicResource("cross.svg");
        GRAPHIC_2D_PLUS_URL = SessionVisualizerIOTools.getYoGraphicResource("plus.svg");
        GRAPHIC_2D_CIRCLE_URL = SessionVisualizerIOTools.getYoGraphicResource("circle.svg");
        GRAPHIC_2D_CIRCLE_CROSS_URL = SessionVisualizerIOTools.getYoGraphicResource("circle_cross.svg");
        GRAPHIC_2D_CIRCLE_PLUS_URL = SessionVisualizerIOTools.getYoGraphicResource("circle_plus.svg");
        GRAPHIC_2D_DIAMOND_URL = SessionVisualizerIOTools.getYoGraphicResource("diamond.svg");
        GRAPHIC_2D_DIAMOND_PLUS_URL = SessionVisualizerIOTools.getYoGraphicResource("diamond_plus.svg");
        GRAPHIC_2D_SQUARE_URL = SessionVisualizerIOTools.getYoGraphicResource("square.svg");
        GRAPHIC_2D_SQUARE_CROSS_URL = SessionVisualizerIOTools.getYoGraphicResource("square_cross.svg");
        GRAPHIC_2D_CUSTOM_GRAPHICS = Paths.get(SCS2_HOME.toString(), "yoGraphic");
        GRAPHIC_3D_SPHERE_URL = SessionVisualizerIOTools.getYoGraphicResource("sphere.stl");
        GRAPHIC_3D_CUBE_URL = SessionVisualizerIOTools.getYoGraphicResource("cube.stl");
        GRAPHIC_3D_TETRAHEDRON_URL = SessionVisualizerIOTools.getYoGraphicResource("tetrahedron.stl");
        GRAPHIC_3D_ICOSAHEDRON_URL = SessionVisualizerIOTools.getYoGraphicResource("icosahedron.stl");
        GRAPHIC_3D_CUSTOM_GRAPHICS = Paths.get(SCS2_HOME.toString(), "yoGraphic");
        YO_SLIDERBOARD_BCF2000_WINDOW_URL = SessionVisualizerIOTools.getFXMLResource(YO_SLIDERBOARD_BCF2000, "YoBCF2000SliderboardWindow");
        YO_SLIDERBOARD_XTOUCHCOMPACT_WINDOW_URL = SessionVisualizerIOTools.getFXMLResource(YO_SLIDERBOARD_XTOUCHCOMPACT, "YoXTouchCompactSliderboardWindow");
        YO_MULTI_SLIDERBOARD_WINDOW_URL = SessionVisualizerIOTools.getFXMLResource(YO_SLIDERBOARD, "YoMultiSliderboardWindow");
        MAIN_WINDOW_URL = SessionVisualizerIOTools.getFXMLResource("MainWindow");
        SECONDARY_WINDOW_URL = SessionVisualizerIOTools.getFXMLResource("SecondaryWindow");
        SIDE_PANE_URL = SessionVisualizerIOTools.getFXMLResource("SidePane");
        USER_SIDE_PANE_URL = SessionVisualizerIOTools.getFXMLResource("UserSidePane");
        ABOUT_WINDOW_URL = SessionVisualizerIOTools.getFXMLResource("AboutWindow");
        VIDEO_PREVIEW_PANE_URL = SessionVisualizerIOTools.getFXMLResource("VideoRecordingPreviewPane");
        SESSION_DATA_EXPORT_STAGE_URL = SessionVisualizerIOTools.getFXMLResource("SessionDataExportStage");
        SESSION_VARIABLE_FILTER_PANE_URL = SessionVisualizerIOTools.getFXMLResource("SessionVariableFilterPane");
        PLOTTER2D_OPTIONS_STAGE_URL = SessionVisualizerIOTools.getFXMLResource("yoGraphic/", "Plotter2DOptionsStage");
        CAMERA3D_OPTIONS_PANE_URL = SessionVisualizerIOTools.getFXMLResource("camera/Camera3DOptionsPane");
        CHART_PANEL_FXML_URL = SessionVisualizerIOTools.getFXMLResource(CHART, "YoChartPanel");
        CHART_GROUP_PANEL_URL = SessionVisualizerIOTools.getFXMLResource(CHART, "YoChartGroupPanel");
        CHART_GROUP_MODEL_EDITOR_PANE_URL = SessionVisualizerIOTools.getFXMLResource(CHART, "YoChartGroupModelEditorPane");
        CHART_IDENTIFIER_EDITOR_PANE_URL = SessionVisualizerIOTools.getFXMLResource(CHART, "YoChartIdentifierEditorPane");
        CHART_OPTION_DIALOG_URL = SessionVisualizerIOTools.getFXMLResource(CHART, "YoChartOptionDialog");
        CHART_VARIABLE_OPTION_PANE_URL = SessionVisualizerIOTools.getFXMLResource(CHART, "YoChartVariableOptionPane");
        CHART_BASELINE_EDITOR_PANE_URL = SessionVisualizerIOTools.getFXMLResource(CHART, "YoChartBaselineEditorPane");
        YO_GRAPHIC_ITEM_CREATOR_URL = SessionVisualizerIOTools.getFXMLResource("yoGraphic/", "YoGraphicItemCreatorDialog");
        YO_GRAPHIC_PROPERTY_URL = SessionVisualizerIOTools.getFXMLResource("yoGraphic/", "YoGraphicPropertyWindow");
        YO_COMPOSITE_EDITOR_URL = SessionVisualizerIOTools.getFXMLResource(YO_EDITOR, "YoCompositeEditorPane");
        SIMPLE_COLOR_EDITOR_PANE_URL = SessionVisualizerIOTools.getFXMLResource(YO_EDITOR, "SimpleColorEditorPane");
        YO_COLOR_RGBA_EDITOR_PANE_URL = SessionVisualizerIOTools.getFXMLResource(YO_EDITOR, "YoColorRGBAEditorPane");
        YO_COLOR_RGBA_SINGLE_EDITOR_PANE_URL = SessionVisualizerIOTools.getFXMLResource(YO_EDITOR, "YoColorRGBASingleEditorPane");
        YO_GRAPHIC_ROBOT_COLLISIONS_BUTTON_URL = SessionVisualizerIOTools.getFXMLResource("yoGraphic/", "YoGraphicRobotCollisionsToggleButton");
        YO_GRAPHIC_TERRAIN_COLLISIONS_BUTTON_URL = SessionVisualizerIOTools.getFXMLResource("yoGraphic/", "YoGraphicTerrainCollisionsToggleButton");
        YO_GRAPHIC_ROBOT_MASS_PROPERTIES_BUTTON_URL = SessionVisualizerIOTools.getFXMLResource("yoGraphic/", "YoGraphicRobotMassPropertiesToggleButton");
        REMOTE_SESSION_MANAGER_PANE_FXML_URL = SessionVisualizerIOTools.getFXMLResource(SESSION_FOLDER, "RemoteSessionManagerPane");
        REMOTE_SESSION_INFO_PANE_FXML_URL = SessionVisualizerIOTools.getFXMLResource(SESSION_FOLDER, "YoClientInformationPane");
        LOG_SESSION_MANAGER_PANE_FXML_URL = SessionVisualizerIOTools.getFXMLResource(SESSION_FOLDER, "LogSessionManagerPane");
        LOG_CROP_PROGRESS_PANE_FXML_URL = SessionVisualizerIOTools.getFXMLResource(SESSION_FOLDER, "LogCropProgressPane");
        MCAP_LOG_SESSION_MANAGER_PANE_FXML_URL = SessionVisualizerIOTools.getFXMLResource(SESSION_FOLDER, "MCAPLogSessionManagerPane");
        SKYBOX_TOP_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("cloudy/Up.png");
        SKYBOX_BOTTOM_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("cloudy/Down.png");
        SKYBOX_LEFT_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("cloudy/Left.png");
        SKYBOX_RIGHT_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("cloudy/Right.png");
        SKYBOX_FRONT_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("cloudy/Front.png");
        SKYBOX_BACK_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("cloudy/Back.png");
        SCS1_SKYBOX_TOP_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("brightSky/Up.bmp");
        SCS1_SKYBOX_BOTTOM_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("brightSky/Down.bmp");
        SCS1_SKYBOX_LEFT_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("brightSky/Left.bmp");
        SCS1_SKYBOX_RIGHT_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("brightSky/Right.bmp");
        SCS1_SKYBOX_FRONT_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("brightSky/Front.bmp");
        SCS1_SKYBOX_BACK_IMAGE = SessionVisualizerIOTools.loadSkyboxImage("brightSky/Back.bmp");
        phantomStage = null;
    }
}

