/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.color;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.ComboBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import us.ihmc.log.LogTools;
import us.ihmc.scs2.definition.visual.ColorDefinition;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoComposite.YoColorRGBADoubleDefinition;
import us.ihmc.scs2.definition.yoComposite.YoColorRGBAIntDefinition;
import us.ihmc.scs2.definition.yoComposite.YoColorRGBASingleDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.color.PaintEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.color.SimpleColorEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.color.YoColorRGBADoubleEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.color.YoColorRGBAIntEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.color.YoColorRGBASingleEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.BaseColorFX;

public class ColorEditorController {
    @FXML
    private VBox mainPane;
    @FXML
    private ComboBox<ColorType> colorTypeComboBox;
    private final Map<ColorType, PaintEditorController<?>> paintEditors = new HashMap();
    private final ObjectProperty<BaseColorFX> colorProperty = new SimpleObjectProperty((Object)this, "color", null);
    private final BooleanProperty inputsValidityProperty = new SimpleBooleanProperty((Object)this, "inputsValidity", true);

    public void initialize(SessionVisualizerToolkit toolkit) {
        this.colorTypeComboBox.setItems(FXCollections.observableArrayList((Object[])ColorType.values()));
        this.colorTypeComboBox.getSelectionModel().select(null);
        this.colorTypeComboBox.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                PaintEditorController<?> oldEditor = this.paintEditors.get(oldValue);
                if (oldEditor != null) {
                    this.mainPane.getChildren().remove((Object)oldEditor.getMainPane());
                }
                this.colorProperty.unbind();
            }
            if (newValue != null) {
                PaintEditorController<?> newEditor = this.paintEditors.get(newValue);
                if (newEditor == null) {
                    try {
                        FXMLLoader loader = new FXMLLoader(ColorEditorController.editorFXMLResource(newValue));
                        newEditor = ColorEditorController.newEditorController(newValue);
                        loader.setController(newEditor);
                        loader.load();
                        newEditor.initialize(toolkit);
                        this.paintEditors.put((ColorType)((Object)newValue), newEditor);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        this.colorTypeComboBox.getSelectionModel().select((Object)oldValue);
                        return;
                    }
                }
                this.mainPane.getChildren().add((Object)newEditor.getMainPane());
                this.colorProperty.bind(newEditor.colorProperty());
                this.inputsValidityProperty.bind((ObservableValue)newEditor.inputsValidityProperty());
            }
        });
        this.colorTypeComboBox.getSelectionModel().select((Object)ColorType.Simple);
    }

    public void setInput(PaintDefinition definition) {
        ColorType colorType = ColorEditorController.fromDefinition(definition);
        this.colorTypeComboBox.getSelectionModel().select((Object)colorType);
        this.paintEditors.get((Object)colorType).setInput(definition);
    }

    public ObservableBooleanValue inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public ReadOnlyObjectProperty<BaseColorFX> colorProperty() {
        return this.colorProperty;
    }

    private static PaintEditorController<?> newEditorController(ColorType colorType) {
        switch (colorType) {
            case Simple: {
                return new SimpleColorEditorController();
            }
            case Yo_Red_Green_Blue_Double: {
                return new YoColorRGBADoubleEditorController();
            }
            case Yo_Red_Green_Blue_Int: {
                return new YoColorRGBAIntEditorController();
            }
            case Yo_RGBA: {
                return new YoColorRGBASingleEditorController();
            }
        }
        LogTools.error((String)"Unexpected value: {}", (Object)((Object)colorType));
        return new SimpleColorEditorController();
    }

    private static URL editorFXMLResource(ColorType colorType) {
        switch (colorType) {
            case Simple: {
                return SessionVisualizerIOTools.SIMPLE_COLOR_EDITOR_PANE_URL;
            }
            case Yo_Red_Green_Blue_Double: 
            case Yo_Red_Green_Blue_Int: {
                return SessionVisualizerIOTools.YO_COLOR_RGBA_EDITOR_PANE_URL;
            }
            case Yo_RGBA: {
                return SessionVisualizerIOTools.YO_COLOR_RGBA_SINGLE_EDITOR_PANE_URL;
            }
        }
        LogTools.error((String)"Unexpected value: {}", (Object)((Object)colorType));
        return SessionVisualizerIOTools.SIMPLE_COLOR_EDITOR_PANE_URL;
    }

    private static ColorType fromDefinition(PaintDefinition definition) {
        if (definition == null) {
            return ColorType.Simple;
        }
        if (definition instanceof ColorDefinition) {
            return ColorType.Simple;
        }
        if (definition instanceof YoColorRGBADoubleDefinition) {
            return ColorType.Yo_Red_Green_Blue_Double;
        }
        if (definition instanceof YoColorRGBAIntDefinition) {
            return ColorType.Yo_Red_Green_Blue_Int;
        }
        if (definition instanceof YoColorRGBASingleDefinition) {
            return ColorType.Yo_RGBA;
        }
        LogTools.error((String)"Unexpected color definition: {}", (Object)definition);
        return ColorType.Simple;
    }

    public Pane getMainPane() {
        return this.mainPane;
    }

    private static enum ColorType {
        Simple,
        Yo_Red_Green_Blue_Double,
        Yo_Red_Green_Blue_Int,
        Yo_RGBA;


        public String toString() {
            return this.name().replace('_', ' ');
        }
    }
}

