/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import us.ihmc.euclid.referenceFrame.FixedReferenceFrame;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.ReferenceFrameChangedListener;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.FixedMovingReferenceFrame;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.session.YoFixedMovingReferenceFrameUsingYawPitchRoll;
import us.ihmc.scs2.session.YoFixedReferenceFrameUsingYawPitchRoll;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameWrapper;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ObservedAnimationTimer;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeTools;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;
import us.ihmc.scs2.simulation.robot.RobotRootFrame;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoseUsingYawPitchRoll;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class ReferenceFrameManager
implements Manager {
    public static final String WORLD_FRAME = "worldFrame";
    private final ReferenceFrameWrapper worldFrame = new ReferenceFrameWrapper(ReferenceFrameTools.constructARootFrame((String)"worldFrame"));
    private final ObjectProperty<Map<String, ReferenceFrameWrapper>> uniqueNameToReferenceFrameMapProperty = new SimpleObjectProperty((Object)this, "uniqueNameToReferenceFrameMap", null);
    private final ObjectProperty<Map<String, ReferenceFrameWrapper>> uniqueShortNameToReferenceFrameMapProperty = new SimpleObjectProperty((Object)this, "uniqueShortNameToReferenceFrameMap", null);
    private final ObservableMap<String, ReferenceFrameWrapper> fullnameToReferenceFrameMap = FXCollections.observableMap(new ConcurrentHashMap());
    private final List<ReferenceFrameWrapper> undefinedFrames = new ArrayList<ReferenceFrameWrapper>();
    private final YoManager yoManager;
    private final BackgroundExecutorManager backgroundExecutorManager;
    private List<Runnable> cleanupTasks = null;
    private List<Runnable> updateTasks = null;
    private final ReferenceFrameChangedListener frameChangedListener;
    private final ObservedAnimationTimer taskRunner = new ObservedAnimationTimer(this.getClass().getSimpleName()){

        @Override
        public void handleImpl(long now) {
            if (ReferenceFrameManager.this.updateTasks != null) {
                for (int i = 0; i < ReferenceFrameManager.this.updateTasks.size(); ++i) {
                    ReferenceFrameManager.this.updateTasks.get(i).run();
                }
            }
        }
    };

    public ReferenceFrameManager(YoManager yoManager, BackgroundExecutorManager backgroundExecutorManager) {
        this.yoManager = yoManager;
        this.backgroundExecutorManager = backgroundExecutorManager;
        this.frameChangedListener = change -> {
            if (!change.wasAdded()) {
                return;
            }
            ReferenceFrame newFrame = change.getTarget();
            if (newFrame.getName().endsWith("[SCS2Internal]")) {
                return;
            }
            backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> {
                if (ReferenceFrameManager.hasFrameBeenRemoved(newFrame)) {
                    return;
                }
                try {
                    Thread.sleep(100L);
                    if (ReferenceFrameManager.hasFrameBeenRemoved(newFrame)) {
                        return;
                    }
                    this.registerNewSessionFramesNow(ReferenceFrameTools.collectFramesInSubtree((ReferenceFrame)newFrame));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        };
    }

    private static boolean hasFrameBeenRemoved(ReferenceFrame frame) {
        try {
            frame.getName();
            return false;
        }
        catch (RuntimeException e) {
            return true;
        }
    }

    @Override
    public void startSession(Session session) {
        this.refreshReferenceFramesNow();
        this.registerNewSessionFramesNow(ReferenceFrameTools.collectFramesInSubtree((ReferenceFrame)session.getInertialFrame()));
        session.getInertialFrame().addListener(this.frameChangedListener);
        this.addCleanupTask(() -> session.getInertialFrame().removeListener(this.frameChangedListener));
        this.taskRunner.start();
    }

    @Override
    public void stopSession() {
        this.taskRunner.stop();
        if (this.cleanupTasks != null) {
            this.cleanupTasks.forEach(Runnable::run);
            this.cleanupTasks.clear();
            this.cleanupTasks = null;
        }
        this.worldFrame.clearChildren();
        this.uniqueNameToReferenceFrameMapProperty.set(null);
        this.uniqueShortNameToReferenceFrameMapProperty.set(null);
        this.fullnameToReferenceFrameMap.clear();
        this.undefinedFrames.clear();
    }

    @Override
    public boolean isSessionLoaded() {
        if (this.uniqueNameToReferenceFrameMapProperty.get() == null) {
            return false;
        }
        if (this.uniqueShortNameToReferenceFrameMapProperty.get() == null) {
            return false;
        }
        return !this.fullnameToReferenceFrameMap.isEmpty();
    }

    private void addCleanupTask(Runnable task) {
        if (this.cleanupTasks == null) {
            this.cleanupTasks = new ArrayList<Runnable>();
        }
        this.cleanupTasks.add(task);
    }

    private void addUpdateTask(Runnable task) {
        if (this.updateTasks == null) {
            this.updateTasks = new ArrayList<Runnable>();
        }
        this.updateTasks.add(task);
    }

    private void registerNewSessionFramesNow(Collection<ReferenceFrame> sessionFrames) {
        if (sessionFrames == null || sessionFrames.isEmpty()) {
            return;
        }
        if (sessionFrames.stream().anyMatch(sessionFrame -> {
            boolean isRobotFrame = sessionFrame instanceof RobotRootFrame;
            return isRobotFrame && this.getReferenceFrameFromFullname(sessionFrame.getNameId()) == null;
        })) {
            this.backgroundExecutorManager.scheduleTaskInBackground(() -> this.registerNewSessionFramesNow(sessionFrames), 100L, TimeUnit.MILLISECONDS);
            return;
        }
        LinkedList<ReferenceFrame> framesToRegister = new LinkedList<ReferenceFrame>(sessionFrames);
        while (!framesToRegister.isEmpty()) {
            ReferenceFrameWrapper newFrame;
            ReferenceFrame sessionFrame2 = framesToRegister.peek();
            try {
                newFrame = this.duplicateReferenceFrame(sessionFrame2);
            }
            catch (Exception e) {
                if (!ReferenceFrameManager.isARobotFrame(sessionFrame2)) {
                    LogTools.error((String)"Experienced problem setting up frame: {}.", (Object)sessionFrame2.getNameId());
                    e.printStackTrace();
                }
                newFrame = null;
            }
            if (newFrame != null) {
                this.fullnameToReferenceFrameMap.put((Object)newFrame.getFullName(), (Object)newFrame);
            } else if (ReferenceFrameManager.isARobotFrame(sessionFrame2)) {
                this.backgroundExecutorManager.scheduleTaskInBackground(() -> this.registerNewSessionFramesNow(framesToRegister), 500L, TimeUnit.MILLISECONDS);
            }
            framesToRegister.poll();
        }
        this.refreshReferenceFramesNow();
    }

    private static boolean isARobotFrame(ReferenceFrame frame) {
        if (frame instanceof RobotRootFrame) {
            return true;
        }
        return frame.getParent() != null && ReferenceFrameManager.isARobotFrame(frame.getParent());
    }

    private ReferenceFrameWrapper duplicateReferenceFrame(ReferenceFrame sessionFrame) {
        FixedReferenceFrame frame;
        if (sessionFrame == null || sessionFrame.isRootFrame()) {
            return null;
        }
        ReferenceFrameWrapper resultFromFullname = this.getReferenceFrameFromFullname(sessionFrame.getNameId());
        if (resultFromFullname != null && resultFromFullname.isDefined()) {
            return null;
        }
        if (sessionFrame.getName().endsWith("[SCS2Internal]")) {
            return null;
        }
        String frameName = sessionFrame.getName();
        ReferenceFrame sessionParentFrame = sessionFrame.getParent();
        ReferenceFrameWrapper parentFrame = this.getReferenceFrameFromFullname(sessionParentFrame.getNameId());
        if (parentFrame == null) {
            if (!ReferenceFrameManager.isARobotFrame(sessionFrame)) {
                LogTools.warn((String)"Parent frame not found: {}.", (Object)sessionParentFrame.getNameId());
            }
            return null;
        }
        if (!sessionFrame.isFixedInParent()) {
            LogTools.warn((String)"Unhandled frame type: {}, {}.", (Object)sessionFrame.getNameId(), (Object)sessionFrame.getClass().getSimpleName());
            return null;
        }
        if (sessionFrame instanceof FixedReferenceFrame) {
            frame = new FixedReferenceFrame(frameName, parentFrame.getReferenceFrame(), (RigidBodyTransformReadOnly)sessionFrame.getTransformToParent());
        } else if (sessionFrame instanceof FixedMovingReferenceFrame) {
            frame = new FixedMovingReferenceFrame(frameName, parentFrame.getReferenceFrame(), (RigidBodyTransformReadOnly)sessionFrame.getTransformToParent());
        } else if (sessionFrame instanceof YoFixedReferenceFrameUsingYawPitchRoll) {
            YoFramePoseUsingYawPitchRoll sessionOffset = ((YoFixedReferenceFrameUsingYawPitchRoll)sessionFrame).getOffset();
            YoFramePoseUsingYawPitchRoll offset = SharedMemoryTools.duplicate((YoFramePoseUsingYawPitchRoll)sessionOffset, (YoRegistry)this.yoManager.getRootRegistry(), (ReferenceFrame)parentFrame.getReferenceFrame());
            frame = new YoFixedReferenceFrameUsingYawPitchRoll(frameName, offset, parentFrame.getReferenceFrame());
            this.linkFrameYoVariables((ReferenceFrame)frame, offset.getYoX(), offset.getYoY(), offset.getYoZ(), offset.getYoYaw(), offset.getYoPitch(), offset.getYoRoll());
        } else if (sessionFrame instanceof YoFixedMovingReferenceFrameUsingYawPitchRoll) {
            YoFramePoseUsingYawPitchRoll sessionOffset = ((YoFixedMovingReferenceFrameUsingYawPitchRoll)sessionFrame).getOffset();
            YoFramePoseUsingYawPitchRoll offset = SharedMemoryTools.duplicate((YoFramePoseUsingYawPitchRoll)sessionOffset, (YoRegistry)this.yoManager.getRootRegistry(), (ReferenceFrame)parentFrame.getReferenceFrame());
            frame = new YoFixedMovingReferenceFrameUsingYawPitchRoll(frameName, offset, parentFrame.getReferenceFrame());
            this.linkFrameYoVariables((ReferenceFrame)frame, offset.getYoX(), offset.getYoY(), offset.getYoZ(), offset.getYoYaw(), offset.getYoPitch(), offset.getYoRoll());
        } else {
            LogTools.warn((String)"Unhandled frame type: {}, {}.", (Object)sessionFrame.getNameId(), (Object)sessionFrame.getClass().getSimpleName());
            frame = null;
        }
        return new ReferenceFrameWrapper((ReferenceFrame)frame);
    }

    private void linkFrameYoVariables(ReferenceFrame frame, YoDouble ... variablesToLink) {
        AtomicBoolean haveVariableChanged = new AtomicBoolean(true);
        for (int i = 0; i < variablesToLink.length; ++i) {
            this.yoManager.getLinkedRootRegistry().linkYoVariable((YoVariable)variablesToLink[i], (Object)frame);
            variablesToLink[i].addListener(v -> haveVariableChanged.set(true));
        }
        this.addUpdateTask(() -> {
            if (haveVariableChanged.getAndSet(false)) {
                frame.update();
            }
        });
    }

    public void refreshReferenceFramesNow() {
        List<ReferenceFrameWrapper> allReferenceFrames = this.worldFrame.collectSubtree();
        this.computeFullnameMap(allReferenceFrames);
        this.computeUniqueNameMaps(allReferenceFrames);
    }

    public void refreshReferenceFrames() {
        List<ReferenceFrameWrapper> allReferenceFrames = this.worldFrame.collectSubtree();
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> this.computeFullnameMap(allReferenceFrames));
        this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> this.computeUniqueNameMaps(allReferenceFrames));
    }

    private void computeUniqueNameMaps(Collection<ReferenceFrameWrapper> allReferenceFrames) {
        Map<ReferenceFrameWrapper, String> newMap = YoCompositeTools.computeUniqueNames(allReferenceFrames, ReferenceFrameWrapper::getNamespace, ReferenceFrameWrapper::getName);
        LinkedHashMap<String, ReferenceFrameWrapper> newUniqueNameToReferenceFrameMap = new LinkedHashMap<String, ReferenceFrameWrapper>();
        LinkedHashMap<String, ReferenceFrameWrapper> newUniqueShortNameToReferenceFrameMap = new LinkedHashMap<String, ReferenceFrameWrapper>();
        for (Map.Entry<ReferenceFrameWrapper, String> entry : newMap.entrySet()) {
            ReferenceFrameWrapper frame = entry.getKey();
            String value = entry.getValue();
            frame.setUniqueName(value);
            newUniqueNameToReferenceFrameMap.put(frame.getUniqueName(), frame);
            newUniqueShortNameToReferenceFrameMap.put(frame.getUniqueShortName(), frame);
        }
        JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
            this.uniqueNameToReferenceFrameMapProperty.set((Object)newUniqueNameToReferenceFrameMap);
            this.uniqueShortNameToReferenceFrameMapProperty.set((Object)newUniqueShortNameToReferenceFrameMap);
        });
    }

    private void computeFullnameMap(Collection<ReferenceFrameWrapper> allReferenceFrames) {
        for (ReferenceFrameWrapper newFrame : allReferenceFrames) {
            ReferenceFrameWrapper registeredFrame = (ReferenceFrameWrapper)this.fullnameToReferenceFrameMap.get((Object)newFrame.getFullName());
            if (registeredFrame != null) {
                registeredFrame.setReferenceFrame(newFrame.getReferenceFrame());
                continue;
            }
            this.fullnameToReferenceFrameMap.put((Object)newFrame.getFullName(), (Object)newFrame);
        }
    }

    public ReferenceFrameWrapper getWorldFrame() {
        return this.worldFrame;
    }

    public Collection<ReferenceFrameWrapper> getReferenceFrames() {
        if (this.uniqueNameToReferenceFrameMapProperty.get() == null) {
            return Collections.emptyList();
        }
        return ((Map)this.uniqueNameToReferenceFrameMapProperty.get()).values();
    }

    public Collection<String> getReferenceFrameUniqueNames() {
        if (this.uniqueNameToReferenceFrameMapProperty.get() == null) {
            return Collections.emptyList();
        }
        return ((Map)this.uniqueNameToReferenceFrameMapProperty.get()).keySet();
    }

    public Collection<String> getReferenceFrameUniqueShortNames() {
        if (this.uniqueShortNameToReferenceFrameMapProperty.get() == null) {
            return Collections.emptyList();
        }
        return ((Map)this.uniqueShortNameToReferenceFrameMapProperty.get()).keySet();
    }

    public Collection<String> getReferenceFrameFullnames() {
        return this.fullnameToReferenceFrameMap.keySet();
    }

    public ReferenceFrameWrapper getReferenceFrameFromUniqueName(String uniqueName) {
        if (this.uniqueNameToReferenceFrameMapProperty.get() == null) {
            return null;
        }
        ReferenceFrameWrapper frame = (ReferenceFrameWrapper)((Map)this.uniqueNameToReferenceFrameMapProperty.get()).get(uniqueName);
        if (frame == null) {
            return (ReferenceFrameWrapper)((Map)this.uniqueShortNameToReferenceFrameMapProperty.get()).get(uniqueName);
        }
        return frame;
    }

    public ReferenceFrameWrapper getReferenceFrameFromFullname(String fullname) {
        return this.getReferenceFrameFromFullname(fullname, false);
    }

    public ReferenceFrameWrapper getReferenceFrameFromFullname(String fullname, boolean createUndefinedFrameIfNeeded) {
        ReferenceFrameWrapper result = (ReferenceFrameWrapper)this.fullnameToReferenceFrameMap.get((Object)fullname);
        if (result != null) {
            return result;
        }
        if (fullname.startsWith(ReferenceFrame.getWorldFrame().getName())) {
            fullname = fullname.replaceFirst(ReferenceFrame.getWorldFrame().getName(), WORLD_FRAME);
            result = (ReferenceFrameWrapper)this.fullnameToReferenceFrameMap.get((Object)fullname);
        }
        if (result != null) {
            return result;
        }
        if (createUndefinedFrameIfNeeded) {
            String name = fullname.substring(fullname.lastIndexOf(":") + 1);
            result = new ReferenceFrameWrapper(name, fullname);
            this.fullnameToReferenceFrameMap.put((Object)fullname, (Object)result);
            this.undefinedFrames.add(result);
            this.backgroundExecutorManager.queueTaskToExecuteInBackground(this, () -> this.computeUniqueNameMaps(this.fullnameToReferenceFrameMap.values()));
            return result;
        }
        return null;
    }
}

