/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.StringConverter;
import javafx.util.converter.DoubleStringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.ChartMarker;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.UIElement;

public class YoChartBaselineEditorPaneController
implements UIElement {
    @FXML
    private HBox mainPane;
    @FXML
    private TextField coordinateTextField;
    @FXML
    private ColorPicker colorPicker;
    private final TextFormatter<Double> coordinateFormatter = new TextFormatter((StringConverter)new DoubleStringConverter());
    private ChartMarker marker;
    private Runnable closeRequestListener = null;
    private MutableBoolean updatingColor = new MutableBoolean(false);
    private ChangeListener<Color> markerStrokeUpdater = (o, oldValue, newValue) -> {
        if (this.updatingColor.isTrue()) {
            return;
        }
        this.updatingColor.setTrue();
        this.marker.setStroke((Paint)newValue);
        this.updatingColor.setFalse();
    };
    private ChangeListener<Paint> colorPickerUpdater = (o, oldValue, newValue) -> {
        if (this.updatingColor.isTrue()) {
            return;
        }
        this.updatingColor.setTrue();
        if (newValue instanceof Color) {
            this.colorPicker.setValue((Object)((Color)newValue));
        }
        this.updatingColor.setFalse();
    };
    private MutableBoolean updateCoordinate = new MutableBoolean(false);
    private ChangeListener<? super Number> coordinateFormatterUpdater = (o, oldValue, newValue) -> {
        if (this.updateCoordinate.isTrue()) {
            return;
        }
        this.updateCoordinate.setTrue();
        this.coordinateFormatter.setValue((Object)newValue.doubleValue());
        this.updateCoordinate.setFalse();
    };
    private ChangeListener<? super Number> coordinateMarkerUpdater = (o, oldValue, newValue) -> {
        if (this.updateCoordinate.isTrue()) {
            return;
        }
        this.updateCoordinate.setTrue();
        this.marker.setCoordinate(newValue.doubleValue());
        this.updateCoordinate.setFalse();
    };

    public void setInput(ChartMarker marker, Runnable closeRequestListener) {
        this.marker = marker;
        this.closeRequestListener = closeRequestListener;
        this.coordinateTextField.setTextFormatter(this.coordinateFormatter);
        marker.coordinateProperty().addListener(this.coordinateFormatterUpdater);
        this.coordinateFormatter.valueProperty().addListener(this.coordinateMarkerUpdater);
        this.coordinateFormatterUpdater.changed(null, null, (Object)marker.getCoordinate());
        this.colorPicker.valueProperty().addListener(this.markerStrokeUpdater);
        marker.strokeProperty().addListener(this.colorPickerUpdater);
        this.colorPickerUpdater.changed(null, null, (Object)marker.getStroke());
    }

    @FXML
    public void requestClose() {
        if (this.closeRequestListener != null) {
            this.closeRequestListener.run();
        }
    }

    @Override
    public Pane getMainPane() {
        return this.mainPane;
    }

    public ChartMarker getMarker() {
        return this.marker;
    }

    public void dispose() {
        System.out.println("Disposing controller");
        this.marker.coordinateProperty().removeListener(this.coordinateFormatterUpdater);
        this.coordinateFormatter.valueProperty().removeListener(this.coordinateMarkerUpdater);
        this.colorPicker.valueProperty().removeListener(this.markerStrokeUpdater);
        this.marker.strokeProperty().removeListener(this.colorPickerUpdater);
        this.closeRequestListener = null;
    }
}

