/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Rectangle2D;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Pair;
import us.ihmc.log.LogTools;
import us.ihmc.messager.SynchronizeHint;
import us.ihmc.messager.javafx.JavaFXMessager;
import us.ihmc.scs2.definition.configuration.WindowConfigurationDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderboardType;
import us.ihmc.scs2.session.Session;
import us.ihmc.scs2.sessionVisualizer.jfx.SCSGuiConfiguration;
import us.ihmc.scs2.sessionVisualizer.jfx.SecondaryWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.YoRegistryStatisticsPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoSliderboardManager;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.creator.YoCompositeAndEquationEditorWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoComposite.pattern.YoCompositePatternPropertyWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicPropertyWindowController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.Manager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SecondaryWindowManager
implements Manager {
    private static final double SECONDARY_WINDOW_POSITION_OFFSET = 30.0;
    private final SessionVisualizerToolkit toolkit;
    private final Property<YoCompositePatternPropertyWindowController> yoCompositePatternEditor = new SimpleObjectProperty((Object)this, "yoCompositePatternEditor", null);
    private final Property<YoCompositeAndEquationEditorWindowController> yoCompositeCreator = new SimpleObjectProperty((Object)this, "yoCompositeCreator", null);
    private final Property<YoGraphicPropertyWindowController> yoGraphicEditor = new SimpleObjectProperty((Object)this, "yoGraphicEditor", null);
    private final Property<YoRegistryStatisticsPaneController> yoRegistryStatistics = new SimpleObjectProperty((Object)this, "yoRegistryStatistics", null);
    private final List<Stage> secondaryWindows = new ArrayList<Stage>();
    private final List<SecondaryWindowController> secondaryWindowControllers = new ArrayList<SecondaryWindowController>();
    private final YoSliderboardManager sliderboardManager;
    private final JavaFXMessager messager;
    private final SessionVisualizerTopics topics;

    public SecondaryWindowManager(SessionVisualizerToolkit toolkit) {
        this.toolkit = toolkit;
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.sliderboardManager = new YoSliderboardManager(toolkit);
        this.messager.addTopicListener(this.topics.getOpenWindowRequest(), this::openWindow);
    }

    @Override
    public boolean isSessionLoaded() {
        return false;
    }

    @Override
    public void startSession(Session session) {
        this.sliderboardManager.startSession(session);
    }

    public void loadSessionConfiguration(SCSGuiConfiguration configuration) {
        JavaFXMissingTools.runAndWait(this.getClass(), () -> {
            if (configuration.hasSecondaryWindowConfigurations()) {
                List<WindowConfigurationDefinition> secondaryWindowConfigurations = configuration.getSecondaryWindowConfigurations();
                for (int i = 0; i < configuration.getNumberOfSecondaryYoChartGroupConfigurations(); ++i) {
                    WindowConfigurationDefinition secondaryWindowConfiguration = secondaryWindowConfigurations.get(i);
                    Stage stage = this.newChartWindow(null, secondaryWindowConfiguration);
                    this.messager.submitMessage(this.topics.getYoChartGroupLoadConfiguration(), (Object)new Pair((Object)stage, (Object)configuration.getSecondaryYoChartGroupConfigurationFile(i)), SynchronizeHint.SYNCHRONOUS);
                }
            }
        });
    }

    public void saveSessionConfiguration(SCSGuiConfiguration configuration) {
        this.sliderboardManager.saveSessionConfiguration(configuration);
        for (SecondaryWindowController secondaryWindow : this.secondaryWindowControllers) {
            secondaryWindow.saveSessionConfiguration(configuration);
        }
    }

    @Override
    public void stopSession() {
        if (this.yoCompositePatternEditor.getValue() != null) {
            ((YoCompositePatternPropertyWindowController)this.yoCompositePatternEditor.getValue()).closeAndDispose();
            this.yoCompositePatternEditor.setValue(null);
        }
        if (this.yoGraphicEditor.getValue() != null) {
            ((YoGraphicPropertyWindowController)((Object)this.yoGraphicEditor.getValue())).closeAndDispose();
            this.yoGraphicEditor.setValue(null);
        }
        this.sliderboardManager.stopSession();
        if (this.yoRegistryStatistics.getValue() != null) {
            ((YoRegistryStatisticsPaneController)this.yoRegistryStatistics.getValue()).close();
            this.yoRegistryStatistics.setValue(null);
        }
        this.closeAllSecondaryWindows();
    }

    public void closeAllSecondaryWindows() {
        this.secondaryWindows.forEach(secondaryWindow -> secondaryWindow.fireEvent((Event)new WindowEvent((Window)secondaryWindow, WindowEvent.WINDOW_CLOSE_REQUEST)));
        this.secondaryWindowControllers.forEach(SecondaryWindowController::closeAndDispose);
        this.secondaryWindowControllers.clear();
    }

    public void openWindow(NewWindowRequest request) {
        if (request == null) {
            return;
        }
        switch (request.windowType) {
            case "YoCompositePatternEditorWindow": {
                this.openYoCompositePatternEditor(request.requestSource);
                break;
            }
            case "YoCompositeEditorWindow": {
                this.openYoCompositeCreator(request.requestSource);
                break;
            }
            case "SecondaryChartWindow": {
                this.newChartWindow(request.requestSource);
                break;
            }
            case "YoGraphicEditorWindow": {
                this.openYoGraphicEditor(request.requestSource);
                break;
            }
            case "BFC2000EditorWindow": {
                this.sliderboardManager.openSliderboardWindow(request.requestSource, YoSliderboardType.BCF2000);
                return;
            }
            case "XTouchCompactEditorWindow": {
                this.sliderboardManager.openSliderboardWindow(request.requestSource, YoSliderboardType.XTOUCHCOMPACT);
                return;
            }
            case "YoRegistryStatisticsWindow": {
                this.openRegistryStatisticsWindow(request.requestSource, (String)request.additionalData);
            }
            default: {
                LogTools.error((String)("Unexpected value: " + request.windowType));
            }
        }
    }

    private void openYoCompositeCreator(Window requestSource) {
        if (this.yoCompositeCreator.getValue() != null) {
            ((YoCompositeAndEquationEditorWindowController)this.yoCompositeCreator.getValue()).showWindow();
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_COMPOSITE_AND_EQUATION_EDITOR_WINDOW_URL);
            fxmlLoader.load();
            YoCompositeAndEquationEditorWindowController controller = (YoCompositeAndEquationEditorWindowController)fxmlLoader.getController();
            controller.initialize(this.toolkit);
            this.yoCompositeCreator.setValue((Object)controller);
            SecondaryWindowManager.initializeSecondaryWindowWithOwner(requestSource, controller.getWindow());
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openYoCompositePatternEditor(Window requestSource) {
        if (this.yoCompositePatternEditor.getValue() != null) {
            ((YoCompositePatternPropertyWindowController)this.yoCompositePatternEditor.getValue()).showWindow();
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_COMPOSITE_PATTERN_PROPERTY_WINDOW_URL);
            fxmlLoader.load();
            YoCompositePatternPropertyWindowController controller = (YoCompositePatternPropertyWindowController)fxmlLoader.getController();
            controller.initialize(this.toolkit);
            this.yoCompositePatternEditor.setValue((Object)controller);
            SecondaryWindowManager.initializeSecondaryWindowWithOwner(requestSource, controller.getWindow());
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Stage newChartWindow(Window requestSource) {
        return this.newChartWindow(requestSource, null);
    }

    public Stage newChartWindow(Window requestSource, WindowConfigurationDefinition windowConfigurationDefinition) {
        Stage stage = this.newStage(requestSource, windowConfigurationDefinition);
        try {
            FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.SECONDARY_WINDOW_URL);
            loader.load();
            SecondaryWindowController controller = (SecondaryWindowController)loader.getController();
            controller.initialize(new SessionVisualizerWindowToolkit(stage, this.toolkit));
            this.secondaryWindowControllers.add(controller);
            stage.addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
                if (!e.isConsumed()) {
                    this.secondaryWindowControllers.remove(controller);
                }
            });
            controller.start();
            stage.show();
            return stage;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            stage.close();
            return null;
        }
    }

    private Stage newStage(Window requestSource, WindowConfigurationDefinition definition) {
        Stage stage = new Stage();
        if (definition != null) {
            double height;
            double width;
            double positionY;
            double positionX = definition.getPositionX();
            ObservableList screensForRectangle = Screen.getScreensForRectangle((double)positionX, (double)(positionY = definition.getPositionY()), (double)(width = definition.getWidth() > 0.0 ? definition.getWidth() : stage.getWidth()), (double)(height = definition.getHeight() > 0.0 ? definition.getHeight() : stage.getHeight()));
            if (screensForRectangle.isEmpty()) {
                Screen primary = Screen.getPrimary();
                Rectangle2D visualBounds = primary.getVisualBounds();
                width = Math.min(width, visualBounds.getWidth());
                height = Math.min(height, visualBounds.getHeight());
                positionX = 0.5 * (visualBounds.getMinX() + visualBounds.getMaxX() - width);
                positionY = 0.5 * (visualBounds.getMinY() + visualBounds.getMaxY() - height);
            }
            stage.setX(positionX);
            stage.setY(positionY);
            if (definition.isMaximized()) {
                stage.setMaximized(true);
            } else {
                stage.setWidth(width);
                stage.setHeight(height);
            }
        } else {
            SecondaryWindowManager.initializeSecondaryWindowWithOwner(requestSource, stage);
        }
        this.secondaryWindows.add(stage);
        return stage;
    }

    public static WindowConfigurationDefinition toWindowConfigurationDefinition(Stage stage) {
        WindowConfigurationDefinition definition = new WindowConfigurationDefinition();
        if (stage.isMaximized()) {
            definition.setMaximized(true);
            definition.setPositionX(stage.getX());
            definition.setPositionY(stage.getY());
            definition.setWidth(stage.getWidth());
            definition.setHeight(stage.getHeight());
        } else {
            definition.setMaximized(false);
            definition.setPositionX(stage.getX());
            definition.setPositionY(stage.getY());
            definition.setWidth(stage.getWidth());
            definition.setHeight(stage.getHeight());
        }
        return definition;
    }

    private void openYoGraphicEditor(Window requestSource) {
        if (this.yoGraphicEditor.getValue() != null) {
            ((YoGraphicPropertyWindowController)((Object)this.yoGraphicEditor.getValue())).showWindow();
            return;
        }
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_GRAPHIC_PROPERTY_URL);
            fxmlLoader.load();
            YoGraphicPropertyWindowController controller = (YoGraphicPropertyWindowController)((Object)fxmlLoader.getController());
            controller.initialize(this.toolkit);
            this.yoGraphicEditor.setValue((Object)controller);
            SecondaryWindowManager.initializeSecondaryWindowWithOwner(requestSource, controller.getWindow());
            controller.showWindow();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void openRegistryStatisticsWindow(Window requestSource, String registryFullname) {
        YoRegistry registry = this.toolkit.getYoManager().getRootRegistry().findRegistry(new YoNamespace(registryFullname));
        if (registry == null) {
            LogTools.error((String)"Could not find a registry from the name: {}", (Object)registryFullname);
            return;
        }
        if (this.yoRegistryStatistics.getValue() != null) {
            ((YoRegistryStatisticsPaneController)this.yoRegistryStatistics.getValue()).setInput(registry);
            ((YoRegistryStatisticsPaneController)this.yoRegistryStatistics.getValue()).showWindow();
        } else {
            try {
                FXMLLoader fxmlLoader = new FXMLLoader(SessionVisualizerIOTools.YO_REGISTRY_STATISTICS_URL);
                fxmlLoader.load();
                YoRegistryStatisticsPaneController controller = (YoRegistryStatisticsPaneController)fxmlLoader.getController();
                controller.initialize(this.toolkit);
                controller.setInput(registry);
                this.yoRegistryStatistics.setValue((Object)controller);
                SecondaryWindowManager.initializeSecondaryWindowWithOwner(requestSource, controller.getWindow());
                controller.showWindow();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void initializeSecondaryWindowWithOwner(Window owner, Stage secondary) {
        if (owner == null) {
            return;
        }
        secondary.setX(owner.getX() + 30.0);
        secondary.setY(owner.getY() + 30.0);
    }

    public static class NewWindowRequest {
        public static final String REGISTRY_STATISTICS_WINDOW_TYPE = "YoRegistryStatisticsWindow";
        public static final String BFC2000_SLIDERBOARD_WINDOW_TYPE = "BFC2000EditorWindow";
        public static final String XTOUCHCOMPACT_SLIDERBOARD_WINDOW_TYPE = "XTouchCompactEditorWindow";
        public static final String GRAPHIC_EDITOR_WINDOW_TYPE = "YoGraphicEditorWindow";
        public static final String COMPOSITE_PATTERN_EDITOR_WINDOW_TYPE = "YoCompositePatternEditorWindow";
        public static final String COMPOSITE_CREATOR_WINDOW_TYPE = "YoCompositeEditorWindow";
        public static final String SECONDARY_CHART_WINDOW_TYPE = "SecondaryChartWindow";
        private final String windowType;
        private final Window requestSource;
        private final Object additionalData;

        public NewWindowRequest(String windowType, Window requestSource) {
            this(windowType, requestSource, null);
        }

        public NewWindowRequest(String windowType, Window requestSource, Object additionalData) {
            this.windowType = windowType;
            this.requestSource = requestSource;
            this.additionalData = additionalData;
        }

        public static NewWindowRequest registryStatisticWindow(Window requestSource, YoRegistry registry) {
            return new NewWindowRequest(REGISTRY_STATISTICS_WINDOW_TYPE, requestSource, registry.getNamespace().toString());
        }

        public static NewWindowRequest bfc2000SliderboardWindow(Window requestSource) {
            return new NewWindowRequest(BFC2000_SLIDERBOARD_WINDOW_TYPE, requestSource);
        }

        public static NewWindowRequest xtouchCompactSliderboardWindow(Window requestSource) {
            return new NewWindowRequest(XTOUCHCOMPACT_SLIDERBOARD_WINDOW_TYPE, requestSource);
        }

        public static NewWindowRequest graphicEditorWindow(Window requestSource) {
            return new NewWindowRequest(GRAPHIC_EDITOR_WINDOW_TYPE, requestSource);
        }

        public static NewWindowRequest compositePatternEditorWindow(Window requestSource) {
            return new NewWindowRequest(COMPOSITE_PATTERN_EDITOR_WINDOW_TYPE, requestSource);
        }

        public static NewWindowRequest compositeCreatorWindow(Window requestSource) {
            return new NewWindowRequest(COMPOSITE_CREATOR_WINDOW_TYPE, requestSource);
        }

        public static NewWindowRequest chartWindow(Window requestSource) {
            return new NewWindowRequest(SECONDARY_CHART_WINDOW_TYPE, requestSource);
        }
    }
}

