/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.PerspectiveCamera;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.shape.Sphere;
import javafx.scene.transform.Transform;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraControlMode;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraFocalPointHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.CameraOrbitHandler;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.LevelOrbitalCoordinateProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.OrbitalCoordinateProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.camera.PerspectiveCameraController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.editor.searchTextField.DoubleSearchField;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoDoubleProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CompositePropertyTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.CompositeProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;

public class Camera3DOptionsPaneController {
    @FXML
    private RadioButton trackCoordinatesButton;
    @FXML
    private RadioButton trackNodeButton;
    @FXML
    private YoCompositeEditorPaneController yoCoordinateEditorController;
    @FXML
    private TextField trackingNodeTextField;
    @FXML
    private TextField xFocalPointCurrentTextField;
    @FXML
    private TextField yFocalPointCurrentTextField;
    @FXML
    private TextField zFocalPointCurrentTextField;
    @FXML
    private ComboBox<CameraControlMode> cameraPositionComboxBox;
    @FXML
    private Label cameraLabel1;
    @FXML
    private Label cameraLabel2;
    @FXML
    private Label cameraLabel3;
    @FXML
    private TextField cameraTextField1;
    @FXML
    private TextField cameraTextField2;
    @FXML
    private TextField cameraTextField3;
    @FXML
    private ImageView cameraValidImageView1;
    @FXML
    private ImageView cameraValidImageView2;
    @FXML
    private ImageView cameraValidImageView3;
    @FXML
    private TextField xCameraCurrentTextField;
    @FXML
    private TextField yCameraCurrentTextField;
    @FXML
    private TextField zCameraCurrentTextField;
    private Label[] cameraLabels;
    private TextField[] cameraTextFields;
    private final DoubleSearchField[] cameraCoordinatesSearchFields = new DoubleSearchField[3];
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();

    public void initialize(PerspectiveCameraController cameraController, YoCompositeSearchManager searchManager, LinkedYoRegistry linkedRootRegistry, ReferenceFrameManager referenceFrameManager) {
        this.initializeFocalPointControls(cameraController, searchManager, linkedRootRegistry, referenceFrameManager);
        this.initializeCameraControls(cameraController, searchManager, linkedRootRegistry);
    }

    public void initializeFocalPointControls(PerspectiveCameraController cameraController, YoCompositeSearchManager searchManager, LinkedYoRegistry linkedRootRegistry, ReferenceFrameManager referenceFrameManager) {
        PerspectiveCamera camera = cameraController.getCamera();
        CameraFocalPointHandler focalPointHandler = cameraController.getFocalPointHandler();
        ObjectProperty<CameraFocalPointHandler.TrackingTargetType> targetTypeProperty = focalPointHandler.targetTypeProperty();
        ToggleGroup toggleGroup = new ToggleGroup();
        toggleGroup.getToggles().addAll((Object[])new Toggle[]{this.trackCoordinatesButton, this.trackNodeButton});
        this.trackNodeButton.setSelected(targetTypeProperty.get() == CameraFocalPointHandler.TrackingTargetType.Node);
        this.trackCoordinatesButton.setSelected(targetTypeProperty.get() == CameraFocalPointHandler.TrackingTargetType.YoCoordinates);
        MutableBoolean updatingTarget = new MutableBoolean(false);
        toggleGroup.selectedToggleProperty().addListener((o, oldValue, newValue) -> {
            if (updatingTarget.booleanValue()) {
                return;
            }
            updatingTarget.setTrue();
            if (newValue == this.trackNodeButton) {
                targetTypeProperty.set((Object)CameraFocalPointHandler.TrackingTargetType.Node);
            } else if (newValue == this.trackCoordinatesButton) {
                targetTypeProperty.set((Object)CameraFocalPointHandler.TrackingTargetType.YoCoordinates);
            } else {
                targetTypeProperty.set((Object)CameraFocalPointHandler.TrackingTargetType.Disabled);
            }
            updatingTarget.setFalse();
        });
        ChangeListener targetTypeChangeListener = (o, oldValue, newValue) -> {
            if (updatingTarget.booleanValue()) {
                return;
            }
            updatingTarget.setTrue();
            this.trackNodeButton.setSelected(targetTypeProperty.get() == CameraFocalPointHandler.TrackingTargetType.Node);
            this.trackCoordinatesButton.setSelected(targetTypeProperty.get() == CameraFocalPointHandler.TrackingTargetType.YoCoordinates);
            updatingTarget.setFalse();
        };
        targetTypeProperty.addListener(targetTypeChangeListener);
        this.cleanupTasks.add(() -> targetTypeProperty.removeListener(targetTypeChangeListener));
        targetTypeChangeListener.changed(targetTypeProperty, null, targetTypeProperty.get());
        ChangeListener focalPointTransformChangeListener = (o, oldValue, newValue) -> {
            this.xFocalPointCurrentTextField.setText(Double.toString(newValue.getTx()));
            this.yFocalPointCurrentTextField.setText(Double.toString(newValue.getTy()));
            this.zFocalPointCurrentTextField.setText(Double.toString(newValue.getTz()));
        };
        Sphere focalPoint = cameraController.getFocalPointViz();
        focalPoint.localToSceneTransformProperty().addListener(focalPointTransformChangeListener);
        this.cleanupTasks.add(() -> Camera3DOptionsPaneController.lambda$initializeFocalPointControls$4((Node)focalPoint, focalPointTransformChangeListener));
        focalPointTransformChangeListener.changed((ObservableValue)focalPoint.localToSceneTransformProperty(), null, (Object)focalPoint.getLocalToSceneTransform());
        ChangeListener cameraTransformChangeListener = (o, oldValue, newValue) -> {
            this.xCameraCurrentTextField.setText(Double.toString(newValue.getTx()));
            this.yCameraCurrentTextField.setText(Double.toString(newValue.getTy()));
            this.zCameraCurrentTextField.setText(Double.toString(newValue.getTz()));
        };
        camera.localToSceneTransformProperty().addListener(cameraTransformChangeListener);
        this.cleanupTasks.add(() -> camera.localToSceneTransformProperty().removeListener(cameraTransformChangeListener));
        cameraTransformChangeListener.changed((ObservableValue)camera.localToSceneTransformProperty(), null, (Object)camera.getLocalToSceneTransform());
        YoCompositeCollection yoTuple3DCollection = searchManager.getYoTuple3DCollection();
        if (yoTuple3DCollection == null) {
            this.yoCoordinateEditorController.getMainPane().setDisable(true);
        } else {
            ObjectProperty<Tuple3DProperty> coordinatesToTrack = focalPointHandler.coordinatesToTrackProperty();
            this.yoCoordinateEditorController.initialize(searchManager, referenceFrameManager, linkedRootRegistry, yoTuple3DCollection, true);
            this.yoCoordinateEditorController.setCompositeName("Tracking Coordinates");
            this.yoCoordinateEditorController.getMainPane().disableProperty().bind((ObservableValue)this.trackCoordinatesButton.selectedProperty().not());
            if (coordinatesToTrack.get() != null) {
                this.yoCoordinateEditorController.setInput((CompositeProperty)coordinatesToTrack.get());
            }
            this.yoCoordinateEditorController.addInputListener((coords, frame) -> coordinatesToTrack.set((Object)new Tuple3DProperty((Property<ReferenceFrame>)frame, (DoubleProperty[])coords)));
        }
        this.trackingNodeTextField.setEditable(false);
        this.trackingNodeTextField.setTooltip(new Tooltip("To select a node to track, right click on it in the 3D view and select in the context menu."));
        this.trackingNodeTextField.disableProperty().bind((ObservableValue)this.trackNodeButton.selectedProperty().not());
        ObjectProperty<Node> nodeToTrack = focalPointHandler.nodeToTrackProperty();
        this.trackingNodeTextField.setText(nodeToTrack.get() == null ? "null" : ((Node)nodeToTrack.get()).getId());
        ChangeListener nodeTrackedChangeListener = (o, oldValue, newValue) -> {
            if (newValue == null) {
                this.trackingNodeTextField.setText("No node being tracked");
            } else if (newValue.getId() == null || newValue.getId().isBlank()) {
                this.trackingNodeTextField.setText("Tracking node w/o id");
            } else {
                this.trackingNodeTextField.setText(newValue.getId());
            }
        };
        nodeToTrack.addListener(nodeTrackedChangeListener);
        this.cleanupTasks.add(() -> nodeToTrack.removeListener(nodeTrackedChangeListener));
        nodeTrackedChangeListener.changed(nodeToTrack, null, nodeToTrack.get());
    }

    public void initializeCameraControls(PerspectiveCameraController cameraController, YoCompositeSearchManager searchManager, LinkedYoRegistry linkedRootRegistry) {
        ReadOnlyObjectProperty currentCameraPose = cameraController.getCamera().localToSceneTransformProperty();
        CameraOrbitHandler orbitHandler = cameraController.getOrbitHandler();
        Property<Tuple3DProperty> cameraPositionCoordinatesToTrack = cameraController.cameraPositionCoordinatesToTrackProperty();
        Property<OrbitalCoordinateProperty> cameraOrbitalCoordinatesToTrack = cameraController.cameraOrbitalCoordinatesToTrackProperty();
        Property<LevelOrbitalCoordinateProperty> cameraLevelOrbitalCoordinatesToTrack = cameraController.cameraLevelOrbitalCoordinatesToTrackProperty();
        this.cameraLabels = new Label[]{this.cameraLabel1, this.cameraLabel2, this.cameraLabel3};
        this.cameraTextFields = new TextField[]{this.cameraTextField1, this.cameraTextField2, this.cameraTextField3};
        this.cameraPositionComboxBox.setItems(FXCollections.observableArrayList((Object[])CameraControlMode.values()));
        this.cameraCoordinatesSearchFields[0] = new DoubleSearchField(this.cameraTextField1, searchManager, linkedRootRegistry, this.cameraValidImageView1);
        this.cameraCoordinatesSearchFields[1] = new DoubleSearchField(this.cameraTextField2, searchManager, linkedRootRegistry, this.cameraValidImageView2);
        this.cameraCoordinatesSearchFields[2] = new DoubleSearchField(this.cameraTextField3, searchManager, linkedRootRegistry, this.cameraValidImageView3);
        MutableBoolean updatingCameraTextFields = new MutableBoolean(false);
        for (int i = 0; i < this.cameraCoordinatesSearchFields.length; ++i) {
            this.cameraCoordinatesSearchFields[i].setupAutoCompletion();
            int supplierIndex = i;
            this.cameraCoordinatesSearchFields[i].supplierProperty().addListener((o, oldValue, newValue) -> {
                if (updatingCameraTextFields.booleanValue()) {
                    return;
                }
                CameraControlMode controlMode = (CameraControlMode)((Object)((Object)cameraController.cameraControlMode().getValue()));
                CompositeProperty composite = switch (controlMode) {
                    default -> throw new IncompatibleClassChangeError();
                    case CameraControlMode.Position -> (Tuple3DProperty)cameraPositionCoordinatesToTrack.getValue();
                    case CameraControlMode.Orbital -> (OrbitalCoordinateProperty)cameraOrbitalCoordinatesToTrack.getValue();
                    case CameraControlMode.LevelOrbital -> (LevelOrbitalCoordinateProperty)cameraLevelOrbitalCoordinatesToTrack.getValue();
                };
                DoubleProperty[] components = Arrays.copyOf(composite.componentValueProperties(), 3);
                components[supplierIndex] = newValue;
                switch (controlMode) {
                    case Position: {
                        cameraPositionCoordinatesToTrack.setValue((Object)new Tuple3DProperty(components));
                        break;
                    }
                    case Orbital: {
                        cameraOrbitalCoordinatesToTrack.setValue((Object)new OrbitalCoordinateProperty(components));
                        break;
                    }
                    case LevelOrbital: {
                        cameraLevelOrbitalCoordinatesToTrack.setValue((Object)new LevelOrbitalCoordinateProperty(components));
                    }
                }
            });
        }
        this.cameraPositionComboxBox.getSelectionModel().selectedItemProperty().addListener((o, oldValue, newValue) -> {
            cameraController.cameraControlMode().setValue((Object)newValue);
            CompositeProperty composite = switch (newValue) {
                case CameraControlMode.Position -> {
                    if (cameraPositionCoordinatesToTrack.getValue() == null) {
                        cameraPositionCoordinatesToTrack.setValue((Object)new Tuple3DProperty(((Transform)currentCameraPose.get()).getTx(), ((Transform)currentCameraPose.get()).getTy(), ((Transform)currentCameraPose.get()).getTz()));
                    }
                    yield (Tuple3DProperty)cameraPositionCoordinatesToTrack.getValue();
                }
                case CameraControlMode.Orbital -> {
                    if (cameraOrbitalCoordinatesToTrack.getValue() == null) {
                        cameraOrbitalCoordinatesToTrack.setValue((Object)new OrbitalCoordinateProperty(orbitHandler.distanceProperty().get(), orbitHandler.longitudeProperty().get(), orbitHandler.latitudeProperty().get()));
                    }
                    yield (OrbitalCoordinateProperty)cameraOrbitalCoordinatesToTrack.getValue();
                }
                case CameraControlMode.LevelOrbital -> {
                    if (cameraLevelOrbitalCoordinatesToTrack.getValue() == null) {
                        cameraLevelOrbitalCoordinatesToTrack.setValue((Object)new LevelOrbitalCoordinateProperty(orbitHandler.distanceProperty().get(), orbitHandler.longitudeProperty().get(), ((Transform)currentCameraPose.get()).getTz()));
                    }
                    yield (LevelOrbitalCoordinateProperty)cameraLevelOrbitalCoordinatesToTrack.getValue();
                }
                default -> throw new IllegalStateException("Unexpected type: " + newValue);
            };
            updatingCameraTextFields.setTrue();
            for (int i = 0; i < 3; ++i) {
                this.cameraLabels[i].setText(composite.getComponentIdentifiers()[i]);
                this.cameraTextFields[i].setText(CompositePropertyTools.toDoublePropertyName(composite.componentValueProperties()[i]));
            }
            updatingCameraTextFields.setFalse();
        });
        CameraControlMode[] controlModes = new CameraControlMode[]{CameraControlMode.Position, CameraControlMode.Orbital, CameraControlMode.LevelOrbital};
        Property[] cameraCoordinatesProperties = new Property[]{cameraPositionCoordinatesToTrack, cameraOrbitalCoordinatesToTrack, cameraLevelOrbitalCoordinatesToTrack};
        for (int i = 0; i < cameraCoordinatesProperties.length; ++i) {
            CameraControlMode controlMode = controlModes[i];
            Property cameraCoordinatesProperty = cameraCoordinatesProperties[i];
            ArrayList<ChangeListener> componentChangeListeners = new ArrayList<ChangeListener>();
            int componentIndex = 0;
            while (componentIndex < 3) {
                int componentIndexFinal = componentIndex++;
                componentChangeListeners.add((o, oldValue, newValue) -> {
                    if (cameraController.cameraControlMode().getValue() != controlMode) {
                        return;
                    }
                    if (this.cameraTextFields[componentIndexFinal].isFocused()) {
                        return;
                    }
                    updatingCameraTextFields.setTrue();
                    CompositeProperty cameraCoordinates = (CompositeProperty)cameraCoordinatesProperty.getValue();
                    this.cameraTextFields[componentIndexFinal].setText(CompositePropertyTools.toDoublePropertyName(cameraCoordinates.componentValueProperties()[componentIndexFinal]));
                    updatingCameraTextFields.setFalse();
                });
            }
            ChangeListener cameraCoordinatesChangeListener = (o, oldValue, newValue) -> {
                DoubleProperty componentValueProperty;
                int componentIndex;
                if (oldValue != null && oldValue.componentValueProperties() != null) {
                    for (componentIndex = 0; componentIndex < 3; ++componentIndex) {
                        componentValueProperty = oldValue.componentValueProperties()[componentIndex];
                        if (componentValueProperty == null || componentValueProperty instanceof YoDoubleProperty) continue;
                        componentValueProperty.removeListener((ChangeListener)componentChangeListeners.get(componentIndex));
                    }
                }
                if (newValue != null && newValue.componentValueProperties() != null) {
                    for (componentIndex = 0; componentIndex < 3; ++componentIndex) {
                        componentValueProperty = newValue.componentValueProperties()[componentIndex];
                        if (componentValueProperty == null || componentValueProperty instanceof YoDoubleProperty) continue;
                        componentValueProperty.addListener((ChangeListener)componentChangeListeners.get(componentIndex));
                    }
                }
            };
            cameraCoordinatesProperty.addListener(cameraCoordinatesChangeListener);
            this.cleanupTasks.add(() -> {
                cameraCoordinatesProperty.removeListener(cameraCoordinatesChangeListener);
                cameraCoordinatesChangeListener.changed(null, (Object)((CompositeProperty)cameraCoordinatesProperty.getValue()), null);
            });
        }
        this.cameraPositionComboxBox.getSelectionModel().select((Object)((CameraControlMode)((Object)cameraController.cameraControlMode().getValue())));
    }

    public void closeAndDispose() {
        this.cleanupTasks.forEach(Runnable::run);
        this.cleanupTasks.clear();
    }

    private static /* synthetic */ void lambda$initializeFocalPointControls$4(Node focalPoint, ChangeListener focalPointTransformChangeListener) {
        focalPoint.localToSceneTransformProperty().removeListener(focalPointTransformChangeListener);
    }
}

