/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor;

import com.jfoenix.controls.JFXRadioButton;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import us.ihmc.scs2.definition.visual.PaintDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic2DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.color.ColorEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.color.BaseColorFX;

public class YoGraphic2DStyleEditorPaneController {
    public static final double DEFAULT_STROKE_WIDTH = YoGraphicFX2D.DEFAULT_STROKE_WIDTH.get();
    @FXML
    private GridPane mainPane;
    @FXML
    private JFXRadioButton fillRadioButton;
    @FXML
    private ColorEditorController fillColorEditorController;
    @FXML
    private JFXRadioButton strokeRadioButton;
    @FXML
    private ColorEditorController strokeColorEditorController;
    @FXML
    private TextField strokeWidthTextField;
    @FXML
    private ImageView strokeWidthValidImageView;
    private final ObjectProperty<BaseColorFX> fillColorProperty = new SimpleObjectProperty((Object)this, "fillColor", null);
    private final ObjectProperty<BaseColorFX> strokeColorProperty = new SimpleObjectProperty((Object)this, "strokeColor", null);
    private final BooleanProperty strokeWidthValidityProperty = new SimpleBooleanProperty((Object)this, "strokeWidthValidityProperty", false);
    private final DoubleProperty strokeWidthProperty = new SimpleDoubleProperty((Object)this, "strokeWidth", DEFAULT_STROKE_WIDTH);
    private ObservableBooleanValue inputsValidityProperty;

    public void initialize(SessionVisualizerToolkit toolkit) {
        new ToggleGroup().getToggles().addAll((Object[])new Toggle[]{this.fillRadioButton, this.strokeRadioButton});
        this.fillColorEditorController.initialize(toolkit);
        this.strokeColorEditorController.initialize(toolkit);
        this.fillColorEditorController.getMainPane().disableProperty().bind((ObservableValue)this.strokeRadioButton.selectedProperty());
        this.strokeColorEditorController.getMainPane().disableProperty().bind((ObservableValue)this.fillRadioButton.selectedProperty());
        YoGraphicFXControllerTools.numericalValidityBinding(this.strokeWidthTextField.textProperty(), this.strokeWidthValidityProperty);
        YoGraphicFXControllerTools.bindValidityImageView((ObservableBooleanValue)this.strokeWidthValidityProperty, this.strokeWidthValidImageView);
        this.inputsValidityProperty = this.strokeWidthValidityProperty;
        this.strokeWidthTextField.textProperty().addListener((observable, oldValue, newValue) -> {
            if (this.strokeWidthValidityProperty.get()) {
                this.strokeWidthProperty.set(Double.parseDouble(newValue));
            }
        });
        this.fillRadioButton.selectedProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.fillColorProperty.bind(this.fillColorEditorController.colorProperty());
                this.strokeColorProperty.unbind();
                this.strokeColorProperty.set(null);
            } else {
                this.strokeColorProperty.bind(this.strokeColorEditorController.colorProperty());
                this.fillColorProperty.unbind();
                this.fillColorProperty.set(null);
            }
        });
        if (this.fillRadioButton.isSelected()) {
            this.fillColorProperty.bind(this.fillColorEditorController.colorProperty());
            this.strokeColorProperty.unbind();
            this.strokeColorProperty.set(null);
        } else {
            this.strokeColorProperty.bind(this.strokeColorEditorController.colorProperty());
            this.fillColorProperty.unbind();
            this.fillColorProperty.set(null);
        }
    }

    public void setInput(YoGraphic2DDefinition definition) {
        this.setInput(definition.getFillColor(), definition.getStrokeColor(), definition.getStrokeWidth());
    }

    public void setInput(PaintDefinition fillColor, PaintDefinition strokeColor, String strokeWidth) {
        if (fillColor != null) {
            this.fillRadioButton.setSelected(true);
            this.fillColorEditorController.setInput(fillColor);
        } else {
            this.strokeRadioButton.setSelected(true);
            this.strokeColorEditorController.setInput(strokeColor);
        }
        this.strokeWidthTextField.setText(strokeWidth);
    }

    public void bindYoGraphicFX2D(YoGraphicFX2D yoGraphicFX2DToBind) {
        this.fillColorProperty.addListener((o, oldValue, newValue) -> yoGraphicFX2DToBind.setFillColor((BaseColorFX)newValue));
        this.strokeColorProperty.addListener((o, oldValue, newValue) -> yoGraphicFX2DToBind.setStrokeColor((BaseColorFX)newValue));
        this.strokeWidthProperty.addListener((o, oldValue, newValue) -> yoGraphicFX2DToBind.setStrokeWidth(newValue.doubleValue()));
    }

    public void addInputNotification(Runnable callback) {
        ChangeListener changeListener = (o, oldValue, newValue) -> callback.run();
        this.fillColorProperty.addListener(changeListener);
        this.strokeColorProperty.addListener(changeListener);
        this.strokeWidthProperty.addListener(changeListener);
    }

    public ObservableBooleanValue inputsValidityProperty() {
        return this.inputsValidityProperty;
    }

    public ReadOnlyObjectProperty<BaseColorFX> fillColorProperty() {
        return this.fillColorEditorController.colorProperty();
    }

    public ReadOnlyObjectProperty<BaseColorFX> strokeColorProperty() {
        return this.strokeColorEditorController.colorProperty();
    }

    public ReadOnlyDoubleProperty strokeWidthProperty() {
        return this.strokeWidthProperty;
    }

    public GridPane getMainPane() {
        return this.mainPane;
    }
}

