/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D;

import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import us.ihmc.scs2.definition.yoComposite.YoCompositeDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphic3DDefinition;
import us.ihmc.scs2.definition.yoGraphic.YoGraphicSTPBox3DDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.graphic3D.YoGraphicFX3DEditorController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoSTPBoxFX3D;

public class YoSTPBoxFX3DEditorController
extends YoGraphicFX3DEditorController<YoSTPBoxFX3D> {
    @FXML
    private YoCompositeEditorPaneController positionEditorController;
    @FXML
    private YoCompositeEditorPaneController orientationEditorController;
    @FXML
    private YoCompositeEditorPaneController sizeEditorController;
    @FXML
    private TextField minimumMarginTextField;
    @FXML
    private TextField maximumMarginTextField;
    @FXML
    private ImageView minimumMarginValidImageView;
    @FXML
    private ImageView maximumMarginValidImageView;
    private YoGraphicSTPBox3DDefinition definitionBeforeEdits;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoSTPBoxFX3D yoGraphicToEdit) {
        super.initialize(toolkit, yoGraphicToEdit);
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicSTPBox3DDefinition(yoGraphicToEdit);
        yoGraphicToEdit.visibleProperty().addListener((observable, oldValue, newValue) -> this.definitionBeforeEdits.setVisible(newValue.booleanValue()));
        this.setupTuple3DPropertyEditor(this.positionEditorController, "Position", true, yoGraphicToEdit.getPosition());
        this.setupOrientation3DProperty(this.orientationEditorController, "Orientation", true, yoGraphicToEdit.getOrientation());
        this.setupTuple3DPropertyEditor(this.sizeEditorController, "Size", false, yoGraphicToEdit.getSize());
        this.setupDoublePropertyEditor(this.minimumMarginTextField, this.minimumMarginValidImageView, YoSTPBoxFX3D::setMinimumMargin);
        this.setupDoublePropertyEditor(this.maximumMarginTextField, this.maximumMarginValidImageView, YoSTPBoxFX3D::setMaximumMargin);
        this.resetFields();
    }

    @Override
    protected <T> void updateHasChangesPendingProperty(ObservableValue<? extends T> observable, T oldValue, T newValue) {
        this.hasChangesPendingProperty.set(!this.definitionBeforeEdits.equals((Object)YoGraphicTools.toYoGraphicSTPBox3DDefinition((YoSTPBoxFX3D)this.yoGraphicToEdit)));
    }

    @Override
    public void resetFields() {
        this.positionEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getPosition());
        this.orientationEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getOrientation());
        this.sizeEditorController.setInput((YoCompositeDefinition)this.definitionBeforeEdits.getSize());
        this.minimumMarginTextField.setText(this.definitionBeforeEdits.getMinimumMargin());
        this.maximumMarginTextField.setText(this.definitionBeforeEdits.getMaximumMargin());
        this.styleEditorController.setInput((YoGraphic3DDefinition)this.definitionBeforeEdits);
        this.nameEditorController.setInput(this.definitionBeforeEdits.getName(), ((YoSTPBoxFX3D)this.yoGraphicToEdit).getNamespace());
    }

    @Override
    public void saveChanges() {
        this.definitionBeforeEdits = YoGraphicTools.toYoGraphicSTPBox3DDefinition((YoSTPBoxFX3D)this.yoGraphicToEdit);
        this.hasChangesPendingProperty.set(false);
    }
}

