/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import net.javainthebox.caraibe.svg.SVGContent;
import net.javainthebox.caraibe.svg.SVGLoader;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple2DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResource;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXResourceManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoPointcloudFX2D
extends YoGraphicFX2D {
    private final Group pointcloudNode = new Group();
    private List<Tuple2DProperty> points = new ArrayList<Tuple2DProperty>();
    private IntegerProperty numberOfPoints = null;
    private DoubleProperty size = new SimpleDoubleProperty(0.01);
    private YoGraphicFXResource graphicResource = YoGraphicFXResourceManager.DEFAULT_POINT2D_GRAPHIC_RESOURCE;
    private final Scale scale = new Scale();
    private final List<Translate> translates = new ArrayList<Translate>();
    private final IntegerProperty numberOfPointsProperty = new SimpleIntegerProperty((Object)this, "numberOfPoints", 0);
    private final ObjectProperty<Paint> fillProperty = new SimpleObjectProperty((Object)this, "fillProperty", null);
    private final ObjectProperty<Paint> strokeProperty = new SimpleObjectProperty((Object)this, "strokeProperty", (Object)Color.BLACK);
    private final DoubleProperty strokeWidthProperty = new SimpleDoubleProperty((Object)this, "strokeWidthProperty", 0.0);
    private final BooleanProperty refreshGraphicsProperty = new SimpleBooleanProperty((Object)this, "refreshGraphics", true);

    public YoPointcloudFX2D() {
        this.numberOfPointsProperty.addListener((observable, oldValue, newValue) -> this.refreshGraphicsProperty.set(true));
        this.pointcloudNode.idProperty().bind((ObservableValue)this.nameProperty());
        this.pointcloudNode.getProperties().put((Object)YO_GRAPHICFX_ITEM_KEY, (Object)this);
    }

    public YoPointcloudFX2D(ReferenceFrame worldFrame) {
        this();
    }

    @Override
    public void render() {
        this.scale.setX(0.001 * this.size.get());
        this.scale.setY(0.001 * this.size.get());
        this.fillProperty.set(this.fillColor == null ? null : (Paint)this.fillColor.get());
        this.strokeProperty.set(this.strokeColor == null ? null : (Paint)this.strokeColor.get());
        if (this.strokeWidth == null) {
            this.strokeWidth = YoGraphicFX2D.DEFAULT_STROKE_WIDTH;
        }
        double scale = 0.001 * this.size.get() * this.pointcloudNode.getLocalToSceneTransform().deltaTransform(1.0, 0.0).getX();
        this.strokeWidthProperty.set(this.strokeWidth.get() / scale);
        if (this.points == null) {
            this.numberOfPointsProperty.set(0);
        } else if (this.numberOfPoints != null) {
            this.numberOfPointsProperty.set(Math.min(this.numberOfPoints.get(), this.points.size()));
        } else {
            this.numberOfPointsProperty.set(this.points.size());
        }
        if (this.refreshGraphicsProperty.get()) {
            this.refreshGraphicsProperty.set(false);
            this.refreshGraphics();
        }
        for (int i = 0; i < this.numberOfPointsProperty.get(); ++i) {
            Translate translate = this.translates.get(i);
            if (this.points.get(i).containsNaN()) {
                translate.setX(Double.NEGATIVE_INFINITY);
                translate.setY(Double.NEGATIVE_INFINITY);
                continue;
            }
            Point2D position = this.points.get(i).toPoint2DInWorld();
            translate.setX(position.getX());
            translate.setY(position.getY());
        }
    }

    private void refreshGraphics() {
        this.pointcloudNode.getChildren().clear();
        this.translates.clear();
        if (this.numberOfPointsProperty.get() == 0 || this.graphicResource == null || this.graphicResource.getResourceURL() == null) {
            return;
        }
        for (int i = 0; i < this.numberOfPointsProperty.get(); ++i) {
            Translate translate = new Translate();
            this.translates.add(translate);
            SVGContent graphic = SVGLoader.load((URL)this.graphicResource.getResourceURL());
            List<Shape> shapes = YoGraphicTools.extractShapes((Group)graphic);
            for (Shape shape : shapes) {
                shape.fillProperty().bind(this.fillProperty);
                shape.strokeProperty().bind(this.strokeProperty);
                shape.strokeWidthProperty().bind((ObservableValue)this.strokeWidthProperty);
                shape.idProperty().bind((ObservableValue)this.nameProperty().concat((Object)" (").concat((Object)Integer.toString(i)).concat((Object)")"));
            }
            graphic.getTransforms().addAll((Object[])new Transform[]{translate, this.scale});
            this.pointcloudNode.getChildren().add((Object)graphic);
        }
    }

    public void setPoints(List<Tuple2DProperty> points) {
        this.points = points;
    }

    public void addPoint(DoubleProperty x, DoubleProperty y) {
        this.addPoint(new Tuple2DProperty(null, x, y));
    }

    public void addPoint(Tuple2DProperty point) {
        this.points.add(point);
    }

    public void setNumberOfPoints(IntegerProperty numberOfPoints) {
        this.numberOfPoints = numberOfPoints;
    }

    public void setNumberOfPoints(int numberOfPoints) {
        this.numberOfPoints = new SimpleIntegerProperty(numberOfPoints);
    }

    public void setSize(DoubleProperty size) {
        this.size = size;
    }

    public void setSize(double size) {
        this.size = new SimpleDoubleProperty(size);
    }

    public void setGraphicResource(YoGraphicFXResource graphicResource) {
        this.graphicResource = graphicResource;
        this.refreshGraphicsProperty.set(true);
    }

    @Override
    public void clear() {
        this.pointcloudNode.getChildren().clear();
        this.points.clear();
        this.points = null;
        this.numberOfPoints = null;
        this.size = null;
        this.graphicResource = null;
        this.translates.clear();
    }

    @Override
    public YoGraphicFX clone() {
        YoPointcloudFX2D clone = new YoPointcloudFX2D();
        clone.setName(this.getName());
        clone.setPoints(new ArrayList<Tuple2DProperty>(this.points));
        clone.setNumberOfPoints(this.numberOfPoints);
        clone.setSize(this.size);
        clone.setFillColor(this.fillColor);
        clone.setStrokeColor(this.strokeColor);
        clone.setStrokeWidth(this.strokeWidth);
        clone.setGraphicResource(this.graphicResource);
        return clone;
    }

    public List<Tuple2DProperty> getPoints() {
        return this.points;
    }

    public IntegerProperty getNumberOfPoints() {
        return this.numberOfPoints;
    }

    public DoubleProperty getSize() {
        return this.size;
    }

    public YoGraphicFXResource getGraphicResource() {
        return this.graphicResource;
    }

    @Override
    public Node getNode() {
        return this.pointcloudNode;
    }
}

