/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXToggleButton;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.ToLongFunction;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableLongValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Pane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.log.LogTools;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;
import us.ihmc.scs2.session.log.LogDataReader;
import us.ihmc.scs2.session.log.LogSession;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerIOTools;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.BackgroundExecutorManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.session.SessionControlsController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.LogCropProgressController;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.MultiVideoDataReader;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.MultiVideoViewer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.YoVariableLogCropper;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CropSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;

public class LogSessionManagerController
implements SessionControlsController {
    private static final double THUMBNAIL_WIDTH = 200.0;
    private static final String LOG_FILE_KEY = "logFilePath";
    @FXML
    private AnchorPane mainPane;
    @FXML
    private JFXSpinner loadingSpinner;
    @FXML
    private JFXButton openSessionButton;
    @FXML
    private JFXButton endSessionButton;
    @FXML
    private Label sessionNameLabel;
    @FXML
    private Label dateLabel;
    @FXML
    private Label logPathLabel;
    @FXML
    private Pane cropControlsContainer;
    @FXML
    private JFXToggleButton showTrimsButton;
    @FXML
    private JFXButton startTrimToCurrentButton;
    @FXML
    private JFXButton endTrimToCurrentButton;
    @FXML
    private JFXButton resetTrimsButton;
    @FXML
    private JFXButton cropAndExportButton;
    @FXML
    private JFXComboBox<OutputFormat> outputFormatComboxBox;
    @FXML
    private CropSlider logPositionSlider;
    @FXML
    private Pane cropProgressMonitorPane;
    @FXML
    private TitledPane thumbnailsTitledPane;
    @FXML
    private FlowPane videoThumbnailPane;
    private final ObjectProperty<MultiVideoViewer> multiVideoViewerProperty = new SimpleObjectProperty((Object)this, "multiVideoThumbnailViewer", null);
    private final ObjectProperty<LogSession> activeSessionProperty = new SimpleObjectProperty((Object)this, "activeSession", null);
    private final ObjectProperty<YoVariableLogCropper> logCropperProperty = new SimpleObjectProperty((Object)this, "logCropper", null);
    private BackgroundExecutorManager backgroundExecutorManager;
    private Stage stage;
    private SessionVisualizerTopics topics;
    private JavaFXMessager messager;

    @Override
    public void initialize(SessionVisualizerToolkit toolkit) {
        this.stage = new Stage();
        this.topics = toolkit.getTopics();
        this.messager = toolkit.getMessager();
        this.backgroundExecutorManager = toolkit.getBackgroundExecutorManager();
        this.logPositionSlider.setValueFactory(param -> new TimeStringBinding(param.valueProperty(), position -> {
            if (this.activeSessionProperty.get() == null) {
                return 0L;
            }
            LogDataReader logDataReader = ((LogSession)this.activeSessionProperty.get()).getLogDataReader();
            return logDataReader.getRelativeTimestamp(position.intValue());
        }));
        ChangeListener activeSessionListener = (o, oldValue, newValue) -> {
            if (oldValue != null) {
                LogDataReader logDataReader = oldValue.getLogDataReader();
                logDataReader.getTimestamp().removeListeners();
            }
            if (newValue == null) {
                this.sessionNameLabel.setText("N/D");
                this.dateLabel.setText("N/D");
                this.logPathLabel.setText("N/D");
                this.endSessionButton.setDisable(true);
                this.logPositionSlider.setDisable(true);
                this.showTrimsButton.setSelected(false);
                this.cropControlsContainer.setDisable(true);
                this.multiVideoViewerProperty.set(null);
                this.logCropperProperty.set(null);
            } else {
                this.messager.submitMessage(this.topics.getStartNewSessionRequest(), newValue);
                File logDirectory = newValue.getLogDirectory();
                LogDataReader logDataReader = newValue.getLogDataReader();
                LogPropertiesReader logProperties = newValue.getLogProperties();
                this.sessionNameLabel.setText(newValue.getSessionName());
                this.dateLabel.setText(LogSessionManagerController.getDate((LogProperties)logProperties));
                this.logPathLabel.setText(logDirectory.getAbsolutePath());
                this.endSessionButton.setDisable(false);
                this.logPositionSlider.setDisable(false);
                this.logPositionSlider.setValue(0.0);
                this.logPositionSlider.setMin(0.0);
                this.logPositionSlider.setMax(logDataReader.getNumberOfEntries() - 1);
                this.cropControlsContainer.setDisable(false);
                MultiVideoDataReader multiReader = new MultiVideoDataReader(logDirectory, (LogProperties)logProperties, this.backgroundExecutorManager);
                multiReader.readVideoFrameNow(logDataReader.getTimestamp().getLongValue());
                logDataReader.getTimestamp().addListener(v -> multiReader.readVideoFrameInBackground(v.getValueAsLongBits()));
                this.multiVideoViewerProperty.set((Object)new MultiVideoViewer((Window)this.stage, (Pane)this.videoThumbnailPane, multiReader, 200.0));
                this.logCropperProperty.set((Object)new YoVariableLogCropper(multiReader, logDirectory, (LogProperties)logProperties));
                boolean logHasVideos = multiReader.getNumberOfVideos() > 0;
                this.thumbnailsTitledPane.setText(logHasVideos ? "Logged videos" : "No video");
                this.thumbnailsTitledPane.setExpanded(logHasVideos);
                this.thumbnailsTitledPane.setDisable(!logHasVideos);
                JavaFXMissingTools.runLater(this.getClass(), () -> this.stage.sizeToScene());
            }
        };
        AtomicBoolean logPositionUpdate = new AtomicBoolean(true);
        this.logPositionSlider.valueProperty().addListener((o, oldValue, newValue) -> {
            LogSession logSession = (LogSession)this.activeSessionProperty.get();
            if (logSession == null || logPositionUpdate.get()) {
                return;
            }
            logSession.submitLogPositionRequest(newValue.intValue());
        });
        AtomicBoolean sliderFeedbackEnabled = new AtomicBoolean(true);
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> sliderFeedbackEnabled.set(false));
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_DRAGGED, e -> sliderFeedbackEnabled.set(false));
        this.logPositionSlider.addEventFilter(MouseEvent.MOUSE_RELEASED, e -> sliderFeedbackEnabled.set(true));
        Consumer<YoBufferPropertiesReadOnly> logPositionUpdateListener = properties -> {
            LogSession logSession = (LogSession)this.activeSessionProperty.get();
            if (sliderFeedbackEnabled.get()) {
                JavaFXMissingTools.runLater(this.getClass(), () -> {
                    if (logSession == null || logSession.getLogDataReader() == null) {
                        return;
                    }
                    logPositionUpdate.set(true);
                    this.logPositionSlider.setValue(logSession.getLogDataReader().getCurrentLogPosition());
                    logPositionUpdate.set(false);
                });
            }
        };
        this.activeSessionProperty.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeCurrentBufferPropertiesListener(logPositionUpdateListener);
            }
            if (newValue != null) {
                newValue.addCurrentBufferPropertiesListener(logPositionUpdateListener);
            }
        });
        this.multiVideoViewerProperty.addListener((o, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.stop();
            }
            if (newValue != null) {
                newValue.start();
            }
        });
        this.activeSessionProperty.addListener(activeSessionListener);
        activeSessionListener.changed(null, null, null);
        this.thumbnailsTitledPane.expandedProperty().addListener((o, oldValue, newValue) -> JavaFXMissingTools.runLater(this.getClass(), () -> ((Stage)this.stage).sizeToScene()));
        this.logPositionSlider.showTrimProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty());
        this.logPositionSlider.showTrimProperty().addListener((o, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.resetTrims();
            }
        });
        this.startTrimToCurrentButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.endTrimToCurrentButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.resetTrimsButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.outputFormatComboxBox.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.cropAndExportButton.disableProperty().bind((ObservableValue)this.showTrimsButton.selectedProperty().not());
        this.cropProgressMonitorPane.getChildren().addListener(c -> {
            c.getList().forEach(node -> JavaFXMissingTools.setAnchorConstraints(node, 0.0));
            this.stage.sizeToScene();
        });
        this.loadingSpinner.visibleProperty().addListener((o, oldValue, newValue) -> this.openSessionButton.setDisable(newValue.booleanValue()));
        this.openSessionButton.setOnAction(e -> this.openLogFile());
        this.endSessionButton.setOnAction(e -> {
            LogSession logSession = (LogSession)this.activeSessionProperty.get();
            if (logSession != null) {
                logSession.shutdownSession();
            }
            this.activeSessionProperty.set(null);
        });
        this.outputFormatComboxBox.setItems(FXCollections.observableArrayList((Object[])OutputFormat.values()));
        this.outputFormatComboxBox.getSelectionModel().select((Object)OutputFormat.Default);
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getDisableUserControls(), m -> {
            this.openSessionButton.setDisable(m.booleanValue());
            this.endSessionButton.setDisable(m.booleanValue());
            this.cropControlsContainer.setDisable(m.booleanValue());
            this.logPositionSlider.setDisable((boolean)m);
        });
        this.stage.setScene(new Scene((Parent)this.mainPane));
        this.stage.setTitle("Log session controls");
        this.stage.getIcons().add((Object)SessionVisualizerIOTools.LOG_SESSION_IMAGE);
        toolkit.getMainWindow().addEventHandler(WindowEvent.WINDOW_CLOSE_REQUEST, e -> {
            if (!e.isConsumed()) {
                this.shutdown();
            }
        });
        this.stage.show();
    }

    public void openLogFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath(LOG_FILE_KEY));
        fileChooser.getExtensionFilters().add((Object)new FileChooser.ExtensionFilter("Log property file", new String[]{"*.log"}));
        fileChooser.setTitle("Choose log directory");
        File result = fileChooser.showOpenDialog((Window)this.stage);
        if (result == null) {
            return;
        }
        this.unloadSession();
        this.setIsLoading(true);
        this.backgroundExecutorManager.executeInBackground(() -> {
            try {
                LogTools.info((String)"Creating log session.");
                LogSession newSession = new LogSession(result.getParentFile(), null);
                LogTools.info((String)"Created log session.");
                JavaFXMissingTools.runLater(this.getClass(), () -> this.activeSessionProperty.set((Object)newSession));
                SessionVisualizerIOTools.setDefaultFilePath(LOG_FILE_KEY, result);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.setIsLoading(false);
            }
        });
    }

    public void setIsLoading(boolean isLoading) {
        this.loadingSpinner.setVisible(isLoading);
    }

    @FXML
    public void resetTrims() {
        this.logPositionSlider.setTrimStartValue(0.0);
        this.logPositionSlider.setTrimEndValue(this.logPositionSlider.getMax());
    }

    @FXML
    public void snapStartTrimToCurrent() {
        this.logPositionSlider.setTrimStartValue(this.logPositionSlider.getValue());
    }

    @FXML
    public void snapEndTrimToCurrent() {
        this.logPositionSlider.setTrimEndValue(this.logPositionSlider.getValue());
    }

    @FXML
    public void cropAndExport() throws IOException {
        YoVariableLogCropper logCropper = (YoVariableLogCropper)((Object)this.logCropperProperty.get());
        if (logCropper == null) {
            return;
        }
        OutputFormat outputFormat = (OutputFormat)((Object)this.outputFormatComboxBox.getSelectionModel().getSelectedItem());
        File destination = switch (outputFormat) {
            case OutputFormat.MATLAB -> SessionVisualizerIOTools.showSaveDialog((Window)this.stage, "Export MATLAB data", new FileChooser.ExtensionFilter("MATLAB File format", new String[]{"*.mat"}), LOG_FILE_KEY);
            default -> {
                DirectoryChooser directoryChooser = new DirectoryChooser();
                directoryChooser.setInitialDirectory(SessionVisualizerIOTools.getDefaultFilePath(LOG_FILE_KEY));
                yield directoryChooser.showDialog((Window)this.stage);
            }
        };
        if (destination == null) {
            return;
        }
        FXMLLoader loader = new FXMLLoader(SessionVisualizerIOTools.LOG_CROP_PROGRESS_PANE_FXML_URL);
        loader.load();
        LogCropProgressController controller = (LogCropProgressController)loader.getController();
        controller.initialize(this.cropProgressMonitorPane);
        this.backgroundExecutorManager.executeInBackground(() -> {
            this.setIsLoading(true);
            this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)true);
            try {
                int from = (int)this.logPositionSlider.getTrimStartValue();
                int to = (int)this.logPositionSlider.getTrimEndValue();
                if (outputFormat == OutputFormat.MATLAB) {
                    logCropper.cropMATLAB(destination, ((LogSession)this.activeSessionProperty.get()).getLogDataReader().getParser().getYoVariablesList(), from, to, controller);
                } else {
                    logCropper.crop(destination, from, to, controller);
                }
            }
            finally {
                this.messager.submitMessage(this.topics.getDisableUserControls(), (Object)false);
                this.setIsLoading(false);
            }
        });
    }

    @Override
    public void shutdown() {
        this.stage.close();
    }

    @Override
    public Stage getStage() {
        return this.stage;
    }

    @Override
    public void unloadSession() {
        if (this.activeSessionProperty.get() != null) {
            ((LogSession)this.activeSessionProperty.get()).shutdownSession();
            this.activeSessionProperty.set(null);
        }
    }

    @Override
    public void notifySessionLoaded() {
        this.setIsLoading(false);
    }

    private static String getDate(LogProperties logProperties) {
        String timestampAsString = logProperties.getTimestampAsString();
        String year = timestampAsString.substring(0, 4);
        String month = timestampAsString.substring(4, 6);
        String day = timestampAsString.substring(6, 8);
        String hour = timestampAsString.substring(9, 11);
        String minute = timestampAsString.substring(11, 13);
        String second = timestampAsString.substring(13, 15);
        return year + "-" + month + "-" + day + " " + hour + ":" + minute + ":" + second;
    }

    private static enum OutputFormat {
        Default,
        MATLAB;

    }

    private static class TimeStringBinding
    extends StringBinding {
        private ObservableLongValue observableNanoTime;

        public <N extends Number> TimeStringBinding(ObservableValue<N> time, ToLongFunction<N> conversionToNano) {
            SimpleLongProperty nanoTimeProperty = new SimpleLongProperty((Object)this, "nanoTime", 0L);
            time.addListener((arg_0, arg_1, arg_2) -> TimeStringBinding.lambda$new$0((LongProperty)nanoTimeProperty, conversionToNano, arg_0, arg_1, arg_2));
            this.observableNanoTime = nanoTimeProperty;
            this.observableNanoTime.addListener((o, oldValue, newValue) -> this.invalidate());
        }

        protected String computeValue() {
            long nanoTime = this.observableNanoTime.get();
            long hours = TimeUnit.NANOSECONDS.toHours(nanoTime);
            long minutes = TimeUnit.NANOSECONDS.toMinutes(nanoTime);
            long seconds = TimeUnit.NANOSECONDS.toSeconds(nanoTime);
            long millis = TimeUnit.NANOSECONDS.toMillis(nanoTime);
            millis -= 1000L * seconds;
            seconds -= 60L * minutes;
            Object time = String.format("%02ds%03d", seconds, millis);
            if ((minutes -= 60L * hours) > 0L || hours > 0L) {
                time = String.format("%02d", minutes) + "m\n" + (String)time;
            }
            if (hours > 0L) {
                time = hours + "h" + (String)time;
            }
            return time;
        }

        private static /* synthetic */ void lambda$new$0(LongProperty nanoTimeProperty, ToLongFunction conversionToNano, ObservableValue o, Number oldValue, Number newValue) {
            nanoTimeProperty.set(conversionToNano.applyAsLong(newValue));
        }
    }
}

