/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.properties;

import java.lang.ref.WeakReference;
import javafx.beans.property.BooleanPropertyBase;
import javafx.beans.property.Property;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoVariableProperty;
import us.ihmc.scs2.sharedMemory.LinkedYoBoolean;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoBooleanProperty
extends BooleanPropertyBase
implements YoVariableProperty<YoBoolean, Boolean> {
    private final YoBoolean yoBoolean;
    private final Object bean;
    private final YoVariableChangedListener propertyUpdater = new YoBooleanPropertyUpdater(this);
    private LinkedYoBoolean linkedBuffer;

    public YoBooleanProperty(YoBoolean yoBoolean) {
        this(yoBoolean, null);
    }

    public YoBooleanProperty(YoBoolean yoBoolean, Object bean) {
        this.yoBoolean = yoBoolean;
        this.bean = bean;
        this.pullYoBooleanValue();
        yoBoolean.addListener(this.propertyUpdater);
    }

    public void setLinkedBuffer(LinkedYoBoolean linkedBuffer) {
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser((Object)this);
        }
        this.linkedBuffer = linkedBuffer;
        if (linkedBuffer != null) {
            linkedBuffer.addUser((Object)this);
            this.pullYoBooleanValue();
        }
    }

    public LinkedYoBoolean getLinkedBuffer() {
        return this.linkedBuffer;
    }

    public void finalize() {
        this.dispose();
    }

    @Override
    public void dispose() {
        this.unbind();
        this.yoBoolean.removeListener(this.propertyUpdater);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.removeUser((Object)this);
        }
    }

    public void set(boolean newValue) {
        super.set(newValue);
        this.yoBoolean.set(newValue);
        if (this.linkedBuffer != null) {
            this.linkedBuffer.push();
        }
    }

    private void pullYoBooleanValue() {
        super.set(this.yoBoolean.getValue());
    }

    public void bindBooleanProperty(Property<Boolean> property) {
        property.setValue((Object)this.getValue());
        MutableBoolean updatingControl = new MutableBoolean(false);
        MutableBoolean updatingThis = new MutableBoolean(false);
        this.addListener((o, oldValue, newValue) -> {
            if (updatingThis.isTrue()) {
                return;
            }
            updatingControl.setTrue();
            property.setValue(newValue);
            updatingControl.setFalse();
        });
        property.addListener((o, oldValue, newValue) -> {
            if (updatingControl.isTrue()) {
                return;
            }
            updatingThis.setTrue();
            this.set((boolean)newValue);
            updatingThis.setFalse();
        });
    }

    @Override
    public YoBoolean getYoVariable() {
        return this.yoBoolean;
    }

    public Object getBean() {
        return this.bean;
    }

    public String getName() {
        return this.yoBoolean.getName();
    }

    private static class YoBooleanPropertyUpdater
    implements YoVariableChangedListener {
        private final WeakReference<YoBooleanProperty> propertyRef;

        public YoBooleanPropertyUpdater(YoBooleanProperty property) {
            this.propertyRef = new WeakReference<YoBooleanProperty>(property);
        }

        public void changed(YoVariable source) {
            YoBooleanProperty property = (YoBooleanProperty)this.propertyRef.get();
            if (property != null) {
                property.pullYoBooleanValue();
            }
        }
    }
}

