/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import us.hebi.matlab.mat.format.Mat5;
import us.hebi.matlab.mat.format.Mat5File;
import us.hebi.matlab.mat.types.Array;
import us.hebi.matlab.mat.types.MatFile;
import us.hebi.matlab.mat.types.Matrix;
import us.hebi.matlab.mat.types.Struct;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.logger.YoVariableLogReader;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.MultiVideoDataReader;
import us.ihmc.yoVariables.registry.YoNamespace;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoEnum;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableLogCropper
extends YoVariableLogReader {
    private final MultiVideoDataReader multiVideoDataReader;

    public YoVariableLogCropper(MultiVideoDataReader multiVideoDataReader, File logDirectory, LogProperties logProperties) {
        super(logDirectory, logProperties);
        this.multiVideoDataReader = multiVideoDataReader;
    }

    public void crop(File destination, int from, int to, ProgressConsumer progressConsumer) {
        progressConsumer.started("Cropping data file");
        progressConsumer.info("Initializing cropper");
        progressConsumer.progress(0.0);
        if (!this.initialize()) {
            return;
        }
        try {
            progressConsumer.info("Creating directories");
            progressConsumer.progress(0.03);
            if (destination.exists()) {
                if (!destination.isDirectory()) {
                    progressConsumer.error("Destination " + destination.getAbsolutePath() + " already exists.");
                    progressConsumer.done();
                    return;
                }
                if (destination.list().length > 0) {
                    progressConsumer.error("Destination " + destination.getAbsolutePath() + " is not empty.");
                    progressConsumer.done();
                    return;
                }
            } else if (!destination.mkdir()) {
                progressConsumer.error("Cannot make directory " + destination.getAbsolutePath());
                progressConsumer.done();
                return;
            }
            progressConsumer.info("Copying description files");
            progressConsumer.progress(0.04);
            this.copyMetaData(destination);
            progressConsumer.info("Seeking variable data");
            progressConsumer.progress(0.1);
            File outputFile = new File(destination, this.logProperties.getVariables().getDataAsString());
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
            FileChannel outputChannel = fileOutputStream.getChannel();
            File indexFile = new File(destination, this.logProperties.getVariables().getIndexAsString());
            FileOutputStream indexStream = new FileOutputStream(indexFile);
            FileChannel indexChannel = indexStream.getChannel();
            progressConsumer.info("Writing variable data");
            ProgressConsumer dataCopyingProgress = this.multiVideoDataReader == null || this.multiVideoDataReader.getNumberOfVideos() == 0 ? progressConsumer.subProgress(0.1, 1.0) : progressConsumer.subProgress(0.1, 0.5);
            ByteBuffer indexBuffer = ByteBuffer.allocateDirect(16);
            for (int i = from; i <= to; ++i) {
                dataCopyingProgress.progress((double)(i - from) / (double)(to - from));
                ByteBuffer compressedData = this.readCompressedData(i);
                indexBuffer.clear();
                indexBuffer.putLong(this.getTimestamp(i));
                indexBuffer.putLong(outputChannel.position());
                indexBuffer.flip();
                indexChannel.write(indexBuffer);
                outputChannel.write(compressedData);
            }
            outputChannel.close();
            fileOutputStream.close();
            indexChannel.close();
            indexStream.close();
            progressConsumer.info("Cropping video files");
            if (this.multiVideoDataReader != null && this.multiVideoDataReader.getNumberOfVideos() > 0) {
                this.multiVideoDataReader.crop(destination, this.getTimestamp(from), this.getTimestamp(to), progressConsumer.subProgress(0.5, 1.0));
            }
            progressConsumer.done();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void cropMATLAB(File destination, List<YoVariable> logVariables, int from, int to, ProgressConsumer progressConsumer) {
        progressConsumer.started("Cropping data file");
        progressConsumer.info("Initializing cropper");
        progressConsumer.progress(0.0);
        if (!this.initialize()) {
            return;
        }
        try {
            progressConsumer.info("Creating directories");
            progressConsumer.progress(0.03);
            if (destination.exists()) {
                progressConsumer.error("Destination " + destination.getAbsolutePath() + " already exists.");
                progressConsumer.done();
                return;
            }
            File parent = destination.getCanonicalFile().getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                progressConsumer.error("Cannot make parent directory for " + destination.getAbsolutePath());
                progressConsumer.done();
                return;
            }
            progressConsumer.info("Seeking variable data");
            progressConsumer.progress(0.04);
            Mat5File matFile = Mat5.newMatFile();
            Struct rootStruct = Mat5.newStruct();
            YoRegistry rootRegistry = logVariables.get(0).getRegistry().getRoot();
            matFile.addArray(rootRegistry.getName(), (Array)rootStruct);
            int dataLength = to - from + 1;
            ArrayList<MatlabEntryWriter> matlabEntryWriters = new ArrayList<MatlabEntryWriter>(logVariables.size());
            progressConsumer.info("Creating data structure");
            ProgressConsumer structSetupProgress = progressConsumer.subProgress(0.04, 0.2);
            for (int varIndex = 0; varIndex < logVariables.size(); ++varIndex) {
                structSetupProgress.progress((double)varIndex / ((double)logVariables.size() - 1.0));
                Struct parentStruct = rootStruct;
                YoVariable yoVariable = logVariables.get(varIndex);
                if (yoVariable.getRegistry() != rootRegistry) {
                    YoNamespace parentNamespace = yoVariable.getNamespace();
                    for (int i = 1; i < parentNamespace.size(); ++i) {
                        Struct childStruct;
                        String subName = (String)parentNamespace.getSubNames().get(i);
                        try {
                            childStruct = parentStruct.getStruct(subName);
                        }
                        catch (IllegalArgumentException e) {
                            childStruct = Mat5.newStruct();
                            parentStruct.set(subName, (Array)childStruct);
                        }
                        parentStruct = childStruct;
                    }
                }
                Matrix matMatrix = Mat5.newMatrix((int)dataLength, (int)1);
                matlabEntryWriters.add(YoVariableLogCropper.createMatlabEntryWriter(yoVariable, matMatrix));
                parentStruct.set(yoVariable.getName(), (Array)matMatrix);
            }
            progressConsumer.info("Writing variable data");
            ProgressConsumer dataCopyingProgress = progressConsumer.subProgress(0.2, 1.0);
            for (int i = from; i <= to; ++i) {
                dataCopyingProgress.progress((double)(i - from) / (double)(to - from));
                LongBuffer data = this.readData(i).asLongBuffer();
                data.get();
                for (int varIndex = 0; varIndex < logVariables.size(); ++varIndex) {
                    ((MatlabEntryWriter)matlabEntryWriters.get(varIndex)).accpet(i, data.get());
                }
            }
            Mat5.writeToFile((MatFile)matFile, (File)destination);
            rootStruct.close();
            progressConsumer.done();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static MatlabEntryWriter createMatlabEntryWriter(YoVariable variable, Matrix matrix) {
        if (variable instanceof YoBoolean) {
            return (index, longValue) -> matrix.setBoolean(index, longValue == 1L);
        }
        if (variable instanceof YoDouble) {
            return (index, longValue) -> matrix.setDouble(index, Double.longBitsToDouble(longValue));
        }
        if (variable instanceof YoInteger) {
            return (index, longValue) -> matrix.setInt(index, (int)longValue);
        }
        if (variable instanceof YoLong) {
            return (index, longValue) -> matrix.setLong(index, longValue);
        }
        if (variable instanceof YoEnum) {
            return (index, longValue) -> matrix.setByte(index, (byte)longValue);
        }
        throw new IllegalArgumentException("Unsupported variable type: " + variable);
    }

    private static interface MatlabEntryWriter {
        public void accpet(int var1, long var2);
    }
}

