/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import gnu.trove.list.array.TLongArrayList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import javafx.scene.image.WritableImage;
import org.apache.commons.lang3.mutable.MutableObject;
import us.ihmc.codecs.demuxer.MP4VideoDemuxer;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.concurrent.ConcurrentCopier;
import us.ihmc.robotDataLogger.Camera;
import us.ihmc.scs2.session.log.ProgressConsumer;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.JavaFXPictureConverter;
import us.ihmc.scs2.sessionVisualizer.jfx.session.log.VideoConverter;

public class VideoDataReader {
    private final String name;
    private final boolean hasTimebase;
    private final boolean interlaced;
    private long[] robotTimestamps;
    private long[] videoTimestamps;
    private long bmdTimeBaseNum;
    private long bmdTimeBaseDen;
    private final MP4VideoDemuxer demuxer;
    private final JavaFXPictureConverter converter = new JavaFXPictureConverter();
    private int currentlyShowingIndex = 0;
    private long currentlyShowingRobotTimestamp = 0L;
    private long upcomingRobotTimestamp = 0L;
    private final File videoFile;
    private final Camera camera;
    private final ConcurrentCopier<MutableObject<WritableImage>> imageBuffer = new ConcurrentCopier(MutableObject::new);

    public VideoDataReader(Camera camera, File dataDirectory, boolean hasTimeBase) throws IOException {
        this.camera = camera;
        this.name = camera.getNameAsString();
        this.interlaced = camera.getInterlaced();
        this.hasTimebase = hasTimeBase;
        if (!this.hasTimebase) {
            System.err.println("Video data is using timestamps instead of frame numbers. Falling back to seeking based on timestamp.");
        }
        this.videoFile = new File(dataDirectory, camera.getVideoFileAsString());
        if (!this.videoFile.exists()) {
            throw new IOException("Cannot find video: " + this.videoFile);
        }
        File timestampFile = new File(dataDirectory, camera.getTimestampFileAsString());
        this.parseTimestampData(timestampFile);
        this.demuxer = new MP4VideoDemuxer(this.videoFile);
    }

    public void readVideoFrame(long timestamp) {
        long videoTimestamp;
        if (timestamp >= this.currentlyShowingRobotTimestamp && timestamp < this.upcomingRobotTimestamp) {
            return;
        }
        long previousTimestamp = this.videoTimestamps[this.currentlyShowingIndex];
        if (this.robotTimestamps.length > this.currentlyShowingIndex + 1 && this.robotTimestamps[this.currentlyShowingIndex + 1] == timestamp) {
            ++this.currentlyShowingIndex;
            videoTimestamp = this.videoTimestamps[this.currentlyShowingIndex];
            this.currentlyShowingRobotTimestamp = this.robotTimestamps[this.currentlyShowingIndex];
        } else {
            videoTimestamp = this.getVideoTimestamp(timestamp);
        }
        this.upcomingRobotTimestamp = this.currentlyShowingIndex + 1 < this.robotTimestamps.length ? this.robotTimestamps[this.currentlyShowingIndex + 1] : this.currentlyShowingRobotTimestamp;
        if (previousTimestamp == videoTimestamp) {
            return;
        }
        try {
            this.demuxer.seekToPTS(videoTimestamp);
            YUVPicture nextFrame = this.demuxer.getNextFrame();
            MutableObject copyForWriting = (MutableObject)this.imageBuffer.getCopyForWriting();
            copyForWriting.setValue((Object)this.converter.toFXImage(nextFrame, (WritableImage)copyForWriting.getValue()));
            this.imageBuffer.commit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private long getVideoTimestamp(long timestamp) {
        this.currentlyShowingIndex = Arrays.binarySearch(this.robotTimestamps, timestamp);
        if (this.currentlyShowingIndex < 0) {
            int nextIndex = -this.currentlyShowingIndex + 1;
            this.currentlyShowingIndex = nextIndex < this.robotTimestamps.length && Math.abs(this.robotTimestamps[-this.currentlyShowingIndex] - timestamp) > Math.abs(this.robotTimestamps[nextIndex]) ? nextIndex : -this.currentlyShowingIndex;
        }
        if (this.currentlyShowingIndex < 0) {
            this.currentlyShowingIndex = 0;
        }
        if (this.currentlyShowingIndex >= this.robotTimestamps.length) {
            this.currentlyShowingIndex = this.robotTimestamps.length - 1;
        }
        this.currentlyShowingRobotTimestamp = this.robotTimestamps[this.currentlyShowingIndex];
        long videoTimestamp = this.videoTimestamps[this.currentlyShowingIndex];
        if (this.hasTimebase) {
            videoTimestamp = videoTimestamp * this.bmdTimeBaseNum * this.demuxer.getTimescale() / this.bmdTimeBaseDen;
        }
        return videoTimestamp;
    }

    private void parseTimestampData(File timestampFile) throws IOException {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(timestampFile));
            if (this.hasTimebase) {
                line = reader.readLine();
                if (line == null) {
                    throw new IOException("Cannot read numerator");
                }
                this.bmdTimeBaseNum = Long.valueOf(line);
                line = reader.readLine();
                if (line != null) {
                    this.bmdTimeBaseDen = Long.valueOf(line);
                } else {
                    throw new IOException("Cannot read denumerator");
                }
            }
            TLongArrayList robotTimestamps = new TLongArrayList();
            TLongArrayList videoTimestamps = new TLongArrayList();
            while ((line = reader.readLine()) != null) {
                String[] stamps = line.split("\\s");
                long robotStamp = Long.valueOf(stamps[0]);
                long videoStamp = Long.valueOf(stamps[1]);
                if (this.interlaced) {
                    videoStamp /= 2L;
                }
                robotTimestamps.add(robotStamp);
                videoTimestamps.add(videoStamp);
            }
            this.robotTimestamps = robotTimestamps.toArray();
            this.videoTimestamps = videoTimestamps.toArray();
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void exportVideo(File selectedFile, long startTimestamp, long endTimestamp, ProgressConsumer progreesConsumer) {
        long startVideoTimestamp = this.getVideoTimestamp(startTimestamp);
        long endVideoTimestamp = this.getVideoTimestamp(endTimestamp);
        try {
            VideoConverter.convert(this.videoFile, selectedFile, startVideoTimestamp, endVideoTimestamp, progreesConsumer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cropVideo(File outputFile, File timestampFile, long startTimestamp, long endTimestamp, ProgressConsumer monitor) throws IOException {
        long startVideoTimestamp = this.getVideoTimestamp(startTimestamp);
        long endVideoTimestamp = this.getVideoTimestamp(endTimestamp);
        int framerate = VideoConverter.crop(this.videoFile, outputFile, startVideoTimestamp, endVideoTimestamp, monitor);
        PrintWriter timestampWriter = new PrintWriter(timestampFile);
        timestampWriter.println(1);
        timestampWriter.println(framerate);
        long pts = 0L;
        for (int i = 0; i < this.robotTimestamps.length; ++i) {
            long robotTimestamp = this.robotTimestamps[i];
            if (robotTimestamp >= startTimestamp && robotTimestamp <= endTimestamp) {
                timestampWriter.print(robotTimestamp);
                timestampWriter.print(" ");
                timestampWriter.println(pts);
                ++pts;
                continue;
            }
            if (robotTimestamp > endTimestamp) break;
        }
        timestampWriter.close();
    }

    public String getName() {
        return this.name;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public WritableImage pollCurrentFrame() {
        MutableObject copyForReading = (MutableObject)this.imageBuffer.getCopyForReading();
        if (copyForReading == null) {
            return null;
        }
        return (WritableImage)copyForReading.getValue();
    }
}

