/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.managers;

import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.MainViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SecondaryViewport3DManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SingleViewport3DManager;
import us.ihmc.yoVariables.exceptions.IllegalOperationException;

public class MultiViewport3DManager {
    private final GridPane container;
    private final Group mainView3DRoot;
    private MainViewport3DManager mainViewport;
    private final ObservableList<SingleViewport3DManager> allViewports = FXCollections.observableArrayList();
    private final IntegerProperty numberOfColumns = new SimpleIntegerProperty((Object)this, "numberOfColumns", 2);

    public MultiViewport3DManager(Group mainView3DRoot) {
        this.mainView3DRoot = mainView3DRoot;
        this.container = new GridPane();
        this.allViewports.addListener(change -> this.refreshLayout());
        this.numberOfColumns.addListener((o, oldValue, newValue) -> this.refreshLayout());
    }

    public void refreshLayout() {
        this.container.getChildren().clear();
        int numCols = this.numberOfColumns.get();
        int col = 0;
        int row = 0;
        for (int i = 0; i < this.allViewports.size(); ++i) {
            Pane pane = ((SingleViewport3DManager)this.allViewports.get(i)).getPane();
            this.container.add((Node)pane, col, row);
            GridPane.setHgrow((Node)pane, (Priority)Priority.SOMETIMES);
            GridPane.setVgrow((Node)pane, (Priority)Priority.SOMETIMES);
            if (++col < numCols) continue;
            col = 0;
            ++row;
        }
    }

    public void createMainViewport() {
        if (this.mainViewport != null) {
            throw new IllegalOperationException("Can only have 1 main viewport");
        }
        this.mainViewport = new MainViewport3DManager(this.mainView3DRoot);
        this.allViewports.add((Object)this.mainViewport);
    }

    public void addSecondaryViewport() {
        this.allViewports.add((Object)new SecondaryViewport3DManager(this.mainView3DRoot));
    }

    public MainViewport3DManager getMainViewport() {
        return this.mainViewport;
    }

    public Pane getPane() {
        return this.container;
    }

    public void dispose() {
        this.allViewports.forEach(viewport -> viewport.dispose());
        this.allViewports.clear();
    }
}

