/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard;

import com.jfoenix.controls.JFXSpinner;
import com.jfoenix.controls.JFXTextField;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Slider;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.LongStringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.scs2.definition.yoSlider.YoKnobDefinition;
import us.ihmc.scs2.definition.yoSlider.YoSliderDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.sliderboard.YoVariableSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.properties.YoLongProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sessionVisualizer.sliderboard.SliderboardVariable;
import us.ihmc.scs2.sharedMemory.LinkedYoLong;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.yoVariables.variable.YoLong;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoLongSlider
implements YoVariableSlider {
    private final YoLongProperty yoLongProperty;
    private final LongProperty minProperty = new SimpleLongProperty((Object)this, "min", 0L);
    private final LongProperty maxProperty = new SimpleLongProperty((Object)this, "max", 1L);
    private final List<Runnable> cleanupTasks = new ArrayList<Runnable>();

    public YoLongSlider(YoLong yoLong, LinkedYoRegistry linkedYoRegistry) {
        this.yoLongProperty = new YoLongProperty(yoLong, this);
        this.yoLongProperty.setLinkedBuffer((LinkedYoLong)linkedYoRegistry.linkYoVariable((YoVariable)yoLong));
    }

    @Override
    public void bindMinTextField(JFXTextField minTextField) {
        TextFormatter minTextFormatter = new TextFormatter((StringConverter)new LongStringConverter());
        minTextFormatter.setValue((Object)(this.yoLongProperty.get() - 1L));
        minTextField.setTextFormatter(minTextFormatter);
        this.minProperty.bind((ObservableValue)minTextFormatter.valueProperty());
        minTextField.setDisable(false);
        this.cleanupTasks.add(() -> {
            this.minProperty.unbind();
            minTextField.setDisable(true);
        });
    }

    @Override
    public void bindMaxTextField(JFXTextField maxTextField) {
        TextFormatter maxTextFormatter = new TextFormatter((StringConverter)new LongStringConverter());
        maxTextFormatter.setValue((Object)(this.yoLongProperty.get() + 1L));
        maxTextField.setTextFormatter(maxTextFormatter);
        this.maxProperty.bind((ObservableValue)maxTextFormatter.valueProperty());
        maxTextField.setDisable(false);
        this.cleanupTasks.add(() -> {
            this.maxProperty.unbind();
            maxTextField.setDisable(true);
        });
    }

    @Override
    public void bindVirtualSlider(Slider virtualSlider) {
        virtualSlider.minProperty().bind((ObservableValue)this.minProperty);
        virtualSlider.maxProperty().bind((ObservableValue)this.maxProperty);
        ChangeListener majorTickUnitUpdater = (o, oldValue, newValue) -> {
            double range = this.maxProperty.get() - this.minProperty.get();
            if (range <= 0.0) {
                return;
            }
            virtualSlider.setMajorTickUnit((double)Math.max(1L, Math.round(range / 25.0)));
        };
        this.minProperty.addListener(majorTickUnitUpdater);
        this.maxProperty.addListener(majorTickUnitUpdater);
        MutableBoolean updating = new MutableBoolean(false);
        virtualSlider.setValue((double)this.yoLongProperty.get());
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            updating.setTrue();
            virtualSlider.valueProperty().set((double)this.yoLongProperty.get());
            updating.setFalse();
        };
        ChangeListener yoIntegerUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoLongProperty.setAndPush(virtualSlider.valueProperty().getValue().longValue());
                updating.setFalse();
            });
        };
        this.yoLongProperty.addListener(sliderUpdater);
        virtualSlider.valueProperty().addListener(yoIntegerUpdater);
        this.cleanupTasks.add(() -> {
            this.yoLongProperty.removeListener(sliderUpdater);
            this.minProperty.removeListener(majorTickUnitUpdater);
            this.maxProperty.removeListener(majorTickUnitUpdater);
            virtualSlider.valueProperty().removeListener(yoIntegerUpdater);
            virtualSlider.minProperty().unbind();
            virtualSlider.maxProperty().unbind();
        });
    }

    @Override
    public void bindVirtualKnob(JFXSpinner virtualKnob) {
        ChangeListener knobUpdater = (o, oldValue, newValue) -> {
            double value = (this.yoLongProperty.doubleValue() - this.minProperty.doubleValue()) / (this.maxProperty.doubleValue() - this.minProperty.doubleValue());
            virtualKnob.setProgress(value);
        };
        knobUpdater.changed(null, null, null);
        this.yoLongProperty.addListener(knobUpdater);
        this.minProperty.addListener(knobUpdater);
        this.maxProperty.addListener(knobUpdater);
        this.cleanupTasks.add(() -> {
            this.yoLongProperty.removeListener(knobUpdater);
            this.minProperty.removeListener(knobUpdater);
            this.maxProperty.removeListener(knobUpdater);
        });
    }

    @Override
    public void bindSliderVariable(SliderboardVariable sliderVariable) {
        MutableBoolean updating = new MutableBoolean(false);
        if (!this.minProperty.isBound()) {
            this.minProperty.set(this.yoLongProperty.get() - 1L);
        }
        if (!this.maxProperty.isBound()) {
            this.maxProperty.set(this.yoLongProperty.get() + 1L);
        }
        sliderVariable.setValue(SliderboardVariable.longToInt((long)this.yoLongProperty.get(), (double)this.minProperty.get(), (double)this.maxProperty.get(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax()));
        ChangeListener sliderUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            int sliderPosition = SliderboardVariable.longToInt((long)this.yoLongProperty.get(), (double)this.minProperty.get(), (double)this.maxProperty.get(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax());
            updating.setTrue();
            sliderVariable.setValue(sliderPosition);
            updating.setFalse();
        };
        ChangeListener yoLongUpdater = (o, oldValue, newValue) -> {
            if (updating.isTrue()) {
                return;
            }
            Long yoLongValue = SliderboardVariable.intToLong((int)newValue.intValue(), (int)sliderVariable.getMin(), (int)sliderVariable.getMax(), (long)this.minProperty.get(), (long)this.maxProperty.get());
            JavaFXMissingTools.runLater(this.getClass(), () -> {
                updating.setTrue();
                this.yoLongProperty.setAndPush(yoLongValue);
                updating.setFalse();
            });
        };
        this.yoLongProperty.addListener(sliderUpdater);
        this.minProperty.addListener(sliderUpdater);
        this.maxProperty.addListener(sliderUpdater);
        sliderVariable.valueProperty().addListener(yoLongUpdater);
        this.cleanupTasks.add(() -> {
            this.yoLongProperty.removeListener(sliderUpdater);
            this.minProperty.removeListener(sliderUpdater);
            this.maxProperty.removeListener(sliderUpdater);
            sliderVariable.valueProperty().removeListener(yoLongUpdater);
        });
    }

    public YoLong getYoVariable() {
        return this.yoLongProperty.getYoVariable();
    }

    @Override
    public YoSliderDefinition toYoSliderDefinition() {
        YoSliderDefinition definition = new YoSliderDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        definition.setMinValue(this.minProperty.getValue().toString());
        definition.setMaxValue(this.maxProperty.getValue().toString());
        return definition;
    }

    @Override
    public YoKnobDefinition toYoKnobDefinition() {
        YoKnobDefinition definition = new YoKnobDefinition();
        definition.setVariableName(this.getYoVariable().getFullNameString());
        definition.setMinValue(this.minProperty.getValue().toString());
        definition.setMaxValue(this.maxProperty.getValue().toString());
        return definition;
    }

    @Override
    public void dispose() {
        this.yoLongProperty.finalize();
        this.cleanupTasks.forEach(Runnable::run);
    }
}

