/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.paint.Color;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXCreatorController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoCompositeEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoGraphic3DStyleEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.YoGraphicNameEditorPaneController;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.editor.yoTextField.YoDoubleTextField;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.group.YoGroupFXEditorTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX2D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;

public abstract class YoGroupFXEditorController<T extends YoGraphicFX>
implements YoGraphicFXCreatorController<YoGroupFX> {
    protected YoGroupFX yoGraphicToEdit;
    protected final ObservableList<T> graphicChildren = FXCollections.observableArrayList();
    protected YoCompositeSearchManager yoCompositeSearchManager;
    protected BooleanProperty hasChangesPendingProperty = new SimpleBooleanProperty((Object)this, "hasChangesPending", false);
    private SessionVisualizerToolkit toolkit;
    private final List<Runnable> resetActions = new ArrayList<Runnable>();

    @Override
    public void initialize(SessionVisualizerToolkit toolkit, YoGroupFX yoGraphicToEdit) {
        this.toolkit = toolkit;
        this.yoGraphicToEdit = yoGraphicToEdit;
        this.yoCompositeSearchManager = toolkit.getYoCompositeSearchManager();
        Class<T> childrenCommonType = this.getChildrenCommonType();
        Object yoGraphicFXSet = YoGraphicFX2D.class.isAssignableFrom(childrenCommonType) ? yoGraphicToEdit.getYoGraphicFX2DSet() : yoGraphicToEdit.getYoGraphicFX3DSet();
        this.graphicChildren.setAll((Collection)yoGraphicFXSet.stream().filter(childrenCommonType::isInstance).map(childrenCommonType::cast).collect(Collectors.toList()));
        yoGraphicFXSet.addListener(change -> {
            if (change.wasRemoved() && childrenCommonType.isInstance(change.getElementRemoved())) {
                this.graphicChildren.remove(change.getElementRemoved());
            }
            if (change.wasAdded() && childrenCommonType.isInstance(change.getElementAdded())) {
                this.graphicChildren.remove(change.getElementAdded());
            }
        });
    }

    protected void setupNameEditor(YoGraphicNameEditorPaneController nameEditorController) {
        nameEditorController.initialize(this.toolkit, this.yoGraphicToEdit);
        nameEditorController.getNameLabel().setText("Group name");
        nameEditorController.bindYoGraphicFXItem(this.yoGraphicToEdit);
        this.registerResetAction(() -> nameEditorController.setInput(this.yoGraphicToEdit.getName(), this.yoGraphicToEdit.getNamespace()));
    }

    protected void setupStyleEditor(YoGraphic3DStyleEditorPaneController styleEditorController) {
        if (!YoGraphicFX3D.class.isAssignableFrom(this.getChildrenCommonType())) {
            throw new IllegalStateException("Cannot setup the 3D style editor for " + this.getChildrenCommonType().getSimpleName());
        }
        styleEditorController.initialize(this.toolkit);
        styleEditorController.colorProperty().addListener((o, oldValue, newValue) -> YoGroupFXEditorTools.setField(this.graphicChildren, (g, c) -> ((YoGraphicFX3D)g).setColor((Color)c), newValue));
        this.registerResetAction(() -> {
            Color initialColor = YoGroupFXEditorTools.getCommonValue(YoGroupFXEditorTools.getField(this.graphicChildren, g -> ((YoGraphicFX3D)g).getColor().get()));
            if (initialColor != null) {
                styleEditorController.setInput(initialColor);
            }
        });
    }

    protected YoDoubleTextField setupDoublePropertyEditor(TextField textField, ImageView validImageView, BiConsumer<T, DoubleProperty> setter, Function<T, DoubleProperty> getter) {
        LinkedYoRegistry linkedRootRegistry = this.toolkit.getYoManager().getLinkedRootRegistry();
        YoDoubleTextField yoDoubleTextField = new YoDoubleTextField(textField, this.yoCompositeSearchManager, linkedRootRegistry, validImageView);
        yoDoubleTextField.setupAutoCompletion();
        yoDoubleTextField.supplierProperty().addListener((o, oldValue, newValue) -> YoGroupFXEditorTools.setField(this.graphicChildren, setter, newValue));
        this.registerResetAction(() -> textField.setText(YoGroupFXEditorTools.getCommonString(this.yoCompositeSearchManager, YoGroupFXEditorTools.getField(this.graphicChildren, getter))));
        return yoDoubleTextField;
    }

    protected void setupTuple3DEditor(YoCompositeEditorPaneController tuple3DEditorController, boolean setupReferenceFrameFields, String entryName, BiConsumer<T, Tuple3DProperty> setter, Function<T, Tuple3DProperty> getter) {
        tuple3DEditorController.initialize(this.toolkit, this.yoCompositeSearchManager.getYoTuple3DCollection(), setupReferenceFrameFields);
        tuple3DEditorController.setCompositeName(entryName);
        this.registerResetAction(() -> {
            Tuple3DProperty commonTuple3DProperty = YoGroupFXEditorTools.getCommonTuple3DProperty(this.yoCompositeSearchManager, YoGroupFXEditorTools.getField(this.graphicChildren, getter));
            if (commonTuple3DProperty != null) {
                tuple3DEditorController.setInput(commonTuple3DProperty);
            }
        });
        if (setupReferenceFrameFields) {
            tuple3DEditorController.addInputListener((components, frame) -> {
                Tuple3DProperty newValue = new Tuple3DProperty((Property<ReferenceFrame>)frame, (DoubleProperty[])components);
                YoGroupFXEditorTools.setField(this.graphicChildren, setter, newValue);
            });
        } else {
            tuple3DEditorController.addInputListener(components -> {
                Tuple3DProperty newValue = new Tuple3DProperty((DoubleProperty[])components);
                YoGroupFXEditorTools.setField(this.graphicChildren, setter, newValue);
            });
        }
    }

    @Override
    public void resetFields() {
        this.resetActions.forEach(Runnable::run);
    }

    protected void registerResetAction(Runnable resetAction) {
        this.resetActions.add(resetAction);
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public ReadOnlyBooleanProperty hasChangesPendingProperty() {
        return this.hasChangesPendingProperty;
    }

    @Override
    public YoGroupFX getYoGraphicFX() {
        return this.yoGraphicToEdit;
    }

    public abstract Class<T> getChildrenCommonType();
}

