/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Mesh;
import javafx.scene.shape.MeshView;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.javaFXToolkit.JavaFXTools;
import us.ihmc.scs2.definition.visual.TriangleMesh3DFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.definition.JavaFXTriangleMesh3DDefinitionInterpreter;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.Tuple3DProperty;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFX3D;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;

public class YoCapsuleFX3D
extends YoGraphicFX3D {
    private Tuple3DProperty center = new Tuple3DProperty(null, 0.0, 0.0, 0.0);
    private Tuple3DProperty axis = new Tuple3DProperty(null, 0.0, 0.0, 1.0);
    private DoubleProperty length = new SimpleDoubleProperty(0.3);
    private DoubleProperty radius = new SimpleDoubleProperty(0.05);
    private final PhongMaterial material = new PhongMaterial();
    private final MeshView capsuleNode = new MeshView();
    private final Translate translate = new Translate();
    private final Rotate rotate = new Rotate();
    private CapsuleData newData = null;
    private CapsuleData oldData = null;
    private Mesh newMesh = null;
    private boolean clearMesh = false;

    public YoCapsuleFX3D() {
        this.capsuleNode.setMaterial((Material)this.material);
        this.capsuleNode.getTransforms().addAll((Object[])new Transform[]{this.translate, this.rotate});
        this.capsuleNode.idProperty().bind((ObservableValue)this.nameProperty());
    }

    public YoCapsuleFX3D(ReferenceFrame worldFrame) {
        this();
        this.center.setReferenceFrame(worldFrame);
        this.axis.setReferenceFrame(worldFrame);
    }

    @Override
    public void render() {
        this.newData = YoCapsuleFX3D.newCapsuleData(this.length, this.radius);
        if (this.color == null) {
            this.color = () -> null;
        }
        this.material.setDiffuseColor((Color)this.color.get());
        if (this.translate != null) {
            Point3D centerInWorld = this.center.toPoint3DInWorld();
            this.translate.setX(centerInWorld.getX());
            this.translate.setY(centerInWorld.getY());
            this.translate.setZ(centerInWorld.getZ());
        }
        if (this.axis != null) {
            AxisAngle axisAngle = EuclidGeometryTools.axisAngleFromZUpToVector3D((Vector3DReadOnly)this.axis.toVector3DInWorld());
            axisAngle.setAngle(Math.toDegrees(axisAngle.getAngle()));
            JavaFXTools.convertAxisAngleToRotate((AxisAngleReadOnly)axisAngle, (Rotate)this.rotate);
        }
        if (this.clearMesh) {
            this.clearMesh = false;
            this.capsuleNode.setMesh(null);
        }
        if (this.newMesh != null) {
            this.capsuleNode.setMesh(this.newMesh);
            this.newMesh = null;
        }
    }

    @Override
    public void computeBackground() {
        CapsuleData newDataLocal = this.newData;
        this.newData = null;
        if (newDataLocal == null) {
            return;
        }
        if (newDataLocal.containsNaN() || EuclidCoreTools.isZero((double)newDataLocal.radius, (double)1.0E-5)) {
            this.clearMesh = true;
            return;
        }
        if (newDataLocal.equals(this.oldData)) {
            return;
        }
        this.newMesh = JavaFXTriangleMesh3DDefinitionInterpreter.interpretDefinition(TriangleMesh3DFactories.Capsule((double)newDataLocal.length, (double)newDataLocal.radius, (double)newDataLocal.radius, (double)newDataLocal.radius, (int)32, (int)32));
        this.oldData = newDataLocal;
    }

    private static CapsuleData newCapsuleData(DoubleProperty length, DoubleProperty radius) {
        CapsuleData data = new CapsuleData();
        if (YoGraphicTools.isAnyNull(length, radius)) {
            return data;
        }
        data.length = length.get();
        data.radius = radius.get();
        return data;
    }

    public void setCenter(Tuple3DProperty center) {
        this.center = center;
    }

    public void setAxis(Tuple3DProperty axis) {
        this.axis = axis;
    }

    public void setLength(DoubleProperty length) {
        this.length = length;
    }

    public void setLength(double length) {
        this.length = new SimpleDoubleProperty(length);
    }

    public void setRadius(DoubleProperty radius) {
        this.radius = radius;
    }

    public void setRadius(double radius) {
        this.radius = new SimpleDoubleProperty(radius);
    }

    @Override
    public void clear() {
        this.center = null;
        this.axis = null;
        this.length = null;
        this.radius = null;
        this.color = null;
    }

    @Override
    public YoCapsuleFX3D clone() {
        YoCapsuleFX3D clone = new YoCapsuleFX3D();
        clone.setName(this.getName());
        clone.setCenter(new Tuple3DProperty(this.center));
        clone.setAxis(new Tuple3DProperty(this.axis));
        clone.setLength(this.length);
        clone.setRadius(this.radius);
        clone.setColor(this.color);
        return clone;
    }

    public Tuple3DProperty getCenter() {
        return this.center;
    }

    public Tuple3DProperty getAxis() {
        return this.axis;
    }

    public DoubleProperty getLength() {
        return this.length;
    }

    public DoubleProperty getRadius() {
        return this.radius;
    }

    @Override
    public Node getNode() {
        return this.capsuleNode;
    }

    private static class CapsuleData {
        private double length;
        private double radius;

        private CapsuleData() {
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof CapsuleData) {
                CapsuleData other = (CapsuleData)object;
                if (this.length != other.length) {
                    return false;
                }
                return this.radius == other.radius;
            }
            return false;
        }

        public boolean containsNaN() {
            return Double.isNaN(this.length) || Double.isNaN(this.radius);
        }
    }
}

