/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleablePropertyFactory;
import javafx.scene.shape.Polygon;

public class TrimPolygonMarker
extends Polygon {
    private static final StyleablePropertyFactory<TrimPolygonMarker> FACTORY = new StyleablePropertyFactory(TrimPolygonMarker.getClassCssMetaData());
    private static final CssMetaData<TrimPolygonMarker, Number> MARKER_WIDTH = FACTORY.createSizeCssMetaData("-fx-marker-width", s -> s.markerWidth, (Number)1.0, false);
    private static final CssMetaData<TrimPolygonMarker, Number> MARKER_HEIGHT = FACTORY.createSizeCssMetaData("-fx-marker-height", s -> s.markerHeight, (Number)1.0, false);
    private final StyleableDoubleProperty markerWidth = new StyleableDoubleProperty(1.0){

        public String getName() {
            return "markerWidth";
        }

        public Object getBean() {
            return TrimPolygonMarker.this;
        }

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return MARKER_WIDTH;
        }
    };
    private final StyleableDoubleProperty markerHeight = new StyleableDoubleProperty(1.0){

        public String getName() {
            return "markerHeight";
        }

        public Object getBean() {
            return TrimPolygonMarker.this;
        }

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return MARKER_HEIGHT;
        }
    };

    public TrimPolygonMarker() {
        this.initListeners();
    }

    public TrimPolygonMarker(double ... points) {
        super(points);
        this.initListeners();
    }

    public void setPoints(double ... points) {
        if (points != null) {
            this.getPoints().clear();
            for (double d : points) {
                this.getPoints().add((Object)d);
            }
            this.updateWidth(1.0, this.markerWidth.get());
            this.updateHeight(1.0, this.markerHeight.get());
        }
    }

    private void initListeners() {
        this.markerWidth.addListener((o, oldValue, newValue) -> this.updateWidth((Number)oldValue, (Number)newValue));
        this.markerHeight.addListener((o, oldValue, newValue) -> this.updateHeight((Number)oldValue, (Number)newValue));
    }

    private void updateWidth(Number oldWidth, Number newWidth) {
        double scale = newWidth.doubleValue() / oldWidth.doubleValue();
        ObservableList points = this.getPoints();
        for (int i = 0; i < points.size(); i += 2) {
            points.set(i, (Object)(scale * (Double)points.get(i)));
        }
    }

    private void updateHeight(Number oldHeight, Number newHeight) {
        double scale = newHeight.doubleValue() / oldHeight.doubleValue();
        ObservableList points = this.getPoints();
        for (int i = 1; i < points.size(); i += 2) {
            points.set(i, (Object)(scale * (Double)points.get(i)));
        }
    }

    public void setMarkerWidth(double width) {
        this.markerWidth.set(width);
    }

    public double getMarkerWidth() {
        return this.markerWidth.get();
    }

    public DoubleProperty markWidthProperty() {
        return this.markerWidth;
    }

    public void setMarkerHeight(double height) {
        this.markerHeight.set(height);
    }

    public double getMarkerHeight() {
        return this.markerHeight.get();
    }

    public DoubleProperty markHeightProperty() {
        return this.markerHeight;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return FACTORY.getCssMetaData();
    }
}

