/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DataFormat;
import javafx.scene.input.Dragboard;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.yoGraphic.YoGraphicFXControllerTools;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoCompositeSearchManager;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoComposite;
import us.ihmc.scs2.sessionVisualizer.jfx.yoComposite.YoCompositeCollection;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicFXItem;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGraphicTools;
import us.ihmc.scs2.sessionVisualizer.jfx.yoGraphic.YoGroupFX;

public class DragAndDropTools {
    public static final DataFormat YO_COMPOSITE_REFERENCE = new DataFormat(new String[]{"Reference to a YoComposite, List<String> of 2 elements: 0-type of the YoComposite, 1-the ownerFullname."});
    public static final DataFormat YO_COMPOSITE_LIST_REFERENCE = new DataFormat(new String[]{"Reference to a list of YoComposites, List<String> of 2xN elements: 0-type of the YoComposite, 1-the ownerFullname; and N is the number of YoComposites in the list."});
    public static final DataFormat YO_GRAPHIC_ITEMS_REFERENCE = new DataFormat(new String[]{"Reference to a list of YoGraphicFXItems, per YoGraphicFXItem there are 3 elements: 0-type of the item, 1-the item name, 2-the item namespace."});

    public static List<YoComposite> retrieveYoCompositesFromDragBoard(Dragboard dragboard, YoCompositeSearchManager searchManager) {
        if (dragboard.hasContent(YO_COMPOSITE_REFERENCE)) {
            String fullname;
            List content = (List)dragboard.getContent(YO_COMPOSITE_REFERENCE);
            String type = (String)content.get(0);
            YoComposite yoComposite = searchManager.getYoComposite(type, fullname = (String)content.get(1));
            return yoComposite == null ? null : Collections.singletonList(yoComposite);
        }
        if (dragboard.hasContent(YO_COMPOSITE_LIST_REFERENCE)) {
            List content = (List)dragboard.getContent(YO_COMPOSITE_LIST_REFERENCE);
            ArrayList<YoComposite> compositeList = new ArrayList<YoComposite>();
            for (int i = 0; i < content.size(); i += 2) {
                String fullname;
                String type = (String)content.get(i);
                YoComposite yoComposite = searchManager.getYoComposite(type, fullname = (String)content.get(i + 1));
                if (yoComposite == null) continue;
                compositeList.add(yoComposite);
            }
            return compositeList.isEmpty() ? null : compositeList;
        }
        return null;
    }

    public static List<YoComposite> retrieveYoCompositesFromDragBoard(Dragboard dragboard, YoCompositeCollection yoCompositeCollection) {
        if (dragboard.hasContent(YO_COMPOSITE_REFERENCE)) {
            List content = (List)dragboard.getContent(YO_COMPOSITE_REFERENCE);
            String type = (String)content.get(0);
            if (!type.equals(yoCompositeCollection.getPattern().getType())) {
                return null;
            }
            String fullname = (String)content.get(1);
            YoComposite yoComposite = yoCompositeCollection.getYoCompositeFromFullname(fullname);
            return yoComposite == null ? null : Collections.singletonList(yoComposite);
        }
        if (dragboard.hasContent(YO_COMPOSITE_LIST_REFERENCE)) {
            List content = (List)dragboard.getContent(YO_COMPOSITE_REFERENCE);
            ArrayList<YoComposite> compositeList = new ArrayList<YoComposite>();
            for (int i = 0; i < content.size(); i += 2) {
                String type = (String)content.get(i);
                if (!type.equals(yoCompositeCollection.getPattern().getType())) continue;
                String fullname = (String)content.get(i + 1);
                compositeList.add(yoCompositeCollection.getYoCompositeFromFullname(fullname));
            }
            return compositeList.isEmpty() ? null : compositeList;
        }
        return null;
    }

    public static ClipboardContent toClipboardContent(List<? extends YoGraphicFXItem> items) {
        ArrayList<String> content = new ArrayList<String>();
        for (YoGraphicFXItem yoGraphicFXItem : items) {
            String itemType = yoGraphicFXItem.getClass().getSimpleName();
            if (itemType == null) {
                throw new RuntimeException("Unexpected item type: " + yoGraphicFXItem.getClass());
            }
            String itemName = yoGraphicFXItem.getName();
            String itemNamespace = yoGraphicFXItem.getNamespace();
            content.addAll(Arrays.asList(itemType, itemName, itemNamespace));
        }
        ClipboardContent clipboardContent = new ClipboardContent();
        clipboardContent.put((Object)YO_GRAPHIC_ITEMS_REFERENCE, content);
        return clipboardContent;
    }

    public static List<YoGraphicFXItem> retrieveYoGraphicFXItemsFromDragBoard(Dragboard dragboard, YoGroupFX rootGroup) {
        if (!dragboard.hasContent(YO_GRAPHIC_ITEMS_REFERENCE)) {
            return null;
        }
        ArrayList<YoGraphicFXItem> items = new ArrayList<YoGraphicFXItem>();
        List content = (List)dragboard.getContent(YO_GRAPHIC_ITEMS_REFERENCE);
        for (int i = 0; i < content.size(); i += 3) {
            String itemTypeName = (String)content.get(i);
            Class itemType = YoGraphicFXControllerTools.yoGraphicFXTypes.stream().filter(type -> type.getSimpleName().equals(itemTypeName)).findFirst().get();
            String itemName = (String)content.get(i + 1);
            String itemNamespace = (String)content.get(i + 2);
            Object item = YoGraphicTools.findYoGraphicFXItem(rootGroup, itemNamespace, itemName, itemType);
            if (item == null) continue;
            items.add((YoGraphicFXItem)item);
        }
        if (items.isEmpty()) {
            return null;
        }
        return items;
    }
}

