/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.session.log;

import java.io.File;
import java.io.IOException;
import org.jcodec.containers.mp4.MP4Packet;
import us.ihmc.codecs.builder.H264Settings;
import us.ihmc.codecs.builder.MP4H264MovieBuilder;
import us.ihmc.codecs.builder.MP4MJPEGMovieBuilder;
import us.ihmc.codecs.demuxer.MP4VideoDemuxer;
import us.ihmc.codecs.generated.EProfileIdc;
import us.ihmc.codecs.generated.YUVPicture;
import us.ihmc.scs2.session.log.ProgressConsumer;

public class VideoConverter {
    public static int crop(File source, File target, long startPTS, long endPTS, ProgressConsumer progressConsumer) throws IOException {
        MP4Packet frame;
        MP4MJPEGMovieBuilder builder = null;
        MP4VideoDemuxer demuxer = new MP4VideoDemuxer(source);
        int frameRate = VideoConverter.getFrameRate(demuxer);
        long endFrame = VideoConverter.getFrame(endPTS, demuxer);
        long startFrame = VideoConverter.getFrame(startPTS, demuxer);
        long numberOfFrames = endFrame - startFrame;
        while ((frame = demuxer.getNextPacket()) != null && demuxer.getCurrentFrame() <= endFrame) {
            if (builder == null) {
                builder = new MP4MJPEGMovieBuilder(target, demuxer.getWidth(), demuxer.getHeight(), frameRate, 1);
            }
            builder.encodeFrame(frame.getData());
            if (progressConsumer == null) continue;
            progressConsumer.progress((double)(demuxer.getCurrentFrame() - startFrame) / (double)numberOfFrames);
        }
        if (builder != null) {
            builder.close();
        }
        demuxer.delete();
        return frameRate;
    }

    public static void convert(File source, File target, long startPTS, long endPTS, ProgressConsumer progressConsumer) throws IOException {
        YUVPicture frame;
        MP4H264MovieBuilder builder = null;
        MP4VideoDemuxer demuxer = new MP4VideoDemuxer(source);
        H264Settings settings = new H264Settings();
        settings.setBitrate(10000);
        settings.setProfileIdc(EProfileIdc.PRO_HIGH);
        int frameRate = VideoConverter.getFrameRate(demuxer);
        long endFrame = VideoConverter.getFrame(endPTS, demuxer);
        long startFrame = VideoConverter.getFrame(startPTS, demuxer);
        long numberOfFrames = endFrame - startFrame;
        while ((frame = demuxer.getNextFrame()) != null && demuxer.getCurrentFrame() <= endFrame) {
            if (builder == null) {
                builder = new MP4H264MovieBuilder(target, frame.getWidth(), frame.getHeight(), frameRate, settings);
            }
            builder.encodeFrame(frame);
            frame.delete();
            if (progressConsumer == null) continue;
            progressConsumer.progress((double)((int)((double)(demuxer.getCurrentFrame() - startFrame) / (double)numberOfFrames)));
        }
        builder.close();
        demuxer.delete();
    }

    private static int getFrameRate(MP4VideoDemuxer demuxer) throws IOException {
        demuxer.seekToFrame(0L);
        long startPts = demuxer.getCurrentPTS();
        demuxer.seekToFrame(1L);
        long endPts = demuxer.getCurrentPTS();
        double step = endPts - startPts;
        int rate = (int)Math.round((double)demuxer.getTimescale() / step);
        System.out.println("Framerate is " + rate);
        return rate;
    }

    private static long getFrame(long endPTS, MP4VideoDemuxer demuxer) throws IOException {
        demuxer.seekToPTS(endPTS);
        long endFrame = demuxer.getCurrentFrame();
        return endFrame;
    }
}

