/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.menu;

import java.util.function.UnaryOperator;
import javafx.beans.property.Property;
import javafx.fxml.FXML;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;
import org.apache.commons.lang3.mutable.MutableBoolean;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.scs2.session.SessionState;
import us.ihmc.scs2.sessionVisualizer.jfx.SessionVisualizerTopics;
import us.ihmc.scs2.sessionVisualizer.jfx.controllers.VisualizerController;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.SessionVisualizerWindowToolkit;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.PositiveIntegerValueFilter;
import us.ihmc.scs2.sharedMemory.CropBufferRequest;
import us.ihmc.scs2.sharedMemory.FillBufferRequest;
import us.ihmc.scs2.sharedMemory.interfaces.YoBufferPropertiesReadOnly;
import us.ihmc.scs2.sharedMemory.tools.SharedMemoryTools;

public class DataBufferMenuController
implements VisualizerController {
    @FXML
    private Menu menu;
    @FXML
    private TextField bufferSizeTextField;
    @FXML
    private TextField bufferRecordTickPeriodTextField;
    @FXML
    private Spinner<Integer> numberPrecisionSpinner;
    @FXML
    private MenuItem sizeMenuItem;
    @FXML
    private CheckMenuItem showSCS2YoVariablesMenuItem;
    private JavaFXMessager messager;
    private SessionVisualizerTopics topics;
    private boolean initializeBufferSizeTextField = true;
    private Property<YoBufferPropertiesReadOnly> bufferProperties;

    @Override
    public void initialize(SessionVisualizerWindowToolkit toolkit) {
        this.messager = toolkit.getMessager();
        this.topics = toolkit.getTopics();
        this.bufferProperties = this.messager.createPropertyInput(this.topics.getYoBufferCurrentProperties(), null);
        this.messager.registerTopicListener(this.topics.getSessionCurrentState(), m -> {
            if (m == SessionState.INACTIVE) {
                this.initializeBufferSizeTextField = true;
            }
        });
        this.messager.registerJavaFXSyncedTopicListener(this.topics.getDisableUserControls(), disable -> this.menu.setDisable(disable.booleanValue()));
        TextFormatter bufferSizeFormatter = new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)0, (UnaryOperator)new PositiveIntegerValueFilter());
        this.bufferSizeTextField.setTextFormatter(bufferSizeFormatter);
        this.bufferSizeTextField.setOnAction(e -> {});
        MutableBoolean updatingBufferResize = new MutableBoolean(false);
        this.bufferProperties.addListener((o, oldValue, newValue) -> {
            if (!(this.initializeBufferSizeTextField || oldValue != null && newValue.getSize() != oldValue.getSize())) {
                return;
            }
            if (updatingBufferResize.isFalse()) {
                updatingBufferResize.setTrue();
                bufferSizeFormatter.setValue((Object)newValue.getSize());
                this.initializeBufferSizeTextField = false;
                updatingBufferResize.setFalse();
            }
        });
        bufferSizeFormatter.valueProperty().addListener((o, oldValue, newValue) -> {
            if (this.bufferProperties.getValue() != null && ((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getSize() == newValue.intValue()) {
                return;
            }
            if (updatingBufferResize.isFalse()) {
                updatingBufferResize.setTrue();
                this.messager.submitMessage(this.topics.getYoBufferCurrentSizeRequest(), newValue);
                updatingBufferResize.setFalse();
            }
        });
        TextFormatter recordPeriodFormatter = new TextFormatter((StringConverter)new IntegerStringConverter(), (Object)0, (UnaryOperator)new PositiveIntegerValueFilter());
        this.bufferRecordTickPeriodTextField.setTextFormatter(recordPeriodFormatter);
        this.bufferRecordTickPeriodTextField.setOnAction(e -> {});
        this.messager.bindBidirectional(this.topics.getBufferRecordTickPeriod(), (Property)recordPeriodFormatter.valueProperty(), false);
        SpinnerValueFactory.IntegerSpinnerValueFactory numberPrecisionSpinnerValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 30, 3, 1);
        this.numberPrecisionSpinner.setValueFactory((SpinnerValueFactory)numberPrecisionSpinnerValueFactory);
        if (this.numberPrecisionSpinner.isEditable()) {
            this.numberPrecisionSpinner.focusedProperty().addListener((o, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.numberPrecisionSpinner.getEditor().setText(numberPrecisionSpinnerValueFactory.getConverter().toString(numberPrecisionSpinnerValueFactory.getValue()));
                }
            });
        }
        this.messager.bindBidirectional(this.topics.getControlsNumberPrecision(), (Property)numberPrecisionSpinnerValueFactory.valueProperty(), false);
        this.messager.bindBidirectional(this.topics.getShowSCS2YoVariables(), (Property)this.showSCS2YoVariablesMenuItem.selectedProperty(), false);
    }

    @FXML
    private void requestCropDataBuffer() {
        if (this.bufferProperties.getValue() != null) {
            CropBufferRequest cropBufferRequest = new CropBufferRequest(((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getInPoint(), ((YoBufferPropertiesReadOnly)this.bufferProperties.getValue()).getOutPoint());
            this.messager.submitMessage(this.topics.getYoBufferCropRequest(), (Object)cropBufferRequest);
        }
    }

    @FXML
    private void requestFlushDataBuffer() {
        YoBufferPropertiesReadOnly properties = (YoBufferPropertiesReadOnly)this.bufferProperties.getValue();
        if (properties != null) {
            FillBufferRequest fillBufferRequest = new FillBufferRequest(false, SharedMemoryTools.increment((int)properties.getOutPoint(), (int)1, (int)properties.getSize()), SharedMemoryTools.decrement((int)properties.getInPoint(), (int)1, (int)properties.getSize()));
            this.messager.submitMessage(this.topics.getYoBufferFillRequest(), (Object)fillBufferRequest);
        }
    }
}

