/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.yoRobot;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.util.Duration;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.ReferenceFrameManager;
import us.ihmc.scs2.sessionVisualizer.jfx.managers.YoManager;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.FrameNode;
import us.ihmc.scs2.sessionVisualizer.jfx.multiBodySystem.RigidBodyFrameNodeFactories;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.JavaFXMissingTools;
import us.ihmc.scs2.sharedMemory.LinkedYoRegistry;
import us.ihmc.scs2.sharedMemory.LinkedYoVariable;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoRobotFX {
    private final Group rootNode = new Group();
    private final RobotDefinition robotDefinition;
    private final YoManager yoManager;
    private final ReferenceFrameManager referenceFrameManager;
    private RigidBodyBasics rootBody;
    private YoRegistry robotRegistry;
    private ObservableMap<String, FrameNode> rigidBodyFrameNodeMap = FXCollections.observableMap(new ConcurrentHashMap(64));
    private LinkedYoRegistry robotLinkedYoRegistry;
    private boolean initialize = true;

    public YoRobotFX(YoManager yoManager, ReferenceFrameManager referenceFrameManager, RobotDefinition robotDefinition) {
        this.yoManager = yoManager;
        this.referenceFrameManager = referenceFrameManager;
        this.robotDefinition = robotDefinition;
    }

    public void loadRobot(Executor graphicLoader) {
        LogTools.info((String)("Loading robot: " + this.robotDefinition.getName()));
        YoRegistry rootRegistry = new YoRegistry("root");
        Robot robot = new Robot(this.robotDefinition, this.referenceFrameManager.getWorldFrame(), false);
        this.robotRegistry = robot.getRegistry();
        rootRegistry.addChild(this.robotRegistry);
        this.rootBody = robot.getRootBody();
        this.rigidBodyFrameNodeMap.addListener(change -> {
            if (change.wasRemoved()) {
                FrameNode removedNode = (FrameNode)change.getValueRemoved();
                JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> this.rootNode.getChildren().remove((Object)removedNode.getNode()));
            } else if (change.wasAdded()) {
                FrameNode addedNode = (FrameNode)change.getValueAdded();
                Node node = addedNode.getNode();
                node.setScaleX(0.0);
                node.setScaleY(0.0);
                node.setScaleZ(0.0);
                Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{new KeyValue((WritableValue)node.scaleXProperty(), (Object)1.0), new KeyValue((WritableValue)node.scaleYProperty(), (Object)1.0), new KeyValue((WritableValue)node.scaleZProperty(), (Object)1.0)})});
                timeline.setCycleCount(1);
                JavaFXMissingTools.runLaterIfNeeded(this.getClass(), () -> {
                    addedNode.updatePose();
                    timeline.playFromStart();
                    this.rootNode.getChildren().add((Object)addedNode.getNode());
                });
            }
        });
        RigidBodyFrameNodeFactories.createRobotFrameNodeMap((RigidBodyReadOnly)this.rootBody, this.robotDefinition, graphicLoader, this.rigidBodyFrameNodeMap);
        LogTools.info((String)("Loaded robot: " + this.robotDefinition.getName()));
        this.attachRobotToScene();
    }

    private void attachRobotToScene() {
        this.robotLinkedYoRegistry = this.yoManager.newLinkedYoRegistry(this.robotRegistry);
        this.robotRegistry.getVariables().forEach(var -> {
            if (var.getName().startsWith("q_")) {
                LinkedYoVariable linkYoVariable = this.robotLinkedYoRegistry.linkYoVariable(var);
                linkYoVariable.addUser((Object)this);
            }
        });
    }

    public void render() {
        if (this.rootBody != null && this.robotLinkedYoRegistry != null && (this.robotLinkedYoRegistry.pull() || this.initialize)) {
            this.rootBody.updateFramesRecursively();
            this.rigidBodyFrameNodeMap.values().forEach(node -> node.updatePose());
            this.initialize = false;
        }
    }

    public RigidBodyReadOnly getRootBody() {
        return this.rootBody;
    }

    public RigidBodyBasics findRigidBody(String rigidBodyName) {
        return MultiBodySystemTools.findRigidBody((RigidBodyBasics)this.rootBody, (String)rigidBodyName);
    }

    public FrameNode findRigidBodyFrameNode(String rigidBodyName) {
        return (FrameNode)this.rigidBodyFrameNodeMap.get((Object)rigidBodyName);
    }

    public RobotDefinition getRobotDefinition() {
        return this.robotDefinition;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    public boolean isRobotLoaded() {
        return !this.initialize;
    }
}

