/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import com.jfoenix.controls.JFXSlider;
import com.jfoenix.skins.JFXSliderSkin;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Orientation;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.layout.StackPane;
import javafx.util.Duration;
import us.ihmc.commons.MathTools;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.CropSlider;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.TrimPolygonMarker;

public class CropSliderSkin
extends JFXSliderSkin {
    private static final String ORIENTATION = "ORIENTATION";
    private static final String INDICATOR_POSITION = "INDICATOR_POSITION";
    private static final String TRIM_START_VALUE = "TRIM_START_VALUE";
    private static final String TRIM_END_VALUE = "TRIM_END_VALUE";
    private static final String TRIM_SHOW = "TRIM_SHOW";
    private static final double markerSlopeRatio = 0.45;
    private static final double[] underLeftHorizontalTrim = new double[]{0.0, 0.0, 0.0, 1.0, -1.0, 1.0, -1.0, 0.45};
    private static final double[] underRightHorizontalTrim = new double[]{0.0, 0.0, 1.0, 0.45, 1.0, 1.0, 0.0, 1.0};
    private static final double[] aboveLeftHorizontalTrim = new double[]{0.0, 0.0, 0.0, -1.0, -1.0, -1.0, -1.0, -0.45};
    private static final double[] aboveRightHorizontalTrim = new double[]{0.0, 0.0, 1.0, -0.45, 1.0, -1.0, 0.0, -1.0};
    private static final double[] leftTopVerticalTrim = new double[]{0.0, 0.0, -1.0, 0.0, -1.0, -1.0, -0.45, -1.0};
    private static final double[] leftBottomVerticalTrim = new double[]{0.0, 0.0, -1.0, 0.0, -1.0, 1.0, -0.45, 1.0};
    private static final double[] rightTopVerticalTrim = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, -1.0, 0.45, -1.0};
    private static final double[] rightBottomVerticalTrim = new double[]{0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.45, 1.0};
    private StackPane thumb = (StackPane)((Slider)this.getSkinnable()).lookup(".thumb");
    private TrimPolygonMarker trimStart = new TrimPolygonMarker(underLeftHorizontalTrim);
    private TrimPolygonMarker trimEnd;
    private Timeline timeline;
    private double thumbWidth;
    private double thumbHeight;
    private double trackStart;
    private double trackLength;
    private boolean isValid = false;
    private Point2D dragStart;
    private double preDragTrimMarkerPosition;
    private boolean boundValueToTrimMarker;

    public CropSliderSkin(CropSlider slider) {
        super((JFXSlider)slider);
        this.trimStart.getStyleClass().add((Object)"trim-start");
        this.trimStart.setScaleX(0.0);
        this.trimStart.setScaleY(0.0);
        this.initTrimMarkerListeners((Node)this.trimStart, slider.trimStartValueProperty(), slider.trimStartValueChangingProperty());
        this.trimEnd = new TrimPolygonMarker(underRightHorizontalTrim);
        this.trimEnd.getStyleClass().add((Object)"trim-end");
        this.trimEnd.setScaleX(0.0);
        this.trimEnd.setScaleY(0.0);
        this.initTrimMarkerListeners((Node)this.trimEnd, slider.trimEndValueProperty(), slider.trimEndValueChangingProperty());
        this.initAnimation();
        this.getChildren().add(1, (Object)this.trimEnd);
        this.getChildren().add(1, (Object)this.trimStart);
        this.registerChangeListener((ObservableValue)slider.orientationProperty(), ORIENTATION);
        this.registerChangeListener((ObservableValue)slider.indicatorPositionProperty(), INDICATOR_POSITION);
        this.registerChangeListener((ObservableValue)slider.trimStartValueProperty(), TRIM_START_VALUE);
        this.registerChangeListener((ObservableValue)slider.trimStartValueProperty(), TRIM_START_VALUE);
        this.registerChangeListener((ObservableValue)slider.trimEndValueProperty(), TRIM_END_VALUE);
        this.registerChangeListener((ObservableValue)slider.showTrimProperty(), TRIM_SHOW);
    }

    private void initTrimMarkerListeners(Node marker, DoubleProperty valueProperty, BooleanProperty valueChangingProperty) {
        marker.setOnMousePressed(e -> {
            CropSlider slider = this.getSlider();
            if (!slider.isFocused()) {
                slider.requestFocus();
            }
            valueChangingProperty.set(true);
            this.dragStart = marker.localToParent(e.getX(), e.getY());
            this.preDragTrimMarkerPosition = this.normalize(valueProperty.get());
            if (!slider.valueProperty().isBound()) {
                slider.valueProperty().bind((ObservableValue)valueProperty);
                this.boundValueToTrimMarker = true;
            }
            this.thumb.fireEvent(e);
        });
        marker.setOnMouseReleased(e -> {
            CropSlider slider = this.getSlider();
            valueChangingProperty.set(false);
            slider.adjustValue(valueProperty.get());
            if (this.boundValueToTrimMarker) {
                slider.valueProperty().unbind();
            }
            this.boundValueToTrimMarker = false;
            this.thumb.fireEvent(e);
        });
        marker.setOnMouseDragged(e -> {
            Point2D current = marker.localToParent(e.getX(), e.getY());
            double dragPos = this.getOrientation() == Orientation.HORIZONTAL ? current.getX() - this.dragStart.getX() : -(current.getY() - this.dragStart.getY());
            double position = this.preDragTrimMarkerPosition + dragPos / this.trackLength;
            valueProperty.set(this.unnormalize(position));
        });
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        super.layoutChildren(x, y, w, h);
        if (!this.isValid) {
            this.updateTrimMarkerPosition();
            this.initAnimation();
            this.isValid = true;
        }
        this.thumbWidth = this.snapSize(this.thumb.prefWidth(-1.0));
        this.thumbHeight = this.snapSize(this.thumb.prefHeight(-1.0));
        if (((Slider)this.getSkinnable()).getOrientation() == Orientation.HORIZONTAL) {
            this.trackLength = this.snapSize(w - this.thumbWidth);
            this.trackStart = this.snapPosition(x + this.thumbWidth / 2.0);
        } else {
            this.trackLength = this.snapSize(h - this.thumbHeight);
            this.trackStart = this.snapPosition(y + this.thumbHeight / 2.0);
        }
        double prefWidth = this.trimStart.prefWidth(-1.0);
        this.trimStart.resize(prefWidth, this.trimStart.prefHeight(prefWidth));
        prefWidth = this.trimEnd.prefWidth(-1.0);
        this.trimEnd.resize(prefWidth, this.trimEnd.prefHeight(prefWidth));
        this.positionTrimMarker(false, (Node)this.trimStart, this.getSlider().trimStartValueProperty());
        this.positionTrimMarker(false, (Node)this.trimEnd, this.getSlider().trimEndValueProperty());
    }

    protected void handleControlPropertyChanged(String p) {
        switch (p) {
            case "ORIENTATION": 
            case "INDICATOR_POSITION": {
                this.updateTrimMarkerPosition();
                this.initAnimation();
                break;
            }
            case "TRIM_START_VALUE": {
                this.positionTrimMarker(false, (Node)this.trimStart, this.getSlider().trimStartValueProperty());
                break;
            }
            case "TRIM_END_VALUE": {
                this.positionTrimMarker(false, (Node)this.trimEnd, this.getSlider().trimEndValueProperty());
                break;
            }
            case "TRIM_SHOW": {
                this.updateTrimMarkerPosition();
                this.timeline.setRate(this.getSlider().isShowTrim() ? 1.0 : -1.0);
                this.timeline.play();
            }
        }
    }

    private void updateTrimMarkerPosition() {
        Orientation orientation = this.getOrientation();
        if (orientation == Orientation.HORIZONTAL) {
            if (this.getIndicatorPosition() == JFXSlider.IndicatorPosition.LEFT) {
                this.trimStart.setPoints(underLeftHorizontalTrim);
                this.trimEnd.setPoints(underRightHorizontalTrim);
            } else {
                this.trimStart.setPoints(aboveLeftHorizontalTrim);
                this.trimEnd.setPoints(aboveRightHorizontalTrim);
            }
        } else if (this.getIndicatorPosition() == JFXSlider.IndicatorPosition.LEFT) {
            this.trimStart.setPoints(rightBottomVerticalTrim);
            this.trimEnd.setPoints(rightTopVerticalTrim);
        } else {
            this.trimStart.setPoints(leftBottomVerticalTrim);
            this.trimEnd.setPoints(leftTopVerticalTrim);
        }
    }

    private void positionTrimMarker(boolean animate, final Node marker, DoubleProperty markerValue) {
        CropSlider slider = this.getSlider();
        if (slider.getTrimStartValue() > slider.getMax()) {
            return;
        }
        boolean horizontal = slider.getOrientation() == Orientation.HORIZONTAL;
        double normalizedValue = this.normalize(markerValue.get());
        final double endX = horizontal ? this.trackStart + this.trackLength * normalizedValue : this.thumb.getLayoutX();
        final double endY = horizontal ? this.thumb.getLayoutY() : this.snappedTopInset() + this.trackLength * (1.0 - normalizedValue) + this.thumbHeight / 2.0;
        if (animate) {
            final double startX = marker.getLayoutX();
            final double startY = marker.getLayoutY();
            Transition transition = new Transition(){
                {
                    this.setCycleDuration(Duration.millis((double)200.0));
                }

                protected void interpolate(double fraction) {
                    if (!Double.isNaN(startX)) {
                        marker.setLayoutX(startX + fraction * (endX - startX));
                    }
                    if (!Double.isNaN(startY)) {
                        marker.setLayoutY(startY + fraction * (endY - startY));
                    }
                }
            };
            transition.play();
        } else {
            marker.setLayoutX(endX);
            marker.setLayoutY(endY);
        }
    }

    private void initAnimation() {
        DoubleProperty endLayoutProperty;
        DoubleProperty startLayoutProperty;
        double endTrimNewPos;
        double endTrimPos;
        double startTrimNewPos;
        double startTrimPos;
        double factorThumb;
        double gap = this.getIndicatorPosition() == JFXSlider.IndicatorPosition.LEFT ? this.getTrimGap() : -this.getTrimGap();
        double d = factorThumb = this.getIndicatorPosition() == JFXSlider.IndicatorPosition.LEFT ? 1.0 : 0.0;
        if (this.getOrientation() == Orientation.HORIZONTAL) {
            startTrimPos = this.thumb.getLayoutY();
            startTrimNewPos = startTrimPos + factorThumb * this.thumb.getHeight() + gap;
            endTrimPos = this.thumb.getLayoutY();
            endTrimNewPos = endTrimPos + factorThumb * this.thumb.getHeight() + gap;
            startLayoutProperty = this.trimStart.translateYProperty();
            endLayoutProperty = this.trimEnd.translateYProperty();
        } else {
            startTrimPos = this.thumb.getLayoutX();
            startTrimNewPos = startTrimPos + factorThumb * this.thumb.getWidth() + gap;
            endTrimPos = this.thumb.getLayoutX();
            endTrimNewPos = endTrimPos + factorThumb * this.thumb.getWidth() + gap;
            startLayoutProperty = this.trimStart.translateXProperty();
            endLayoutProperty = this.trimEnd.translateXProperty();
        }
        Timeline newTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.trimStart.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.trimStart.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)startLayoutProperty, (Object)startTrimPos, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.trimEnd.scaleXProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.trimEnd.scaleYProperty(), (Object)0, Interpolator.EASE_BOTH), new KeyValue((WritableValue)endLayoutProperty, (Object)endTrimPos, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.seconds((double)0.2), new KeyValue[]{new KeyValue((WritableValue)this.trimStart.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.trimStart.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)startLayoutProperty, (Object)startTrimNewPos, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.trimEnd.scaleXProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)this.trimEnd.scaleYProperty(), (Object)1, Interpolator.EASE_BOTH), new KeyValue((WritableValue)endLayoutProperty, (Object)endTrimNewPos, Interpolator.EASE_BOTH)})});
        this.clearAnimation();
        this.timeline = newTimeline;
    }

    private double unnormalize(double normalizedValue) {
        double value = normalizedValue * (this.getSlider().getMax() - this.getSlider().getMin()) + this.getSlider().getMin();
        return MathTools.clamp((double)value, (double)this.getSlider().getMin(), (double)this.getSlider().getMax());
    }

    private double normalize(double value) {
        return (value - this.getSlider().getMin()) / (this.getSlider().getMax() - this.getSlider().getMin());
    }

    private Orientation getOrientation() {
        return this.getSlider().getOrientation();
    }

    private JFXSlider.IndicatorPosition getIndicatorPosition() {
        return this.getSlider().getIndicatorPosition();
    }

    private double getTrimGap() {
        return this.getSlider().getTrimGap();
    }

    private CropSlider getSlider() {
        return (CropSlider)this.getSkinnable();
    }

    public void dispose() {
        super.dispose();
        this.clearAnimation();
    }

    private void clearAnimation() {
        if (this.timeline != null) {
            this.timeline.stop();
            this.timeline.getKeyFrames().clear();
            this.timeline = null;
        }
    }
}

