/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.controllers.chart;

import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import us.ihmc.scs2.sessionVisualizer.jfx.charts.NumberSeries;
import us.ihmc.scs2.sessionVisualizer.jfx.tools.ChartTools;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoNumberSeries
extends NumberSeries {
    private final YoVariable yoVariable;
    private final AtomicBoolean dirty = new AtomicBoolean(true);
    private final Property<Integer> precision;
    private final YoVariableChangedListener dirtyYoListener = v -> this.dirty.set(true);
    private final ChangeListener<Number> dirtyPropertyListener = (o, oldValue, newValue) -> this.dirty.set(true);

    public YoNumberSeries(YoVariable yoVariable, Property<Integer> precision) {
        super(yoVariable.getName());
        this.yoVariable = yoVariable;
        this.precision = precision;
        yoVariable.addListener(this.dirtyYoListener);
        precision.addListener(this.dirtyPropertyListener);
    }

    public void updateLegend() {
        if (this.dirty.getAndSet(false)) {
            this.setCurrentValue(ChartTools.defaultYoVariableValueFormatter(this.yoVariable, Math.max(5, (Integer)this.precision.getValue())));
        }
    }

    public YoVariable getYoVariable() {
        return this.yoVariable;
    }

    public void close() {
        this.yoVariable.removeListener(this.dirtyYoListener);
        this.precision.removeListener(this.dirtyPropertyListener);
    }
}

