/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.sessionVisualizer.jfx.tools;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class ContextMenuTools {
    @SafeVarargs
    public static <T extends Node> void setupContextMenu(T owner, Function<T, MenuItem> ... menuItemFactories) {
        BiFunction[] factoryAdapters = (BiFunction[])Stream.of(menuItemFactories).map(factory -> (t, u) -> (MenuItem)factory.apply(t)).toArray(BiFunction[]::new);
        ContextMenuTools.setupContextMenu(owner, factoryAdapters);
    }

    @SafeVarargs
    public static <T extends Node> void setupContextMenu(T owner, BiFunction<T, MouseEvent, MenuItem> ... menuItemFactories) {
        SimpleObjectProperty activeContexMenu = new SimpleObjectProperty(owner, "activeContextMenu", null);
        owner.addEventHandler(MouseEvent.MOUSE_RELEASED, arg_0 -> ContextMenuTools.lambda$setupContextMenu$7((ObjectProperty)activeContexMenu, menuItemFactories, owner, arg_0));
    }

    private static /* synthetic */ void lambda$setupContextMenu$7(ObjectProperty activeContexMenu, BiFunction[] menuItemFactories, Node owner, MouseEvent e) {
        MenuItem[] menuItems;
        if (e.getButton() != MouseButton.SECONDARY || !e.isStillSincePress()) {
            return;
        }
        if (activeContexMenu.get() != null) {
            ((ContextMenu)activeContexMenu.get()).hide();
            activeContexMenu.set(null);
        }
        if ((menuItems = (MenuItem[])Stream.of(menuItemFactories).map(factory -> (MenuItem)factory.apply(owner, e)).filter(item -> item != null).toArray(MenuItem[]::new)).length == 0) {
            return;
        }
        ContextMenu contextMenu = new ContextMenu(menuItems);
        contextMenu.show(owner, e.getScreenX(), e.getScreenY());
        contextMenu.setAutoFix(true);
        contextMenu.setAutoHide(true);
        activeContexMenu.set((Object)contextMenu);
        owner.addEventFilter(MouseEvent.MOUSE_PRESSED, e2 -> {
            contextMenu.hide();
            activeContexMenu.set(null);
        });
        e.consume();
    }
}

